package io.qt.qt3d.input;

import io.qt.*;


/**
 * <p>Provides a means of being notified about mouse events when attached to a QMouseDevice instance</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html">Qt3DInput::QMouseHandler</a></code></p>
 */
public class QMouseHandler extends io.qt.qt3d.core.QComponent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMouseHandler.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#clicked">Qt3DInput::QMouseHandler::<wbr/>clicked(Qt3DInput::QMouseEvent*)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.qt3d.input.@Nullable QMouseEvent> clicked = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#containsMouse-prop">Qt3DInput::QMouseHandler::<wbr/>containsMouseChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="containsMouse")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> containsMouseChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#doubleClicked">Qt3DInput::QMouseHandler::<wbr/>doubleClicked(Qt3DInput::QMouseEvent*)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.qt3d.input.@Nullable QMouseEvent> doubleClicked = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#entered">Qt3DInput::QMouseHandler::<wbr/>entered()</a></code></p>
     */
    public final @NonNull Signal0 entered = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#exited">Qt3DInput::QMouseHandler::<wbr/>exited()</a></code></p>
     */
    public final @NonNull Signal0 exited = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#positionChanged">Qt3DInput::QMouseHandler::<wbr/>positionChanged(Qt3DInput::QMouseEvent*)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.qt3d.input.@Nullable QMouseEvent> positionChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#pressAndHold">Qt3DInput::QMouseHandler::<wbr/>pressAndHold(Qt3DInput::QMouseEvent*)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.qt3d.input.@Nullable QMouseEvent> pressAndHold = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#pressed">Qt3DInput::QMouseHandler::<wbr/>pressed(Qt3DInput::QMouseEvent*)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.qt3d.input.@Nullable QMouseEvent> pressed = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#released">Qt3DInput::QMouseHandler::<wbr/>released(Qt3DInput::QMouseEvent*)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.qt3d.input.@Nullable QMouseEvent> released = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#sourceDevice-prop">Qt3DInput::QMouseHandler::<wbr/>sourceDeviceChanged(Qt3DInput::QMouseDevice*)</a></code></p>
     */
    @QtPropertyNotify(name="sourceDevice")
    public final @NonNull Signal1<io.qt.qt3d.input.@Nullable QMouseDevice> sourceDeviceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#wheel">Qt3DInput::QMouseHandler::<wbr/>wheel(Qt3DInput::QWheelEvent*)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.qt3d.input.@Nullable QWheelEvent> wheel = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#QMouseHandler">Qt3DInput::QMouseHandler::<wbr/>QMouseHandler(QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QMouseHandler(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QMouseHandler instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#containsMouse-prop">Qt3DInput::QMouseHandler::<wbr/>containsMouse()const</a></code></p>
     */
    @QtPropertyReader(name="containsMouse")
    @QtUninvokable
    public final boolean containsMouse(){
        return containsMouse_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean containsMouse_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>Qt3DInput::QMouseHandler::<wbr/>setContainsMouse(bool)</code></p>
     */
    @QtUninvokable
    protected final void setContainsMouse(boolean contains){
        setContainsMouse_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), contains);
    }
    
    @QtUninvokable
    private native void setContainsMouse_native_bool(long __this__nativeId, boolean contains);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#setSourceDevice">Qt3DInput::QMouseHandler::<wbr/>setSourceDevice(Qt3DInput::QMouseDevice*)</a></code></p>
     */
    @QtPropertyWriter(name="sourceDevice")
    public final void setSourceDevice(io.qt.qt3d.input.@Nullable QMouseDevice mouseDevice){
        setSourceDevice_native_Qt3DInput_QMouseDevice_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(mouseDevice));
    }
    
    private native void setSourceDevice_native_Qt3DInput_QMouseDevice_ptr(long __this__nativeId, long mouseDevice);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#sourceDevice-prop">Qt3DInput::QMouseHandler::<wbr/>sourceDevice()const</a></code></p>
     */
    @QtPropertyReader(name="sourceDevice")
    @QtUninvokable
    public final io.qt.qt3d.input.@Nullable QMouseDevice sourceDevice(){
        return sourceDevice_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.input.QMouseDevice sourceDevice_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QMouseHandler(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QMouseHandler(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QMouseHandler instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QMouseHandler(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QMouseHandler() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #containsMouse()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getContainsMouse() {
        return containsMouse();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #sourceDevice()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.input.@Nullable QMouseDevice getSourceDevice() {
        return sourceDevice();
    }
}
