package io.qt.qt3d.input;

import io.qt.*;


/**
 * <p>Delegates mouse events to the attached MouseHandler objects</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html">Qt3DInput::QMouseDevice</a></code></p>
 */
public class QMouseDevice extends io.qt.qt3d.input.QAbstractPhysicalDevice
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMouseDevice.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html#Axis-enum">Qt3DInput::QMouseDevice::Axis</a></code></p>
     */
    public enum Axis implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html#Axis-enum">Qt3DInput::<wbr/>QMouseDevice::<wbr/>X</a></code></p>
         */
        X(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html#Axis-enum">Qt3DInput::<wbr/>QMouseDevice::<wbr/>Y</a></code></p>
         */
        Y(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html#Axis-enum">Qt3DInput::<wbr/>QMouseDevice::<wbr/>WheelX</a></code></p>
         */
        WheelX(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html#Axis-enum">Qt3DInput::<wbr/>QMouseDevice::<wbr/>WheelY</a></code></p>
         */
        WheelY(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Axis(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Axis resolve(int value) {
            switch (value) {
            case 0: return X;
            case 1: return Y;
            case 2: return WheelX;
            case 3: return WheelY;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html#sensitivity-prop">Qt3DInput::QMouseDevice::<wbr/>sensitivityChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="sensitivity")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> sensitivityChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html#updateAxesContinuously-prop">Qt3DInput::QMouseDevice::<wbr/>updateAxesContinuouslyChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="updateAxesContinuously")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> updateAxesContinuouslyChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html#QMouseDevice">Qt3DInput::QMouseDevice::<wbr/>QMouseDevice(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QMouseDevice(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QMouseDevice instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#axisCount">Qt3DInput::QAbstractPhysicalDevice::<wbr/>axisCount()const</a></code></p>
     */
    public final int axisCount(){
        return axisCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native int axisCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#axisIdentifier">Qt3DInput::QAbstractPhysicalDevice::<wbr/>axisIdentifier(QString)const</a></code></p>
     */
    public final int axisIdentifier(java.lang.@NonNull String name){
        return axisIdentifier_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native int axisIdentifier_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#axisNames">Qt3DInput::QAbstractPhysicalDevice::<wbr/>axisNames()const</a></code></p>
     */
    public final io.qt.core.@NonNull QStringList axisNames(){
        return axisNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native io.qt.core.QStringList axisNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#buttonCount">Qt3DInput::QAbstractPhysicalDevice::<wbr/>buttonCount()const</a></code></p>
     */
    public final int buttonCount(){
        return buttonCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native int buttonCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#buttonIdentifier">Qt3DInput::QAbstractPhysicalDevice::<wbr/>buttonIdentifier(QString)const</a></code></p>
     */
    public final int buttonIdentifier(java.lang.@NonNull String name){
        return buttonIdentifier_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native int buttonIdentifier_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#buttonNames">Qt3DInput::QAbstractPhysicalDevice::<wbr/>buttonNames()const</a></code></p>
     */
    public final io.qt.core.@NonNull QStringList buttonNames(){
        return buttonNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native io.qt.core.QStringList buttonNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html#sensitivity-prop">Qt3DInput::QMouseDevice::<wbr/>sensitivity()const</a></code></p>
     */
    @QtPropertyReader(name="sensitivity")
    @QtUninvokable
    public final float sensitivity(){
        return sensitivity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float sensitivity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html#sensitivity-prop">Qt3DInput::QMouseDevice::<wbr/>setSensitivity(float)</a></code></p>
     */
    @QtPropertyWriter(name="sensitivity")
    public final void setSensitivity(float value){
        setSensitivity_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    private native void setSensitivity_native_float(long __this__nativeId, float value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html#updateAxesContinuously-prop">Qt3DInput::QMouseDevice::<wbr/>setUpdateAxesContinuously(bool)</a></code></p>
     */
    @QtPropertyWriter(name="updateAxesContinuously")
    public final void setUpdateAxesContinuously(boolean updateAxesContinuously){
        setUpdateAxesContinuously_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), updateAxesContinuously);
    }
    
    private native void setUpdateAxesContinuously_native_bool(long __this__nativeId, boolean updateAxesContinuously);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html#updateAxesContinuously-prop">Qt3DInput::QMouseDevice::<wbr/>updateAxesContinuously()const</a></code></p>
     */
    @QtPropertyReader(name="updateAxesContinuously")
    @QtUninvokable
    public final boolean updateAxesContinuously(){
        return updateAxesContinuously_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean updateAxesContinuously_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QMouseDevice(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QMouseDevice(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QMouseDevice instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QMouseDevice(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QMouseDevice() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #sensitivity()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getSensitivity() {
        return sensitivity();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #updateAxesContinuously()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getUpdateAxesContinuously() {
        return updateAxesContinuously();
    }
}
