package io.qt.qt3d.input;


/**
 * <p>Provides a means of being notified about mouse events when attached to a QMouseDevice instance</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html">Qt3DInput::QMouseHandler</a></p>
 */
public class QMouseHandler extends io.qt.qt3d.core.QComponent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMouseHandler.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#clicked">Qt3DInput::QMouseHandler::clicked(Qt3DInput::QMouseEvent*)</a></p>
     */
    public final Signal1<io.qt.qt3d.input.QMouseEvent> clicked = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#containsMouse-prop">Qt3DInput::QMouseHandler::containsMouseChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="containsMouse")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> containsMouseChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#doubleClicked">Qt3DInput::QMouseHandler::doubleClicked(Qt3DInput::QMouseEvent*)</a></p>
     */
    public final Signal1<io.qt.qt3d.input.QMouseEvent> doubleClicked = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#entered">Qt3DInput::QMouseHandler::entered()</a></p>
     */
    public final Signal0 entered = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#exited">Qt3DInput::QMouseHandler::exited()</a></p>
     */
    public final Signal0 exited = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#positionChanged">Qt3DInput::QMouseHandler::positionChanged(Qt3DInput::QMouseEvent*)</a></p>
     */
    public final Signal1<io.qt.qt3d.input.QMouseEvent> positionChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#pressAndHold">Qt3DInput::QMouseHandler::pressAndHold(Qt3DInput::QMouseEvent*)</a></p>
     */
    public final Signal1<io.qt.qt3d.input.QMouseEvent> pressAndHold = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#pressed">Qt3DInput::QMouseHandler::pressed(Qt3DInput::QMouseEvent*)</a></p>
     */
    public final Signal1<io.qt.qt3d.input.QMouseEvent> pressed = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#released">Qt3DInput::QMouseHandler::released(Qt3DInput::QMouseEvent*)</a></p>
     */
    public final Signal1<io.qt.qt3d.input.QMouseEvent> released = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#sourceDevice-prop">Qt3DInput::QMouseHandler::sourceDeviceChanged(Qt3DInput::QMouseDevice*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="sourceDevice")
    public final Signal1<io.qt.qt3d.input.QMouseDevice> sourceDeviceChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#wheel">Qt3DInput::QMouseHandler::wheel(Qt3DInput::QWheelEvent*)</a></p>
     */
    public final Signal1<io.qt.qt3d.input.QWheelEvent> wheel = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QMouseHandler(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QMouseHandler() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#QMouseHandler">Qt3DInput::QMouseHandler::QMouseHandler(QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QMouseHandler(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QMouseHandler instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#containsMouse-prop">Qt3DInput::QMouseHandler::containsMouse()const</a></p>
     */
    @io.qt.QtPropertyReader(name="containsMouse")
    @io.qt.QtUninvokable
    public final boolean containsMouse(){
        return containsMouse_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean containsMouse_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected final void setContainsMouse(boolean contains){
        setContainsMouse_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), contains);
    }
    
    @io.qt.QtUninvokable
    private native void setContainsMouse_native_bool(long __this__nativeId, boolean contains);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#setSourceDevice">Qt3DInput::QMouseHandler::setSourceDevice(Qt3DInput::QMouseDevice*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="sourceDevice")
    public final void setSourceDevice(io.qt.qt3d.input.QMouseDevice mouseDevice){
        setSourceDevice_native_Qt3DInput_QMouseDevice_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(mouseDevice));
    }
    
    private native void setSourceDevice_native_Qt3DInput_QMouseDevice_ptr(long __this__nativeId, long mouseDevice);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousehandler.html#sourceDevice-prop">Qt3DInput::QMouseHandler::sourceDevice()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sourceDevice")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.input.QMouseDevice sourceDevice(){
        return sourceDevice_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.input.QMouseDevice sourceDevice_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QMouseHandler(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QMouseHandler(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QMouseHandler instance, QDeclarativeConstructor constructor);
    
}
