package io.qt.qt3d.input;


/**
 * <p>Delegates mouse events to the attached MouseHandler objects</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html">Qt3DInput::QMouseDevice</a></p>
 */
public class QMouseDevice extends io.qt.qt3d.input.QAbstractPhysicalDevice
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMouseDevice.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html#Axis-enum">Qt3DInput::QMouseDevice::Axis</a></p>
     */
    public enum Axis implements io.qt.QtEnumerator {
        X(0),
        Y(1),
        WheelX(2),
        WheelY(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Axis(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Axis resolve(int value) {
            switch (value) {
            case 0: return X;
            case 1: return Y;
            case 2: return WheelX;
            case 3: return WheelY;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html#sensitivity-prop">Qt3DInput::QMouseDevice::sensitivityChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="sensitivity")
    public final Signal1<@io.qt.QtPrimitiveType Float> sensitivityChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html#updateAxesContinuously-prop">Qt3DInput::QMouseDevice::updateAxesContinuouslyChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="updateAxesContinuously")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> updateAxesContinuouslyChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QMouseDevice(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QMouseDevice() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html#QMouseDevice">Qt3DInput::QMouseDevice::QMouseDevice(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QMouseDevice(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QMouseDevice instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#axisCount">Qt3DInput::QAbstractPhysicalDevice::axisCount()const</a></p>
     */
    public final int axisCount(){
        return axisCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native int axisCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#axisIdentifier">Qt3DInput::QAbstractPhysicalDevice::axisIdentifier(QString)const</a></p>
     */
    public final int axisIdentifier(java.lang.String name){
        return axisIdentifier_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native int axisIdentifier_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#axisNames">Qt3DInput::QAbstractPhysicalDevice::axisNames()const</a></p>
     */
    public final io.qt.core.QStringList axisNames(){
        return axisNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native io.qt.core.QStringList axisNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#buttonCount">Qt3DInput::QAbstractPhysicalDevice::buttonCount()const</a></p>
     */
    public final int buttonCount(){
        return buttonCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native int buttonCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#buttonIdentifier">Qt3DInput::QAbstractPhysicalDevice::buttonIdentifier(QString)const</a></p>
     */
    public final int buttonIdentifier(java.lang.String name){
        return buttonIdentifier_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native int buttonIdentifier_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#buttonNames">Qt3DInput::QAbstractPhysicalDevice::buttonNames()const</a></p>
     */
    public final io.qt.core.QStringList buttonNames(){
        return buttonNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native io.qt.core.QStringList buttonNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html#sensitivity-prop">Qt3DInput::QMouseDevice::sensitivity()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sensitivity")
    @io.qt.QtUninvokable
    public final float sensitivity(){
        return sensitivity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float sensitivity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html#sensitivity-prop">Qt3DInput::QMouseDevice::setSensitivity(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="sensitivity")
    public final void setSensitivity(float value){
        setSensitivity_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    private native void setSensitivity_native_float(long __this__nativeId, float value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html#updateAxesContinuously-prop">Qt3DInput::QMouseDevice::setUpdateAxesContinuously(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="updateAxesContinuously")
    public final void setUpdateAxesContinuously(boolean updateAxesContinuously){
        setUpdateAxesContinuously_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), updateAxesContinuously);
    }
    
    private native void setUpdateAxesContinuously_native_bool(long __this__nativeId, boolean updateAxesContinuously);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qmousedevice.html#updateAxesContinuously-prop">Qt3DInput::QMouseDevice::updateAxesContinuously()const</a></p>
     */
    @io.qt.QtPropertyReader(name="updateAxesContinuously")
    @io.qt.QtUninvokable
    public final boolean updateAxesContinuously(){
        return updateAxesContinuously_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean updateAxesContinuously_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QMouseDevice(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QMouseDevice(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QMouseDevice instance, QDeclarativeConstructor constructor);
    
}
