package io.qt.qt3d.input;


/**
 * <p>Links a set of QAbstractActionInput that trigger the same event</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3dinput-qaction.html">Qt3DInput::QAction</a></p>
 */
public class QAction extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAction.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qaction.html#active-prop">Qt3DInput::QAction::activeChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="active")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> activeChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QAction(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAction() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qaction.html#QAction">Qt3DInput::QAction::QAction(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QAction(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAction instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qaction.html#addInput">Qt3DInput::QAction::addInput(Qt3DInput::QAbstractActionInput*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addInput(io.qt.qt3d.input.QAbstractActionInput input){
        addInput_native_Qt3DInput_QAbstractActionInput_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(input));
    }
    
    @io.qt.QtUninvokable
    private native void addInput_native_Qt3DInput_QAbstractActionInput_ptr(long __this__nativeId, long input);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qaction.html#inputs">Qt3DInput::QAction::inputs()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.qt3d.input.QAbstractActionInput> inputs(){
        return inputs_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.input.QAbstractActionInput> inputs_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qaction.html#active-prop">Qt3DInput::QAction::isActive()const</a></p>
     */
    @io.qt.QtPropertyReader(name="active")
    @io.qt.QtUninvokable
    public final boolean isActive(){
        return isActive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isActive_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qaction.html#removeInput">Qt3DInput::QAction::removeInput(Qt3DInput::QAbstractActionInput*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeInput(io.qt.qt3d.input.QAbstractActionInput input){
        removeInput_native_Qt3DInput_QAbstractActionInput_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(input));
    }
    
    @io.qt.QtUninvokable
    private native void removeInput_native_Qt3DInput_QAbstractActionInput_ptr(long __this__nativeId, long input);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAction(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QAction(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QAction instance, QDeclarativeConstructor constructor);
    
}
