package io.qt.qt3d.input;


/**
 * <p>The base class used by Qt3d to interact with arbitrary input devices</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html">Qt3DInput::QAbstractPhysicalDevice</a></p>
 */
public class QAbstractPhysicalDevice extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractPhysicalDevice.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractPhysicalDevice(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAbstractPhysicalDevice() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#QAbstractPhysicalDevice">Qt3DInput::QAbstractPhysicalDevice::QAbstractPhysicalDevice(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QAbstractPhysicalDevice(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAbstractPhysicalDevice instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#addAxisSetting">Qt3DInput::QAbstractPhysicalDevice::addAxisSetting(Qt3DInput::QAxisSetting*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addAxisSetting(io.qt.qt3d.input.QAxisSetting axisSetting){
        addAxisSetting_native_Qt3DInput_QAxisSetting_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axisSetting));
    }
    
    @io.qt.QtUninvokable
    private native void addAxisSetting_native_Qt3DInput_QAxisSetting_ptr(long __this__nativeId, long axisSetting);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#axisSettings">Qt3DInput::QAbstractPhysicalDevice::axisSettings()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.qt3d.input.QAxisSetting> axisSettings(){
        return axisSettings_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.input.QAxisSetting> axisSettings_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#removeAxisSetting">Qt3DInput::QAbstractPhysicalDevice::removeAxisSetting(Qt3DInput::QAxisSetting*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeAxisSetting(io.qt.qt3d.input.QAxisSetting axisSetting){
        removeAxisSetting_native_Qt3DInput_QAxisSetting_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axisSetting));
    }
    
    @io.qt.QtUninvokable
    private native void removeAxisSetting_native_Qt3DInput_QAxisSetting_ptr(long __this__nativeId, long axisSetting);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#axisCount">Qt3DInput::QAbstractPhysicalDevice::axisCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public int axisCount(){
        return axisCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int axisCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#axisIdentifier">Qt3DInput::QAbstractPhysicalDevice::axisIdentifier(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public int axisIdentifier(java.lang.String name){
        return axisIdentifier_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native int axisIdentifier_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#axisNames">Qt3DInput::QAbstractPhysicalDevice::axisNames()const</a></p>
     */
    @io.qt.QtUninvokable
    public java.util.List<java.lang.String> axisNames(){
        return axisNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.util.List<java.lang.String> axisNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#buttonCount">Qt3DInput::QAbstractPhysicalDevice::buttonCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public int buttonCount(){
        return buttonCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int buttonCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#buttonIdentifier">Qt3DInput::QAbstractPhysicalDevice::buttonIdentifier(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public int buttonIdentifier(java.lang.String name){
        return buttonIdentifier_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native int buttonIdentifier_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#buttonNames">Qt3DInput::QAbstractPhysicalDevice::buttonNames()const</a></p>
     */
    @io.qt.QtUninvokable
    public java.util.List<java.lang.String> buttonNames(){
        return buttonNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.util.List<java.lang.String> buttonNames_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAbstractPhysicalDevice(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QAbstractPhysicalDevice(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QAbstractPhysicalDevice instance, QDeclarativeConstructor constructor);
    
}
