package io.qt.qt3d.input;


/**
 * <p>Event type send by KeyBoardHandler</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html">Qt3DInput::QKeyEvent</a></p>
 */
public class QKeyEvent extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QKeyEvent.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QKeyEvent(io.qt.core.QEvent.Type, int, io.qt.core.Qt.KeyboardModifiers, java.lang.String, boolean, short)}
     *  with <code>count = 1</code>.</p>
     */
    public QKeyEvent(io.qt.core.QEvent.Type type, int key, io.qt.core.Qt.KeyboardModifiers modifiers, java.lang.String text, boolean autorep) {
        this(type, key, modifiers, text, autorep, (short)1);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QKeyEvent(io.qt.core.QEvent.Type, int, io.qt.core.Qt.KeyboardModifiers, java.lang.String, boolean, short)}</p>
     * <p>with: </p><ul>
     * <li><code>autorep = false</code></li>
     * <li><code>count = 1</code></li>
     * </ul>
     */
    public QKeyEvent(io.qt.core.QEvent.Type type, int key, io.qt.core.Qt.KeyboardModifiers modifiers, java.lang.String text) {
        this(type, key, modifiers, text, (boolean)false, (short)1);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QKeyEvent(io.qt.core.QEvent.Type, int, io.qt.core.Qt.KeyboardModifiers, java.lang.String, boolean, short)}</p>
     * <p>with: </p><ul>
     * <li><code>text = ""</code></li>
     * <li><code>autorep = false</code></li>
     * <li><code>count = 1</code></li>
     * </ul>
     */
    public QKeyEvent(io.qt.core.QEvent.Type type, int key, io.qt.core.Qt.KeyboardModifiers modifiers) {
        this(type, key, modifiers, "", (boolean)false, (short)1);
    }
    
    public QKeyEvent(io.qt.core.QEvent.Type type, int key, io.qt.core.Qt.KeyboardModifiers modifiers, java.lang.String text, boolean autorep, short count){
        super((QPrivateConstructor)null);
        initialize_native(this, type, key, modifiers, text, autorep, count);
    }
    
    private native static void initialize_native(QKeyEvent instance, io.qt.core.QEvent.Type type, int key, io.qt.core.Qt.KeyboardModifiers modifiers, java.lang.String text, boolean autorep, short count);
    
    public QKeyEvent(io.qt.gui.QKeyEvent ke){
        super((QPrivateConstructor)null);
        java.util.Objects.requireNonNull(ke, "Argument 'ke': null not expected.");
        initialize_native(this, ke);
    }
    
    private native static void initialize_native(QKeyEvent instance, io.qt.gui.QKeyEvent ke);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html#count-prop">Qt3DInput::QKeyEvent::count()const</a></p>
     */
    @io.qt.QtPropertyReader(name="count")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int count(){
        return count_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int count_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html#accepted-prop">Qt3DInput::QKeyEvent::isAccepted()const</a></p>
     */
    @io.qt.QtPropertyReader(name="accepted")
    @io.qt.QtUninvokable
    public final boolean isAccepted(){
        return isAccepted_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isAccepted_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html#isAutoRepeat-prop">Qt3DInput::QKeyEvent::isAutoRepeat()const</a></p>
     */
    @io.qt.QtPropertyReader(name="isAutoRepeat")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final boolean isAutoRepeat(){
        return isAutoRepeat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isAutoRepeat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html#key-prop">Qt3DInput::QKeyEvent::key()const</a></p>
     */
    @io.qt.QtPropertyReader(name="key")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int key(){
        return key_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int key_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html#matches">Qt3DInput::QKeyEvent::matches(QKeySequence::StandardKey)const</a></p>
     */
    public final boolean matches(io.qt.gui.QKeySequence.StandardKey key_){
        return matches_native_QKeySequence_StandardKey_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), key_.value());
    }
    
    private native boolean matches_native_QKeySequence_StandardKey_constfct(long __this__nativeId, int key_);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html#modifiers-prop">Qt3DInput::QKeyEvent::modifiers()const</a></p>
     */
    @io.qt.QtPropertyReader(name="modifiers")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int modifiers(){
        return modifiers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int modifiers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html#nativeScanCode-prop">Qt3DInput::QKeyEvent::nativeScanCode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="nativeScanCode")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int nativeScanCode(){
        return nativeScanCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int nativeScanCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html#accepted-prop">Qt3DInput::QKeyEvent::setAccepted(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="accepted")
    @io.qt.QtUninvokable
    public final void setAccepted(boolean accepted){
        setAccepted_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), accepted);
    }
    
    @io.qt.QtUninvokable
    private native void setAccepted_native_bool(long __this__nativeId, boolean accepted);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html#text-prop">Qt3DInput::QKeyEvent::text()const</a></p>
     */
    @io.qt.QtPropertyReader(name="text")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final java.lang.String text(){
        return text_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String text_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html#type">Qt3DInput::QKeyEvent::type()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QEvent.Type type(){
        return io.qt.core.QEvent.Type.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QKeyEvent(QPrivateConstructor p) { super(p); } 
    
}
