package io.qt.qt3d.input;


/**
 * <p>Processes velocity or acceleration data from a QAxis</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html">Qt3DInput::QAxisAccumulator</a></p>
 */
public class QAxisAccumulator extends io.qt.qt3d.core.QComponent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAxisAccumulator.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#SourceAxisType-enum">Qt3DInput::QAxisAccumulator::SourceAxisType</a></p>
     */
    public enum SourceAxisType implements io.qt.QtEnumerator {
        Velocity(0),
        Acceleration(1);

        private SourceAxisType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static SourceAxisType resolve(int value) {
            switch (value) {
            case 0: return Velocity;
            case 1: return Acceleration;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#scale-prop">Qt3DInput::QAxisAccumulator::scaleChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="scale")
    public final Signal1<@io.qt.QtPrimitiveType Float> scaleChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#sourceAxis-prop">Qt3DInput::QAxisAccumulator::sourceAxisChanged(Qt3DInput::QAxis*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="sourceAxis")
    public final Signal1<io.qt.qt3d.input.QAxis> sourceAxisChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#sourceAxisType-prop">Qt3DInput::QAxisAccumulator::sourceAxisTypeChanged(Qt3DInput::QAxisAccumulator::SourceAxisType)</a></p>
     */
    @io.qt.QtPropertyNotify(name="sourceAxisType")
    public final Signal1<io.qt.qt3d.input.QAxisAccumulator.SourceAxisType> sourceAxisTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#value-prop">Qt3DInput::QAxisAccumulator::valueChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="value")
    public final Signal1<@io.qt.QtPrimitiveType Float> valueChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#velocity-prop">Qt3DInput::QAxisAccumulator::velocityChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="velocity")
    public final Signal1<@io.qt.QtPrimitiveType Float> velocityChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QAxisAccumulator(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAxisAccumulator() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#QAxisAccumulator">Qt3DInput::QAxisAccumulator::QAxisAccumulator(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QAxisAccumulator(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAxisAccumulator instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#scale">Qt3DInput::QAxisAccumulator::scale()const</a></p>
     */
    @io.qt.QtPropertyReader(name="scale")
    @io.qt.QtUninvokable
    public final float scale(){
        return scale_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float scale_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#scale-prop">Qt3DInput::QAxisAccumulator::setScale(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="scale")
    public final void setScale(float scale){
        setScale_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), scale);
    }
    
    private native void setScale_native_float(long __this__nativeId, float scale);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#setSourceAxis">Qt3DInput::QAxisAccumulator::setSourceAxis(Qt3DInput::QAxis*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="sourceAxis")
    public final void setSourceAxis(io.qt.qt3d.input.QAxis sourceAxis){
        setSourceAxis_native_Qt3DInput_QAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sourceAxis));
    }
    
    private native void setSourceAxis_native_Qt3DInput_QAxis_ptr(long __this__nativeId, long sourceAxis);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#setSourceAxisType">Qt3DInput::QAxisAccumulator::setSourceAxisType(Qt3DInput::QAxisAccumulator::SourceAxisType)</a></p>
     */
    @io.qt.QtPropertyWriter(name="sourceAxisType")
    public final void setSourceAxisType(io.qt.qt3d.input.QAxisAccumulator.SourceAxisType sourceAxisType){
        setSourceAxisType_native_Qt3DInput_QAxisAccumulator_SourceAxisType(QtJambi_LibraryUtilities.internal.nativeId(this), sourceAxisType.value());
    }
    
    private native void setSourceAxisType_native_Qt3DInput_QAxisAccumulator_SourceAxisType(long __this__nativeId, int sourceAxisType);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#sourceAxis">Qt3DInput::QAxisAccumulator::sourceAxis()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sourceAxis")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.input.QAxis sourceAxis(){
        return sourceAxis_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.input.QAxis sourceAxis_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#sourceAxisType">Qt3DInput::QAxisAccumulator::sourceAxisType()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sourceAxisType")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.input.QAxisAccumulator.SourceAxisType sourceAxisType(){
        return io.qt.qt3d.input.QAxisAccumulator.SourceAxisType.resolve(sourceAxisType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int sourceAxisType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#value-prop">Qt3DInput::QAxisAccumulator::value()const</a></p>
     */
    @io.qt.QtPropertyReader(name="value")
    @io.qt.QtUninvokable
    public final float value(){
        return value_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float value_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#velocity">Qt3DInput::QAxisAccumulator::velocity()const</a></p>
     */
    @io.qt.QtPropertyReader(name="velocity")
    @io.qt.QtUninvokable
    public final float velocity(){
        return velocity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float velocity_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAxisAccumulator(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QAxisAccumulator(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QAxisAccumulator instance, QDeclarativeConstructor constructor);
    
}
