package io.qt.qt3d.input;


/**
 * <p>Qt3DCore::QMouseEvent contains parameters that describe a mouse event</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qt3dinput-qmouseevent.html">Qt3DInput::QMouseEvent</a></p>
 */
public class QMouseEvent extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMouseEvent.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3dinput-qmouseevent.html#Buttons-enum">Qt3DInput::QMouseEvent::Buttons</a></p>
     */
    public enum Buttons implements io.qt.QtEnumerator {
        LeftButton(1),
        RightButton(2),
        MiddleButton(4),
        BackButton(8),
        NoButton(0);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Buttons(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Buttons resolve(int value) {
            switch (value) {
            case 1: return LeftButton;
            case 2: return RightButton;
            case 4: return MiddleButton;
            case 8: return BackButton;
            case 0: return NoButton;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3dinput-qmouseevent.html#Modifiers-enum">Qt3DInput::QMouseEvent::Modifiers</a></p>
     */
    public enum Modifiers implements io.qt.QtEnumerator {
        NoModifier(0),
        ShiftModifier(33554432),
        ControlModifier(67108864),
        AltModifier(134217728),
        MetaModifier(268435456),
        KeypadModifier(536870912);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Modifiers(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Modifiers resolve(int value) {
            switch (value) {
            case 0: return NoModifier;
            case 33554432: return ShiftModifier;
            case 67108864: return ControlModifier;
            case 134217728: return AltModifier;
            case 268435456: return MetaModifier;
            case 536870912: return KeypadModifier;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qmouseevent.html#QMouseEvent">Qt3DInput::QMouseEvent::QMouseEvent(const::QMouseEvent&amp;)</a></p>
     */
    public QMouseEvent(io.qt.gui.QMouseEvent e){
        super((QPrivateConstructor)null);
        java.util.Objects.requireNonNull(e, "Argument 'e': null not expected.");
        initialize_native(this, e);
    }
    
    private native static void initialize_native(QMouseEvent instance, io.qt.gui.QMouseEvent e);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qmouseevent.html#button">Qt3DInput::QMouseEvent::button()const</a></p>
     */
    @io.qt.QtPropertyReader(name="button")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.qt3d.input.QMouseEvent.Buttons button(){
        return io.qt.qt3d.input.QMouseEvent.Buttons.resolve(button_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int button_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qmouseevent.html#buttons">Qt3DInput::QMouseEvent::buttons()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buttons")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int buttons(){
        return buttons_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int buttons_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qmouseevent.html#isAccepted">Qt3DInput::QMouseEvent::isAccepted()const</a></p>
     */
    @io.qt.QtPropertyReader(name="accepted")
    @io.qt.QtUninvokable
    public final boolean isAccepted(){
        return isAccepted_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isAccepted_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qmouseevent.html#modifiers">Qt3DInput::QMouseEvent::modifiers()const</a></p>
     */
    @io.qt.QtPropertyReader(name="modifiers")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.qt3d.input.QMouseEvent.Modifiers modifiers(){
        return io.qt.qt3d.input.QMouseEvent.Modifiers.resolve(modifiers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int modifiers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qmouseevent.html#setAccepted">Qt3DInput::QMouseEvent::setAccepted(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="accepted")
    @io.qt.QtUninvokable
    public final void setAccepted(boolean accepted){
        setAccepted_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), accepted);
    }
    
    @io.qt.QtUninvokable
    private native void setAccepted_native_bool(long __this__nativeId, boolean accepted);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qmouseevent.html#type">Qt3DInput::QMouseEvent::type()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QEvent.Type type(){
        return io.qt.core.QEvent.Type.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qmouseevent.html#wasHeld-prop">Qt3DInput::QMouseEvent::wasHeld()const</a></p>
     */
    @io.qt.QtPropertyReader(name="wasHeld")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final boolean wasHeld(){
        return wasHeld_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean wasHeld_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qmouseevent.html#x">Qt3DInput::QMouseEvent::x()const</a></p>
     */
    @io.qt.QtPropertyReader(name="x")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int x(){
        return x_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int x_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qmouseevent.html#y">Qt3DInput::QMouseEvent::y()const</a></p>
     */
    @io.qt.QtPropertyReader(name="y")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int y(){
        return y_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int y_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QMouseEvent(QPrivateConstructor p) { super(p); } 
    
}
