package io.qt.qt3d.input;


/**
 * <p>Stores settings for the specified list of Axis</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qt3dinput-qaxissetting.html">Qt3DInput::QAxisSetting</a></p>
 */
public class QAxisSetting extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAxisSetting.class);
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qaxissetting.html#axesChanged">Qt3DInput::QAxisSetting::axesChanged(QVector&lt;int&gt;)</a></p>
     */
    @io.qt.QtPropertyNotify(name="axes")
    public final Signal1<java.util.List<java.lang.Integer>> axesChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qaxissetting.html#deadZoneRadiusChanged">Qt3DInput::QAxisSetting::deadZoneRadiusChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="deadZoneRadius")
    public final Signal1<@io.qt.QtPrimitiveType Float> deadZoneRadiusChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qaxissetting.html#smoothChanged">Qt3DInput::QAxisSetting::smoothChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="smooth")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> smoothChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QAxisSetting(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAxisSetting() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qaxissetting.html#QAxisSetting">Qt3DInput::QAxisSetting::QAxisSetting(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QAxisSetting(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAxisSetting instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>QAxisSetting::axes Returns the current list of Axis these settings apply to</p>
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qaxissetting.html#axes">Qt3DInput::QAxisSetting::axes()const</a></p>
     */
    @io.qt.QtPropertyReader(name="axes")
    @io.qt.QtUninvokable
    public final io.qt.core.QVector<java.lang.Integer> axes(){
        return axes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QVector<java.lang.Integer> axes_native_constfct(long __this__nativeId);
    
    /**
     * <p>QAxisSetting::deadZoneRadius Returns the set dead zone radius</p>
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qaxissetting.html#deadZoneRadius">Qt3DInput::QAxisSetting::deadZoneRadius()const</a></p>
     */
    @io.qt.QtPropertyReader(name="deadZoneRadius")
    @io.qt.QtUninvokable
    public final float deadZoneRadius(){
        return deadZoneRadius_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float deadZoneRadius_native_constfct(long __this__nativeId);
    
    /**
     * <p>QAxisSetting::isSmoothEnabled Returns if smoothing is enabled</p>
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qaxissetting.html#isSmoothEnabled">Qt3DInput::QAxisSetting::isSmoothEnabled()const</a></p>
     */
    @io.qt.QtPropertyReader(name="smooth")
    @io.qt.QtUninvokable
    public final boolean isSmoothEnabled(){
        return isSmoothEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isSmoothEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qaxissetting.html#setAxes">Qt3DInput::QAxisSetting::setAxes(QVector&lt;int&gt;)</a></p>
     */
    @io.qt.QtPropertyWriter(name="axes")
    public final void setAxes(java.util.Collection<java.lang.Integer> axes){
        setAxes_native_cref_QVector(QtJambi_LibraryUtilities.internal.nativeId(this), axes);
    }
    
    private native void setAxes_native_cref_QVector(long __this__nativeId, java.util.Collection<java.lang.Integer> axes);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qaxissetting.html#setDeadZoneRadius">Qt3DInput::QAxisSetting::setDeadZoneRadius(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="deadZoneRadius")
    public final void setDeadZoneRadius(float deadZoneRadius){
        setDeadZoneRadius_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), deadZoneRadius);
    }
    
    private native void setDeadZoneRadius_native_float(long __this__nativeId, float deadZoneRadius);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qaxissetting.html#setSmoothEnabled">Qt3DInput::QAxisSetting::setSmoothEnabled(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="smooth")
    public final void setSmoothEnabled(boolean enabled){
        setSmoothEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    private native void setSmoothEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAxisSetting(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QAxisSetting(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QAxisSetting instance, QDeclarativeConstructor constructor);
    
}
