package io.qt.qt3d.input;


/**
 * <p>Contains parameters that describe a mouse wheel event</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qt3dinput-qwheelevent.html">Qt3DInput::QWheelEvent</a></p>
 */
public class QWheelEvent extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWheelEvent.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3dinput-qwheelevent.html#Buttons-enum">Qt3DInput::QWheelEvent::Buttons</a></p>
     */
    public enum Buttons implements io.qt.QtEnumerator {
        LeftButton(1),
        RightButton(2),
        MiddleButton(4),
        BackButton(8),
        NoButton(0);

        private Buttons(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Buttons resolve(int value) {
            switch (value) {
            case 1: return LeftButton;
            case 2: return RightButton;
            case 4: return MiddleButton;
            case 8: return BackButton;
            case 0: return NoButton;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3dinput-qwheelevent.html#Modifiers-enum">Qt3DInput::QWheelEvent::Modifiers</a></p>
     */
    public enum Modifiers implements io.qt.QtEnumerator {
        NoModifier(0),
        ShiftModifier(33554432),
        ControlModifier(67108864),
        AltModifier(134217728),
        MetaModifier(268435456),
        KeypadModifier(536870912);

        private Modifiers(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Modifiers resolve(int value) {
            switch (value) {
            case 0: return NoModifier;
            case 33554432: return ShiftModifier;
            case 67108864: return ControlModifier;
            case 134217728: return AltModifier;
            case 268435456: return MetaModifier;
            case 536870912: return KeypadModifier;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qwheelevent.html#QWheelEvent">Qt3DInput::QWheelEvent::QWheelEvent(const::QWheelEvent&amp;)</a></p>
     */
    public QWheelEvent(io.qt.gui.QWheelEvent e){
        super((QPrivateConstructor)null);
        java.util.Objects.requireNonNull(e, "Argument 'e': null not expected.");
        initialize_native(this, e);
    }
    
    private native static void initialize_native(QWheelEvent instance, io.qt.gui.QWheelEvent e);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qwheelevent.html#angleDelta">Qt3DInput::QWheelEvent::angleDelta()const</a></p>
     */
    @io.qt.QtPropertyReader(name="angleDelta")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.core.QPoint angleDelta(){
        return angleDelta_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QPoint angleDelta_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qwheelevent.html#buttons">Qt3DInput::QWheelEvent::buttons()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buttons")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int buttons(){
        return buttons_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int buttons_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qwheelevent.html#isAccepted">Qt3DInput::QWheelEvent::isAccepted()const</a></p>
     */
    @io.qt.QtPropertyReader(name="accepted")
    @io.qt.QtUninvokable
    public final boolean isAccepted(){
        return isAccepted_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isAccepted_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qwheelevent.html#modifiers">Qt3DInput::QWheelEvent::modifiers()const</a></p>
     */
    @io.qt.QtPropertyReader(name="modifiers")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.qt3d.input.QWheelEvent.Modifiers modifiers(){
        return io.qt.qt3d.input.QWheelEvent.Modifiers.resolve(modifiers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int modifiers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qwheelevent.html#setAccepted">Qt3DInput::QWheelEvent::setAccepted(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="accepted")
    @io.qt.QtUninvokable
    public final void setAccepted(boolean accepted){
        setAccepted_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), accepted);
    }
    
    @io.qt.QtUninvokable
    private native void setAccepted_native_bool(long __this__nativeId, boolean accepted);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qwheelevent.html#type">Qt3DInput::QWheelEvent::type()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QEvent.Type type(){
        return io.qt.core.QEvent.Type.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qwheelevent.html#x">Qt3DInput::QWheelEvent::x()const</a></p>
     */
    @io.qt.QtPropertyReader(name="x")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int x(){
        return x_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int x_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dinput-qwheelevent.html#y">Qt3DInput::QWheelEvent::y()const</a></p>
     */
    @io.qt.QtPropertyReader(name="y")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int y(){
        return y_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int y_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QWheelEvent(QPrivateConstructor p) { super(p); } 
    
}
