package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>The base class of all Qt3D node classes used to build a Qt3D scene</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dcore-qnode.html">Qt3DCore::QNode</a></code></p>
 */
public class QNode extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QNode.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qnode.html#enabled-prop">Qt3DCore::QNode::<wbr/>enabledChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="enabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> enabledChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qnode.html#nodeDestroyed">Qt3DCore::QNode::<wbr/>nodeDestroyed()</a></code></p>
     */
    public final @NonNull Signal0 nodeDestroyed = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qnode.html#parent-prop">Qt3DCore::QNode::<wbr/>parentChanged(QObject*)</a></code></p>
     */
    @QtPropertyNotify(name="parent")
    public final @NonNull Signal1<io.qt.core.@Nullable QObject> parentChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qnode.html#QNode">Qt3DCore::QNode::<wbr/>QNode(Qt3DCore::QNode*)</a></code></p>
     */
    public QNode(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QNode instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qnode.html#blockNotifications">Qt3DCore::QNode::<wbr/>blockNotifications(bool)</a></code></p>
     */
    @QtUninvokable
    public final boolean blockNotifications(boolean block){
        return blockNotifications_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), block);
    }
    
    @QtUninvokable
    private native boolean blockNotifications_native_bool(long __this__nativeId, boolean block);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qnode.html#childNodes">Qt3DCore::QNode::<wbr/>childNodes()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.core.@Nullable QNode> childNodes(){
        return childNodes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.core.QNode> childNodes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qnode.html#id">Qt3DCore::QNode::<wbr/>id()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.core.@NonNull QNodeId id(){
        return id_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QNodeId id_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qnode.html#enabled-prop">Qt3DCore::QNode::<wbr/>isEnabled()const</a></code></p>
     */
    @QtPropertyReader(name="enabled")
    @QtUninvokable
    public final boolean isEnabled(){
        return isEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qnode.html#notificationsBlocked">Qt3DCore::QNode::<wbr/>notificationsBlocked()const</a></code></p>
     */
    @QtUninvokable
    public final boolean notificationsBlocked(){
        return notificationsBlocked_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean notificationsBlocked_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qnode.html#parent-prop">Qt3DCore::QNode::<wbr/>parentNode()const</a></code></p>
     */
    @QtPropertyReader(name="parent")
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QNode parentNode(){
        return parentNode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QNode parentNode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qnode.html#enabled-prop">Qt3DCore::QNode::<wbr/>setEnabled(bool)</a></code></p>
     */
    @QtPropertyWriter(name="enabled")
    public final void setEnabled(boolean isEnabled){
        setEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), isEnabled);
    }
    
    private native void setEnabled_native_bool(long __this__nativeId, boolean isEnabled);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qnode.html#parent-prop">Qt3DCore::QNode::<wbr/>setParent(Qt3DCore::QNode*)</a></code></p>
     */
    @QtPropertyWriter(name="parent")
    public final void setParent(io.qt.qt3d.core.@Nullable QNode parent){
        setParent_native_Qt3DCore_QNode_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    private native void setParent_native_Qt3DCore_QNode_ptr(long __this__nativeId, long parent);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QNode(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QNode(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QNode instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QNode(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QNode() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getEnabled() {
        return isEnabled();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #parentNode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QNode getParent() {
        return parentNode();
    }
}
