package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Qt3DCore::QEntity is a Qt3DCore::QNode subclass that can aggregate several Qt3DCore::QComponent instances that will specify its behavior</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dcore-qentity.html">Qt3DCore::QEntity</a></code></p>
 */
public class QEntity extends io.qt.qt3d.core.QNode
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QEntity.class);
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qentity.html#QEntity">Qt3DCore::QEntity::<wbr/>QEntity(Qt3DCore::QNode*)</a></code></p>
     */
    public QEntity(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QEntity instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qentity.html#addComponent">Qt3DCore::QEntity::<wbr/>addComponent(Qt3DCore::QComponent*)</a></code></p>
     */
    @QtUninvokable
    public final void addComponent(io.qt.qt3d.core.@Nullable QComponent comp){
        addComponent_native_Qt3DCore_QComponent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(comp));
    }
    
    @QtUninvokable
    private native void addComponent_native_Qt3DCore_QComponent_ptr(long __this__nativeId, long comp);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qentity.html#components">Qt3DCore::QEntity::<wbr/>components()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.core.@Nullable QComponent> components(){
        return components_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.core.QComponent> components_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qentity.html#parentEntity">Qt3DCore::QEntity::<wbr/>parentEntity()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QEntity parentEntity(){
        return parentEntity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QEntity parentEntity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qentity.html#removeComponent">Qt3DCore::QEntity::<wbr/>removeComponent(Qt3DCore::QComponent*)</a></code></p>
     */
    @QtUninvokable
    public final void removeComponent(io.qt.qt3d.core.@Nullable QComponent comp){
        removeComponent_native_Qt3DCore_QComponent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(comp));
    }
    
    @QtUninvokable
    private native void removeComponent_native_Qt3DCore_QComponent_ptr(long __this__nativeId, long comp);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QEntity(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QEntity(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QEntity instance, QDeclarativeConstructor constructor);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qentity.html#componentsOfType"><code>Qt3DCore::QEntity::componentsOfType&lt;T>()const</code></a></p>
     */
    @QtUninvokable
    public final <T extends io.qt.qt3d.core.@Nullable QComponent> io.qt.core.@NonNull QList<T> componentsOfType(@StrictNonNull Class<T> type)
    {
        io.qt.core.QList<T> matchComponents = new io.qt.core.QList<T>(type);
        for (io.qt.qt3d.core.QComponent component : components()) {
            if (type.isInstance(component))
                matchComponents.append(type.cast(component));
        }
        return matchComponents;
    }
    
    /**
     * <p>Overloaded constructor for {@link #QEntity(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QEntity() {
        this((io.qt.qt3d.core.QNode)null);
    }
}
