package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Used to transforms parts of skinned meshes</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html">Qt3DCore::QJoint</a></code></p>
 */
public class QJoint extends io.qt.qt3d.core.QNode
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QJoint.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#inverseBindMatrix-prop">Qt3DCore::QJoint::<wbr/>inverseBindMatrixChanged(QMatrix4x4)</a></code></p>
     */
    @QtPropertyNotify(name="inverseBindMatrix")
    public final @NonNull Signal1<io.qt.gui.@NonNull QMatrix4x4> inverseBindMatrixChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#name-prop">Qt3DCore::QJoint::<wbr/>nameChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="name")
    public final @NonNull Signal1<java.lang.@NonNull String> nameChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotation-prop">Qt3DCore::QJoint::<wbr/>rotationChanged(QQuaternion)</a></code></p>
     */
    @QtPropertyNotify(name="rotation")
    public final @NonNull Signal1<io.qt.gui.@NonNull QQuaternion> rotationChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotationX-prop">Qt3DCore::QJoint::<wbr/>rotationXChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="rotationX")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> rotationXChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotationY-prop">Qt3DCore::QJoint::<wbr/>rotationYChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="rotationY")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> rotationYChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotationZ-prop">Qt3DCore::QJoint::<wbr/>rotationZChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="rotationZ")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> rotationZChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#scale-prop">Qt3DCore::QJoint::<wbr/>scaleChanged(QVector3D)</a></code></p>
     */
    @QtPropertyNotify(name="scale")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> scaleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#translation-prop">Qt3DCore::QJoint::<wbr/>translationChanged(QVector3D)</a></code></p>
     */
    @QtPropertyNotify(name="translation")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> translationChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#QJoint">Qt3DCore::QJoint::<wbr/>QJoint(Qt3DCore::QNode*)</a></code></p>
     */
    public QJoint(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QJoint instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#addChildJoint">Qt3DCore::QJoint::<wbr/>addChildJoint(Qt3DCore::QJoint*)</a></code></p>
     */
    @QtUninvokable
    public final void addChildJoint(io.qt.qt3d.core.@Nullable QJoint joint){
        addChildJoint_native_Qt3DCore_QJoint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(joint));
    }
    
    @QtUninvokable
    private native void addChildJoint_native_Qt3DCore_QJoint_ptr(long __this__nativeId, long joint);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#childJoints">Qt3DCore::QJoint::<wbr/>childJoints()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.core.@Nullable QJoint> childJoints(){
        return childJoints_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.core.QJoint> childJoints_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#inverseBindMatrix-prop">Qt3DCore::QJoint::<wbr/>inverseBindMatrix()const</a></code></p>
     */
    @QtPropertyReader(name="inverseBindMatrix")
    @QtUninvokable
    public final io.qt.gui.@NonNull QMatrix4x4 inverseBindMatrix(){
        return inverseBindMatrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QMatrix4x4 inverseBindMatrix_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#name">Qt3DCore::QJoint::<wbr/>name()const</a></code></p>
     */
    @QtPropertyReader(name="name")
    @QtUninvokable
    public final java.lang.@NonNull String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#removeChildJoint">Qt3DCore::QJoint::<wbr/>removeChildJoint(Qt3DCore::QJoint*)</a></code></p>
     */
    @QtUninvokable
    public final void removeChildJoint(io.qt.qt3d.core.@Nullable QJoint joint){
        removeChildJoint_native_Qt3DCore_QJoint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(joint));
    }
    
    @QtUninvokable
    private native void removeChildJoint_native_Qt3DCore_QJoint_ptr(long __this__nativeId, long joint);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotation-prop">Qt3DCore::QJoint::<wbr/>rotation()const</a></code></p>
     */
    @QtPropertyReader(name="rotation")
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion rotation(){
        return rotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QQuaternion rotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotationX-prop">Qt3DCore::QJoint::<wbr/>rotationX()const</a></code></p>
     */
    @QtPropertyReader(name="rotationX")
    @QtUninvokable
    public final float rotationX(){
        return rotationX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float rotationX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotationY-prop">Qt3DCore::QJoint::<wbr/>rotationY()const</a></code></p>
     */
    @QtPropertyReader(name="rotationY")
    @QtUninvokable
    public final float rotationY(){
        return rotationY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float rotationY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotationZ-prop">Qt3DCore::QJoint::<wbr/>rotationZ()const</a></code></p>
     */
    @QtPropertyReader(name="rotationZ")
    @QtUninvokable
    public final float rotationZ(){
        return rotationZ_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float rotationZ_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#scale-prop">Qt3DCore::QJoint::<wbr/>scale()const</a></code></p>
     */
    @QtPropertyReader(name="scale")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D scale(){
        return scale_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D scale_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#inverseBindMatrix-prop">Qt3DCore::QJoint::<wbr/>setInverseBindMatrix(QMatrix4x4)</a></code></p>
     */
    @QtPropertyWriter(name="inverseBindMatrix")
    public final void setInverseBindMatrix(io.qt.gui.@NonNull QMatrix4x4 inverseBindMatrix){
        setInverseBindMatrix_native_cref_QMatrix4x4(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(inverseBindMatrix));
    }
    
    private native void setInverseBindMatrix_native_cref_QMatrix4x4(long __this__nativeId, long inverseBindMatrix);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#name-prop">Qt3DCore::QJoint::<wbr/>setName(QString)</a></code></p>
     */
    @QtPropertyWriter(name="name")
    public final void setName(java.lang.@NonNull String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotation-prop">Qt3DCore::QJoint::<wbr/>setRotation(QQuaternion)</a></code></p>
     */
    @QtPropertyWriter(name="rotation")
    public final void setRotation(io.qt.gui.@NonNull QQuaternion rotation){
        setRotation_native_cref_QQuaternion(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rotation));
    }
    
    private native void setRotation_native_cref_QQuaternion(long __this__nativeId, long rotation);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotationX-prop">Qt3DCore::QJoint::<wbr/>setRotationX(float)</a></code></p>
     */
    @QtPropertyWriter(name="rotationX")
    public final void setRotationX(float rotationX){
        setRotationX_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), rotationX);
    }
    
    private native void setRotationX_native_float(long __this__nativeId, float rotationX);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotationY-prop">Qt3DCore::QJoint::<wbr/>setRotationY(float)</a></code></p>
     */
    @QtPropertyWriter(name="rotationY")
    public final void setRotationY(float rotationY){
        setRotationY_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), rotationY);
    }
    
    private native void setRotationY_native_float(long __this__nativeId, float rotationY);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotationZ-prop">Qt3DCore::QJoint::<wbr/>setRotationZ(float)</a></code></p>
     */
    @QtPropertyWriter(name="rotationZ")
    public final void setRotationZ(float rotationZ){
        setRotationZ_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), rotationZ);
    }
    
    private native void setRotationZ_native_float(long __this__nativeId, float rotationZ);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#scale-prop">Qt3DCore::QJoint::<wbr/>setScale(QVector3D)</a></code></p>
     */
    @QtPropertyWriter(name="scale")
    public final void setScale(io.qt.gui.@NonNull QVector3D scale){
        setScale_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scale));
    }
    
    private native void setScale_native_cref_QVector3D(long __this__nativeId, long scale);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#setToIdentity">Qt3DCore::QJoint::<wbr/>setToIdentity()</a></code></p>
     */
    public final void setToIdentity(){
        setToIdentity_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void setToIdentity_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#translation-prop">Qt3DCore::QJoint::<wbr/>setTranslation(QVector3D)</a></code></p>
     */
    @QtPropertyWriter(name="translation")
    public final void setTranslation(io.qt.gui.@NonNull QVector3D translation){
        setTranslation_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(translation));
    }
    
    private native void setTranslation_native_cref_QVector3D(long __this__nativeId, long translation);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#translation-prop">Qt3DCore::QJoint::<wbr/>translation()const</a></code></p>
     */
    @QtPropertyReader(name="translation")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D translation(){
        return translation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D translation_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QJoint(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QJoint(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QJoint instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QJoint(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QJoint() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #inverseBindMatrix()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QMatrix4x4 getInverseBindMatrix() {
        return inverseBindMatrix();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #name()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getName() {
        return name();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #rotation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion getRotation() {
        return rotation();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #rotationX()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getRotationX() {
        return rotationX();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #rotationY()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getRotationY() {
        return rotationY();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #rotationZ()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getRotationZ() {
        return rotationZ();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #scale()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getScale() {
        return scale();
    }
    
    /**
     * <p>Overloaded function for {@link #setInverseBindMatrix(io.qt.gui.QMatrix4x4)}.</p>
     */
    public final void setInverseBindMatrix(io.qt.gui.@NonNull QTransform inverseBindMatrix) {
        setInverseBindMatrix(new io.qt.gui.QMatrix4x4(inverseBindMatrix));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #translation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getTranslation() {
        return translation();
    }
}
