package io.qt.qt3d.core;

import io.qt.*;
import static io.qt.QtUtilities.*;

final class QtJambi_LibraryUtilities {

    final static int qtMajorVersion = 6;

    final static int qtMinorVersion = 5;

    final static int qtJambiPatch = 3;

    final static InternalAccess internal;

    static{
        try {
            initializePackage("io.qt.core");
            loadQtLibrary("DBus", LibraryRequirementMode.ProvideOnly, "macos", "linux");
            loadQtLibrary("Network", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("OpenGL", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("Qml", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("QmlModels", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("Quick", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("Svg", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("VirtualKeyboard", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("WaylandClient", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("WaylandEglClientHwIntegration", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("WlShellIntegration", LibraryRequirementMode.ProvideOnly, "linux");
            loadUtilityLibrary("d3dcompiler_47", LibraryRequirementMode.ProvideOnly, "windows");
            loadUtilityLibrary("libEGL", LibraryRequirementMode.ProvideOnly, "windows");
            loadUtilityLibrary("libGLESv2", LibraryRequirementMode.ProvideOnly, "windows");
            loadUtilityLibrary("opengl32sw", LibraryRequirementMode.ProvideOnly, "windows");
            loadQtLibrary("Gui", LibraryRequirementMode.Mandatory);
            loadQtLibrary("Concurrent", LibraryRequirementMode.Mandatory);
            loadQtLibrary("Network", LibraryRequirementMode.Mandatory);
            loadQtLibrary("3DCore", LibraryRequirementMode.Mandatory);
            loadQtJambiLibrary("3DCore");
        } catch(Error t) {
            throw t;
        } catch(Throwable t) {
            throw new ExceptionInInitializerError(t);
        }
        internal = internalAccess();
    }
    private static native InternalAccess internalAccess();

    static void initialize() { };

    private QtJambi_LibraryUtilities() throws InstantiationError { throw new InstantiationError("Cannot instantiate QtJambi_LibraryUtilities."); }
}

