package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Encapsulates geometry</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dcore-qgeometry.html">Qt3DCore::QGeometry</a></code></p>
 */
public class QGeometry extends io.qt.qt3d.core.QNode
{
    @QtPropertyMember(enabled=false)
    private Object __rcBoundingVolumePositionAttribute = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QGeometry.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qgeometry.html#boundingVolumePositionAttribute-prop">Qt3DCore::QGeometry::<wbr>boundingVolumePositionAttributeChanged(Qt3DCore::QAttribute*)</a></code></p>
     */
    @QtPropertyNotify(name="boundingVolumePositionAttribute")
    public final @NonNull Signal1<io.qt.qt3d.core.@Nullable QAttribute> boundingVolumePositionAttributeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qgeometry.html#maxExtent-prop">Qt3DCore::QGeometry::<wbr>maxExtentChanged(QVector3D)</a></code></p>
     */
    @QtPropertyNotify(name="maxExtent")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> maxExtentChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qgeometry.html#minExtent-prop">Qt3DCore::QGeometry::<wbr>minExtentChanged(QVector3D)</a></code></p>
     */
    @QtPropertyNotify(name="minExtent")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> minExtentChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QGeometry(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QGeometry() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qgeometry.html#QGeometry">Qt3DCore::QGeometry::<wbr>QGeometry(Qt3DCore::QNode*)</a></code></p>
     */
    public QGeometry(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QGeometry instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qgeometry.html#addAttribute">Qt3DCore::QGeometry::<wbr>addAttribute(Qt3DCore::QAttribute*)</a></code></p>
     */
    public final void addAttribute(io.qt.qt3d.core.@Nullable QAttribute attribute){
        addAttribute_native_Qt3DCore_QAttribute_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(attribute));
    }
    
    private native void addAttribute_native_Qt3DCore_QAttribute_ptr(long __this__nativeId, long attribute);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qgeometry.html#attributes">Qt3DCore::QGeometry::<wbr>attributes()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.core.@Nullable QAttribute> attributes(){
        return attributes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.core.QAttribute> attributes_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #boundingVolumePositionAttribute()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QAttribute getBoundingVolumePositionAttribute() {
        return boundingVolumePositionAttribute();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qgeometry.html#boundingVolumePositionAttribute-prop">Qt3DCore::QGeometry::<wbr>boundingVolumePositionAttribute()const</a></code></p>
     */
    @QtPropertyReader(name="boundingVolumePositionAttribute")
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QAttribute boundingVolumePositionAttribute(){
        return boundingVolumePositionAttribute_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QAttribute boundingVolumePositionAttribute_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxExtent()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getMaxExtent() {
        return maxExtent();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qgeometry.html#maxExtent-prop">Qt3DCore::QGeometry::<wbr>maxExtent()const</a></code></p>
     */
    @QtPropertyReader(name="maxExtent")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D maxExtent(){
        return maxExtent_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D maxExtent_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #minExtent()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getMinExtent() {
        return minExtent();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qgeometry.html#minExtent-prop">Qt3DCore::QGeometry::<wbr>minExtent()const</a></code></p>
     */
    @QtPropertyReader(name="minExtent")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D minExtent(){
        return minExtent_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D minExtent_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qgeometry.html#removeAttribute">Qt3DCore::QGeometry::<wbr>removeAttribute(Qt3DCore::QAttribute*)</a></code></p>
     */
    public final void removeAttribute(io.qt.qt3d.core.@Nullable QAttribute attribute){
        removeAttribute_native_Qt3DCore_QAttribute_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(attribute));
    }
    
    private native void removeAttribute_native_Qt3DCore_QAttribute_ptr(long __this__nativeId, long attribute);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qgeometry.html#boundingVolumePositionAttribute-prop">Qt3DCore::QGeometry::<wbr>setBoundingVolumePositionAttribute(Qt3DCore::QAttribute*)</a></code></p>
     */
    @QtPropertyWriter(name="boundingVolumePositionAttribute")
    public final void setBoundingVolumePositionAttribute(io.qt.qt3d.core.@Nullable QAttribute boundingVolumePositionAttribute){
        setBoundingVolumePositionAttribute_native_Qt3DCore_QAttribute_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(boundingVolumePositionAttribute));
        __rcBoundingVolumePositionAttribute = boundingVolumePositionAttribute;
    }
    
    private native void setBoundingVolumePositionAttribute_native_Qt3DCore_QAttribute_ptr(long __this__nativeId, long boundingVolumePositionAttribute);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QGeometry(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QGeometry(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QGeometry instance, QDeclarativeConstructor constructor);
    
}
