package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Provides a data store for raw data to later be used as vertices or uniforms</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html">Qt3DCore::QBuffer</a></code></p>
 */
public class QBuffer extends io.qt.qt3d.core.QNode
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QBuffer.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#AccessType-enum">Qt3DCore::QBuffer::AccessType</a></code></p>
     */
    public enum AccessType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#AccessType-enum">Qt3DCore::<wbr>QBuffer::<wbr>Write</a></code></p>
         */
        Write(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#AccessType-enum">Qt3DCore::<wbr>QBuffer::<wbr>Read</a></code></p>
         */
        Read(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#AccessType-enum">Qt3DCore::<wbr>QBuffer::<wbr>ReadWrite</a></code></p>
         */
        ReadWrite(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private AccessType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull AccessType resolve(int value) {
            switch (value) {
            case 1: return Write;
            case 2: return Read;
            case 3: return ReadWrite;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#UsageType-enum">Qt3DCore::QBuffer::UsageType</a></code></p>
     */
    public enum UsageType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#UsageType-enum">Qt3DCore::<wbr>QBuffer::<wbr>StreamDraw</a></code></p>
         */
        StreamDraw(35040),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#UsageType-enum">Qt3DCore::<wbr>QBuffer::<wbr>StreamRead</a></code></p>
         */
        StreamRead(35041),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#UsageType-enum">Qt3DCore::<wbr>QBuffer::<wbr>StreamCopy</a></code></p>
         */
        StreamCopy(35042),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#UsageType-enum">Qt3DCore::<wbr>QBuffer::<wbr>StaticDraw</a></code></p>
         */
        StaticDraw(35044),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#UsageType-enum">Qt3DCore::<wbr>QBuffer::<wbr>StaticRead</a></code></p>
         */
        StaticRead(35045),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#UsageType-enum">Qt3DCore::<wbr>QBuffer::<wbr>StaticCopy</a></code></p>
         */
        StaticCopy(35046),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#UsageType-enum">Qt3DCore::<wbr>QBuffer::<wbr>DynamicDraw</a></code></p>
         */
        DynamicDraw(35048),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#UsageType-enum">Qt3DCore::<wbr>QBuffer::<wbr>DynamicRead</a></code></p>
         */
        DynamicRead(35049),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#UsageType-enum">Qt3DCore::<wbr>QBuffer::<wbr>DynamicCopy</a></code></p>
         */
        DynamicCopy(35050);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private UsageType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull UsageType resolve(int value) {
            switch (value) {
            case 35040: return StreamDraw;
            case 35041: return StreamRead;
            case 35042: return StreamCopy;
            case 35044: return StaticDraw;
            case 35045: return StaticRead;
            case 35046: return StaticCopy;
            case 35048: return DynamicDraw;
            case 35049: return DynamicRead;
            case 35050: return DynamicCopy;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#accessType-prop">Qt3DCore::QBuffer::<wbr>accessTypeChanged(Qt3DCore::QBuffer::AccessType)</a></code></p>
     */
    @QtPropertyNotify(name="accessType")
    public final @NonNull Signal1<io.qt.qt3d.core.QBuffer.@NonNull AccessType> accessTypeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#dataAvailable">Qt3DCore::QBuffer::<wbr>dataAvailable()</a></code></p>
     */
    public final @NonNull Signal0 dataAvailable = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#dataChanged">Qt3DCore::QBuffer::<wbr>dataChanged(QByteArray)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> dataChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#usage-prop">Qt3DCore::QBuffer::<wbr>usageChanged(Qt3DCore::QBuffer::UsageType)</a></code></p>
     */
    @QtPropertyNotify(name="usage")
    public final @NonNull Signal1<io.qt.qt3d.core.QBuffer.@NonNull UsageType> usageChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QBuffer(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QBuffer() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#QBuffer">Qt3DCore::QBuffer::<wbr>QBuffer(Qt3DCore::QNode*)</a></code></p>
     */
    public QBuffer(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QBuffer instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #accessType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.core.QBuffer.@NonNull AccessType getAccessType() {
        return accessType();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#accessType-prop">Qt3DCore::QBuffer::<wbr>accessType()const</a></code></p>
     */
    @QtPropertyReader(name="accessType")
    @QtUninvokable
    public final io.qt.qt3d.core.QBuffer.@NonNull AccessType accessType(){
        return io.qt.qt3d.core.QBuffer.AccessType.resolve(accessType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int accessType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#data">Qt3DCore::QBuffer::<wbr>data()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray data(){
        return data_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray data_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#accessType-prop">Qt3DCore::QBuffer::<wbr>setAccessType(Qt3DCore::QBuffer::AccessType)</a></code></p>
     */
    @QtPropertyWriter(name="accessType")
    public final void setAccessType(io.qt.qt3d.core.QBuffer.@NonNull AccessType access){
        setAccessType_native_Qt3DCore_QBuffer_AccessType(QtJambi_LibraryUtilities.internal.nativeId(this), access.value());
    }
    
    private native void setAccessType_native_Qt3DCore_QBuffer_AccessType(long __this__nativeId, int access);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#setData">Qt3DCore::QBuffer::<wbr>setData(QByteArray)</a></code></p>
     */
    @QtUninvokable
    public final void setData(io.qt.core.@NonNull QByteArray bytes){
        setData_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(bytes));
    }
    
    @QtUninvokable
    private native void setData_native_cref_QByteArray(long __this__nativeId, long bytes);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#usage-prop">Qt3DCore::QBuffer::<wbr>setUsage(Qt3DCore::QBuffer::UsageType)</a></code></p>
     */
    @QtPropertyWriter(name="usage")
    public final void setUsage(io.qt.qt3d.core.QBuffer.@NonNull UsageType usage){
        setUsage_native_Qt3DCore_QBuffer_UsageType(QtJambi_LibraryUtilities.internal.nativeId(this), usage.value());
    }
    
    private native void setUsage_native_Qt3DCore_QBuffer_UsageType(long __this__nativeId, int usage);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#updateData">Qt3DCore::QBuffer::<wbr>updateData(int,<wbr>QByteArray)</a></code></p>
     */
    public final void updateData(int offset, io.qt.core.@NonNull QByteArray bytes){
        updateData_native_int_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), offset, QtJambi_LibraryUtilities.internal.checkedNativeId(bytes));
    }
    
    private native void updateData_native_int_cref_QByteArray(long __this__nativeId, int offset, long bytes);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #usage()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.core.QBuffer.@NonNull UsageType getUsage() {
        return usage();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#usage-prop">Qt3DCore::QBuffer::<wbr>usage()const</a></code></p>
     */
    @QtPropertyReader(name="usage")
    @QtUninvokable
    public final io.qt.qt3d.core.QBuffer.@NonNull UsageType usage(){
        return io.qt.qt3d.core.QBuffer.UsageType.resolve(usage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int usage_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QBuffer(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QBuffer(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QBuffer instance, QDeclarativeConstructor constructor);
    
}
