package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Base class for all Qt3D backend nodes</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dcore-qbackendnode.html">Qt3DCore::QBackendNode</a></code></p>
 */
public class QBackendNode extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3dcore-qbackendnode.html#Mode-enum">Qt3DCore::QBackendNode::Mode</a></code></p>
     */
    public enum Mode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qbackendnode.html#Mode-enum">Qt3DCore::<wbr>QBackendNode::<wbr>ReadOnly</a></code></p>
         */
        ReadOnly(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qbackendnode.html#Mode-enum">Qt3DCore::<wbr>QBackendNode::<wbr>ReadWrite</a></code></p>
         */
        ReadWrite(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Mode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Mode resolve(int value) {
            switch (value) {
            case 0: return ReadOnly;
            case 1: return ReadWrite;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #QBackendNode(io.qt.qt3d.core.QBackendNode.Mode)}
     *  with <code>mode = io.qt.qt3d.core.QBackendNode.Mode.ReadOnly</code>.</p>
     */
    public QBackendNode() {
        this(io.qt.qt3d.core.QBackendNode.Mode.ReadOnly);
    }
    
    /**
     * <p>See <code>Qt3DCore::QBackendNode::<wbr>QBackendNode(Qt3DCore::QBackendNode::Mode)</code></p>
     */
    public QBackendNode(io.qt.qt3d.core.QBackendNode.@NonNull Mode mode){
        super((QPrivateConstructor)null);
        initialize_native(this, mode);
    }
    
    private native static void initialize_native(QBackendNode instance, io.qt.qt3d.core.QBackendNode.Mode mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qbackendnode.html#isEnabled">Qt3DCore::QBackendNode::<wbr>isEnabled()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isEnabled(){
        return isEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qbackendnode.html#mode">Qt3DCore::QBackendNode::<wbr>mode()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.core.QBackendNode.@NonNull Mode mode(){
        return io.qt.qt3d.core.QBackendNode.Mode.resolve(mode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int mode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qbackendnode.html#peerId">Qt3DCore::QBackendNode::<wbr>peerId()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.core.@NonNull QNodeId peerId(){
        return peerId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QNodeId peerId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qbackendnode.html#setEnabled">Qt3DCore::QBackendNode::<wbr>setEnabled(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setEnabled(boolean enabled){
        setEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>QBackendNode::syncFromFrontEnd frontEnd firstTime</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qbackendnode.html#syncFromFrontEnd">Qt3DCore::QBackendNode::<wbr>syncFromFrontEnd(const Qt3DCore::QNode*,<wbr>bool)</a></code></p>
     */
    @QtUninvokable
    public void syncFromFrontEnd(io.qt.qt3d.core.@Nullable QNode frontEnd, boolean firstTime){
        syncFromFrontEnd_native_const_Qt3DCore_QNode_ptr_bool(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(frontEnd), firstTime);
    }
    
    @QtUninvokable
    private native void syncFromFrontEnd_native_const_Qt3DCore_QNode_ptr_bool(long __this__nativeId, long frontEnd, boolean firstTime);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QBackendNode(QPrivateConstructor p) { super(p); } 
    
}
