package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Defines an attribute and how data should be read from a QBuffer</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html">Qt3DCore::QAttribute</a></code></p>
 */
public class QAttribute extends io.qt.qt3d.core.QNode
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAttribute.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#AttributeType-enum">Qt3DCore::QAttribute::AttributeType</a></code></p>
     */
    public enum AttributeType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#AttributeType-enum">Qt3DCore::<wbr>QAttribute::<wbr>VertexAttribute</a></code></p>
         */
        VertexAttribute(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#AttributeType-enum">Qt3DCore::<wbr>QAttribute::<wbr>IndexAttribute</a></code></p>
         */
        IndexAttribute(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#AttributeType-enum">Qt3DCore::<wbr>QAttribute::<wbr>DrawIndirectAttribute</a></code></p>
         */
        DrawIndirectAttribute(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private AttributeType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull AttributeType resolve(int value) {
            switch (value) {
            case 0: return VertexAttribute;
            case 1: return IndexAttribute;
            case 2: return DrawIndirectAttribute;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#VertexBaseType-enum">Qt3DCore::QAttribute::VertexBaseType</a></code></p>
     */
    public enum VertexBaseType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#VertexBaseType-enum">Qt3DCore::<wbr>QAttribute::<wbr>Byte</a></code></p>
         */
        Byte(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#VertexBaseType-enum">Qt3DCore::<wbr>QAttribute::<wbr>UnsignedByte</a></code></p>
         */
        UnsignedByte(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#VertexBaseType-enum">Qt3DCore::<wbr>QAttribute::<wbr>Short</a></code></p>
         */
        Short(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#VertexBaseType-enum">Qt3DCore::<wbr>QAttribute::<wbr>UnsignedShort</a></code></p>
         */
        UnsignedShort(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#VertexBaseType-enum">Qt3DCore::<wbr>QAttribute::<wbr>Int</a></code></p>
         */
        Int(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#VertexBaseType-enum">Qt3DCore::<wbr>QAttribute::<wbr>UnsignedInt</a></code></p>
         */
        UnsignedInt(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#VertexBaseType-enum">Qt3DCore::<wbr>QAttribute::<wbr>HalfFloat</a></code></p>
         */
        HalfFloat(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#VertexBaseType-enum">Qt3DCore::<wbr>QAttribute::<wbr>Float</a></code></p>
         */
        Float(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#VertexBaseType-enum">Qt3DCore::<wbr>QAttribute::<wbr>Double</a></code></p>
         */
        Double(8);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private VertexBaseType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull VertexBaseType resolve(int value) {
            switch (value) {
            case 0: return Byte;
            case 1: return UnsignedByte;
            case 2: return Short;
            case 3: return UnsignedShort;
            case 4: return Int;
            case 5: return UnsignedInt;
            case 6: return HalfFloat;
            case 7: return Float;
            case 8: return Double;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#attributeType-prop">Qt3DCore::QAttribute::<wbr>attributeTypeChanged(Qt3DCore::QAttribute::AttributeType)</a></code></p>
     */
    @QtPropertyNotify(name="attributeType")
    public final @NonNull Signal1<io.qt.qt3d.core.QAttribute.@NonNull AttributeType> attributeTypeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#buffer-prop">Qt3DCore::QAttribute::<wbr>bufferChanged(QBuffer*)</a></code></p>
     */
    @QtPropertyNotify(name="buffer")
    public final @NonNull Signal1<io.qt.qt3d.core.@Nullable QBuffer> bufferChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#byteOffset-prop">Qt3DCore::QAttribute::<wbr>byteOffsetChanged(uint)</a></code></p>
     */
    @QtPropertyNotify(name="byteOffset")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> byteOffsetChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#byteStride-prop">Qt3DCore::QAttribute::<wbr>byteStrideChanged(uint)</a></code></p>
     */
    @QtPropertyNotify(name="byteStride")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> byteStrideChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#count-prop">Qt3DCore::QAttribute::<wbr>countChanged(uint)</a></code></p>
     */
    @QtPropertyNotify(name="count")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> countChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#dataSizeChanged">Qt3DCore::QAttribute::<wbr>dataSizeChanged(uint)</a></code></p>
     */
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> dataSizeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#dataTypeChanged">Qt3DCore::QAttribute::<wbr>dataTypeChanged(Qt3DCore::QAttribute::VertexBaseType)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType> dataTypeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#divisor-prop">Qt3DCore::QAttribute::<wbr>divisorChanged(uint)</a></code></p>
     */
    @QtPropertyNotify(name="divisor")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> divisorChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#name-prop">Qt3DCore::QAttribute::<wbr>nameChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="name")
    public final @NonNull Signal1<java.lang.@NonNull String> nameChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#vertexBaseType-prop">Qt3DCore::QAttribute::<wbr>vertexBaseTypeChanged(Qt3DCore::QAttribute::VertexBaseType)</a></code></p>
     */
    @QtPropertyNotify(name="vertexBaseType")
    public final @NonNull Signal1<io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType> vertexBaseTypeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#vertexSize-prop">Qt3DCore::QAttribute::<wbr>vertexSizeChanged(uint)</a></code></p>
     */
    @QtPropertyNotify(name="vertexSize")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> vertexSizeChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QAttribute(io.qt.qt3d.core.QBuffer, io.qt.qt3d.core.QAttribute.VertexBaseType, int, int, int, int, io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAttribute(io.qt.qt3d.core.@Nullable QBuffer buf, io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType vertexBaseType, int vertexSize, int count, int offset, int stride) {
        this(buf, vertexBaseType, vertexSize, count, offset, stride, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAttribute(io.qt.qt3d.core.QBuffer, io.qt.qt3d.core.QAttribute.VertexBaseType, int, int, int, int, io.qt.qt3d.core.QNode)}</p>
     * <p>with: </p><ul>
     * <li><code>stride = 0</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QAttribute(io.qt.qt3d.core.@Nullable QBuffer buf, io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType vertexBaseType, int vertexSize, int count, int offset) {
        this(buf, vertexBaseType, vertexSize, count, offset, (int)0, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAttribute(io.qt.qt3d.core.QBuffer, io.qt.qt3d.core.QAttribute.VertexBaseType, int, int, int, int, io.qt.qt3d.core.QNode)}</p>
     * <p>with: </p><ul>
     * <li><code>offset = 0</code></li>
     * <li><code>stride = 0</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QAttribute(io.qt.qt3d.core.@Nullable QBuffer buf, io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType vertexBaseType, int vertexSize, int count) {
        this(buf, vertexBaseType, vertexSize, count, (int)0, (int)0, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#QAttribute-1">Qt3DCore::QAttribute::<wbr>QAttribute(QBuffer*,<wbr>Qt3DCore::QAttribute::VertexBaseType,<wbr>uint,<wbr>uint,<wbr>uint,<wbr>uint,<wbr>Qt3DCore::QNode*)</a></code></p>
     */
    public QAttribute(io.qt.qt3d.core.@Nullable QBuffer buf, io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType vertexBaseType, int vertexSize, int count, int offset, int stride, io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, buf, vertexBaseType, vertexSize, count, offset, stride, parent);
    }
    
    private native static void initialize_native(QAttribute instance, io.qt.qt3d.core.QBuffer buf, io.qt.qt3d.core.QAttribute.VertexBaseType vertexBaseType, int vertexSize, int count, int offset, int stride, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Overloaded constructor for {@link #QAttribute(io.qt.qt3d.core.QBuffer, java.lang.String, io.qt.qt3d.core.QAttribute.VertexBaseType, int, int, int, int, io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAttribute(io.qt.qt3d.core.@Nullable QBuffer buf, java.lang.@NonNull String name, io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType vertexBaseType, int vertexSize, int count, int offset, int stride) {
        this(buf, name, vertexBaseType, vertexSize, count, offset, stride, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAttribute(io.qt.qt3d.core.QBuffer, java.lang.String, io.qt.qt3d.core.QAttribute.VertexBaseType, int, int, int, int, io.qt.qt3d.core.QNode)}</p>
     * <p>with: </p><ul>
     * <li><code>stride = 0</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QAttribute(io.qt.qt3d.core.@Nullable QBuffer buf, java.lang.@NonNull String name, io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType vertexBaseType, int vertexSize, int count, int offset) {
        this(buf, name, vertexBaseType, vertexSize, count, offset, (int)0, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAttribute(io.qt.qt3d.core.QBuffer, java.lang.String, io.qt.qt3d.core.QAttribute.VertexBaseType, int, int, int, int, io.qt.qt3d.core.QNode)}</p>
     * <p>with: </p><ul>
     * <li><code>offset = 0</code></li>
     * <li><code>stride = 0</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QAttribute(io.qt.qt3d.core.@Nullable QBuffer buf, java.lang.@NonNull String name, io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType vertexBaseType, int vertexSize, int count) {
        this(buf, name, vertexBaseType, vertexSize, count, (int)0, (int)0, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#QAttribute-2">Qt3DCore::QAttribute::<wbr>QAttribute(QBuffer*,<wbr>QString,<wbr>Qt3DCore::QAttribute::VertexBaseType,<wbr>uint,<wbr>uint,<wbr>uint,<wbr>uint,<wbr>Qt3DCore::QNode*)</a></code></p>
     */
    public QAttribute(io.qt.qt3d.core.@Nullable QBuffer buf, java.lang.@NonNull String name, io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType vertexBaseType, int vertexSize, int count, int offset, int stride, io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, buf, name, vertexBaseType, vertexSize, count, offset, stride, parent);
    }
    
    private native static void initialize_native(QAttribute instance, io.qt.qt3d.core.QBuffer buf, java.lang.String name, io.qt.qt3d.core.QAttribute.VertexBaseType vertexBaseType, int vertexSize, int count, int offset, int stride, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Overloaded constructor for {@link #QAttribute(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAttribute() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#QAttribute">Qt3DCore::QAttribute::<wbr>QAttribute(Qt3DCore::QNode*)</a></code></p>
     */
    public QAttribute(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAttribute instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #attributeType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.core.QAttribute.@NonNull AttributeType getAttributeType() {
        return attributeType();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#attributeType-prop">Qt3DCore::QAttribute::<wbr>attributeType()const</a></code></p>
     */
    @QtPropertyReader(name="attributeType")
    @QtUninvokable
    public final io.qt.qt3d.core.QAttribute.@NonNull AttributeType attributeType(){
        return io.qt.qt3d.core.QAttribute.AttributeType.resolve(attributeType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int attributeType_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #buffer()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QBuffer getBuffer() {
        return buffer();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#buffer-prop">Qt3DCore::QAttribute::<wbr>buffer()const</a></code></p>
     */
    @QtPropertyReader(name="buffer")
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QBuffer buffer(){
        return buffer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QBuffer buffer_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #byteOffset()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getByteOffset() {
        return byteOffset();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#byteOffset-prop">Qt3DCore::QAttribute::<wbr>byteOffset()const</a></code></p>
     */
    @QtPropertyReader(name="byteOffset")
    @QtUninvokable
    public final int byteOffset(){
        return byteOffset_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int byteOffset_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #byteStride()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getByteStride() {
        return byteStride();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#byteStride-prop">Qt3DCore::QAttribute::<wbr>byteStride()const</a></code></p>
     */
    @QtPropertyReader(name="byteStride")
    @QtUninvokable
    public final int byteStride(){
        return byteStride_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int byteStride_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #count()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getCount() {
        return count();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#count-prop">Qt3DCore::QAttribute::<wbr>count()const</a></code></p>
     */
    @QtPropertyReader(name="count")
    @QtUninvokable
    public final int count(){
        return count_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int count_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #divisor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getDivisor() {
        return divisor();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#divisor-prop">Qt3DCore::QAttribute::<wbr>divisor()const</a></code></p>
     */
    @QtPropertyReader(name="divisor")
    @QtUninvokable
    public final int divisor(){
        return divisor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int divisor_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #name()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getName() {
        return name();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#name-prop">Qt3DCore::QAttribute::<wbr>name()const</a></code></p>
     */
    @QtPropertyReader(name="name")
    @QtUninvokable
    public final java.lang.@NonNull String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#attributeType-prop">Qt3DCore::QAttribute::<wbr>setAttributeType(Qt3DCore::QAttribute::AttributeType)</a></code></p>
     */
    @QtPropertyWriter(name="attributeType")
    public final void setAttributeType(io.qt.qt3d.core.QAttribute.@NonNull AttributeType attributeType){
        setAttributeType_native_Qt3DCore_QAttribute_AttributeType(QtJambi_LibraryUtilities.internal.nativeId(this), attributeType.value());
    }
    
    private native void setAttributeType_native_Qt3DCore_QAttribute_AttributeType(long __this__nativeId, int attributeType);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#buffer-prop">Qt3DCore::QAttribute::<wbr>setBuffer(QBuffer*)</a></code></p>
     */
    @QtPropertyWriter(name="buffer")
    public final void setBuffer(io.qt.qt3d.core.@Nullable QBuffer buffer){
        setBuffer_native_Qt3DCore_QBuffer_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(buffer));
    }
    
    private native void setBuffer_native_Qt3DCore_QBuffer_ptr(long __this__nativeId, long buffer);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#byteOffset-prop">Qt3DCore::QAttribute::<wbr>setByteOffset(uint)</a></code></p>
     */
    @QtPropertyWriter(name="byteOffset")
    public final void setByteOffset(int byteOffset){
        setByteOffset_native_uint(QtJambi_LibraryUtilities.internal.nativeId(this), byteOffset);
    }
    
    private native void setByteOffset_native_uint(long __this__nativeId, int byteOffset);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#byteStride-prop">Qt3DCore::QAttribute::<wbr>setByteStride(uint)</a></code></p>
     */
    @QtPropertyWriter(name="byteStride")
    public final void setByteStride(int byteStride){
        setByteStride_native_uint(QtJambi_LibraryUtilities.internal.nativeId(this), byteStride);
    }
    
    private native void setByteStride_native_uint(long __this__nativeId, int byteStride);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#count-prop">Qt3DCore::QAttribute::<wbr>setCount(uint)</a></code></p>
     */
    @QtPropertyWriter(name="count")
    public final void setCount(int count){
        setCount_native_uint(QtJambi_LibraryUtilities.internal.nativeId(this), count);
    }
    
    private native void setCount_native_uint(long __this__nativeId, int count);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#divisor-prop">Qt3DCore::QAttribute::<wbr>setDivisor(uint)</a></code></p>
     */
    @QtPropertyWriter(name="divisor")
    public final void setDivisor(int divisor){
        setDivisor_native_uint(QtJambi_LibraryUtilities.internal.nativeId(this), divisor);
    }
    
    private native void setDivisor_native_uint(long __this__nativeId, int divisor);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#name-prop">Qt3DCore::QAttribute::<wbr>setName(QString)</a></code></p>
     */
    @QtPropertyWriter(name="name")
    public final void setName(java.lang.@NonNull String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#vertexBaseType-prop">Qt3DCore::QAttribute::<wbr>setVertexBaseType(Qt3DCore::QAttribute::VertexBaseType)</a></code></p>
     */
    @QtPropertyWriter(name="vertexBaseType")
    public final void setVertexBaseType(io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType type){
        setVertexBaseType_native_Qt3DCore_QAttribute_VertexBaseType(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    private native void setVertexBaseType_native_Qt3DCore_QAttribute_VertexBaseType(long __this__nativeId, int type);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#vertexSize-prop">Qt3DCore::QAttribute::<wbr>setVertexSize(uint)</a></code></p>
     */
    @QtPropertyWriter(name="vertexSize")
    public final void setVertexSize(int size){
        setVertexSize_native_uint(QtJambi_LibraryUtilities.internal.nativeId(this), size);
    }
    
    private native void setVertexSize_native_uint(long __this__nativeId, int size);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #vertexBaseType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType getVertexBaseType() {
        return vertexBaseType();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#vertexBaseType-prop">Qt3DCore::QAttribute::<wbr>vertexBaseType()const</a></code></p>
     */
    @QtPropertyReader(name="vertexBaseType")
    @QtUninvokable
    public final io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType vertexBaseType(){
        return io.qt.qt3d.core.QAttribute.VertexBaseType.resolve(vertexBaseType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int vertexBaseType_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #vertexSize()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getVertexSize() {
        return vertexSize();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#vertexSize-prop">Qt3DCore::QAttribute::<wbr>vertexSize()const</a></code></p>
     */
    @QtPropertyReader(name="vertexSize")
    @QtUninvokable
    public final int vertexSize(){
        return vertexSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int vertexSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #defaultColorAttributeName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static java.lang.@NonNull String getDefaultColorAttributeName() {
        return defaultColorAttributeName();
    }
    
    /**
     * <p>QAttribute::defaultColorAttributeName Returns the name of the default color attribute</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultColorAttributeName">Qt3DCore::QAttribute::<wbr>defaultColorAttributeName()</a></code></p>
     */
    @QtPropertyReader(name="defaultColorAttributeName")
    @QtPropertyConstant
    public native static java.lang.@NonNull String defaultColorAttributeName();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #defaultJointIndicesAttributeName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static java.lang.@NonNull String getDefaultJointIndicesAttributeName() {
        return defaultJointIndicesAttributeName();
    }
    
    /**
     * <p>QAttribute::defaultJointIndicesAttributeName Returns the name of the default joint indices attribute</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultJointIndicesAttributeName">Qt3DCore::QAttribute::<wbr>defaultJointIndicesAttributeName()</a></code></p>
     */
    @QtPropertyReader(name="defaultJointIndicesAttributeName")
    @QtPropertyConstant
    public native static java.lang.@NonNull String defaultJointIndicesAttributeName();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #defaultJointWeightsAttributeName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static java.lang.@NonNull String getDefaultJointWeightsAttributeName() {
        return defaultJointWeightsAttributeName();
    }
    
    /**
     * <p>QAttribute::defaultJointIndicesAttributeName Returns the name of the default joint weights attribute</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultJointWeightsAttributeName">Qt3DCore::QAttribute::<wbr>defaultJointWeightsAttributeName()</a></code></p>
     */
    @QtPropertyReader(name="defaultJointWeightsAttributeName")
    @QtPropertyConstant
    public native static java.lang.@NonNull String defaultJointWeightsAttributeName();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #defaultNormalAttributeName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static java.lang.@NonNull String getDefaultNormalAttributeName() {
        return defaultNormalAttributeName();
    }
    
    /**
     * <p>QAttribute::defaultNormalAttributeName Returns the name of the default normal attribute</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultNormalAttributeName">Qt3DCore::QAttribute::<wbr>defaultNormalAttributeName()</a></code></p>
     */
    @QtPropertyReader(name="defaultNormalAttributeName")
    @QtPropertyConstant
    public native static java.lang.@NonNull String defaultNormalAttributeName();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #defaultPositionAttributeName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static java.lang.@NonNull String getDefaultPositionAttributeName() {
        return defaultPositionAttributeName();
    }
    
    /**
     * <p>QAttribute::defaultPositionAttributeName Returns the name of the default position attribute</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultPositionAttributeName">Qt3DCore::QAttribute::<wbr>defaultPositionAttributeName()</a></code></p>
     */
    @QtPropertyReader(name="defaultPositionAttributeName")
    @QtPropertyConstant
    public native static java.lang.@NonNull String defaultPositionAttributeName();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #defaultTangentAttributeName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static java.lang.@NonNull String getDefaultTangentAttributeName() {
        return defaultTangentAttributeName();
    }
    
    /**
     * <p>QAttribute::defaultTangentAttributeName Returns the name of the default tangent attribute</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultTangentAttributeName">Qt3DCore::QAttribute::<wbr>defaultTangentAttributeName()</a></code></p>
     */
    @QtPropertyReader(name="defaultTangentAttributeName")
    @QtPropertyConstant
    public native static java.lang.@NonNull String defaultTangentAttributeName();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #defaultTextureCoordinate1AttributeName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static java.lang.@NonNull String getDefaultTextureCoordinate1AttributeName() {
        return defaultTextureCoordinate1AttributeName();
    }
    
    /**
     * <p>QAttribute::defaultTextureCoordinate1AttributeName Returns the name of the default attribute for the second layer of texture coordinates</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultTextureCoordinate1AttributeName">Qt3DCore::QAttribute::<wbr>defaultTextureCoordinate1AttributeName()</a></code></p>
     */
    @QtPropertyReader(name="defaultTextureCoordinate1AttributeName")
    @QtPropertyConstant
    public native static java.lang.@NonNull String defaultTextureCoordinate1AttributeName();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #defaultTextureCoordinate2AttributeName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static java.lang.@NonNull String getDefaultTextureCoordinate2AttributeName() {
        return defaultTextureCoordinate2AttributeName();
    }
    
    /**
     * <p>QAttribute::defaultTextureCoordinate2AttributeName Returns the name of the default attribute for the third layer of texture coordinates</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultTextureCoordinate2AttributeName">Qt3DCore::QAttribute::<wbr>defaultTextureCoordinate2AttributeName()</a></code></p>
     */
    @QtPropertyReader(name="defaultTextureCoordinate2AttributeName")
    @QtPropertyConstant
    public native static java.lang.@NonNull String defaultTextureCoordinate2AttributeName();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #defaultTextureCoordinateAttributeName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static java.lang.@NonNull String getDefaultTextureCoordinateAttributeName() {
        return defaultTextureCoordinateAttributeName();
    }
    
    /**
     * <p>QAttribute::defaultTextureCoordinateAttributeName Returns the name of the default texture coordinate attribute</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultTextureCoordinateAttributeName">Qt3DCore::QAttribute::<wbr>defaultTextureCoordinateAttributeName()</a></code></p>
     */
    @QtPropertyReader(name="defaultTextureCoordinateAttributeName")
    @QtPropertyConstant
    public native static java.lang.@NonNull String defaultTextureCoordinateAttributeName();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAttribute(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QAttribute(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAttribute instance, QDeclarativeConstructor constructor);
    
}
