package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Responsible for handling all the QAbstractAspect subclasses that have been registered with the scene</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dcore-qaspectengine.html">Qt3DCore::QAspectEngine</a></code></p>
 */
public class QAspectEngine extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAspectEngine.class);
    
    /**
     * <p>Java wrapper for Qt enum <code>Qt3DCore::QAspectEngine::RunMode</code></p>
     */
    public enum RunMode implements QtEnumerator {
        /**
         * <p>Representing <code>Qt3DCore::<wbr>QAspectEngine::<wbr>Manual</code></p>
         */
        Manual(0),
        /**
         * <p>Representing <code>Qt3DCore::<wbr>QAspectEngine::<wbr>Automatic</code></p>
         */
        Automatic(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RunMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull RunMode resolve(int value) {
            switch (value) {
            case 0: return Manual;
            case 1: return Automatic;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #QAspectEngine(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAspectEngine() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qaspectengine.html#QAspectEngine">Qt3DCore::QAspectEngine::<wbr>QAspectEngine(QObject*)</a></code></p>
     */
    public QAspectEngine(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAspectEngine instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qaspectengine.html#aspect">Qt3DCore::QAspectEngine::<wbr>aspect(QString)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QAbstractAspect aspect(java.lang.@NonNull String name){
        return aspect_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QAbstractAspect aspect_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qaspectengine.html#aspects">Qt3DCore::QAspectEngine::<wbr>aspects()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.core.@Nullable QAbstractAspect> aspects(){
        return aspects_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.core.QAbstractAspect> aspects_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qaspectengine.html#executeCommand">Qt3DCore::QAspectEngine::<wbr>executeCommand(QString)</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object executeCommand(java.lang.@NonNull String command){
        return executeCommand_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), command);
    }
    
    @QtUninvokable
    private native java.lang.Object executeCommand_native_cref_QString(long __this__nativeId, java.lang.String command);
    
    /**
     * <p>See <code>Qt3DCore::QAspectEngine::<wbr>lookupNode(Qt3DCore::QNodeId)const</code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QNode lookupNode(io.qt.qt3d.core.@NonNull QNodeId id){
        return lookupNode_native_Qt3DCore_QNodeId_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(id));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QNode lookupNode_native_Qt3DCore_QNodeId_constfct(long __this__nativeId, long id);
    
    /**
     * <p>See <code>Qt3DCore::QAspectEngine::<wbr>lookupNodes(QList&lt;Qt3DCore::QNodeId&gt;)const</code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.core.@Nullable QNode> lookupNodes(java.util.@NonNull Collection<? extends io.qt.qt3d.core.@NonNull QNodeId> ids){
        return lookupNodes_native_cref_QList_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), ids);
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.core.QNode> lookupNodes_native_cref_QList_constfct(long __this__nativeId, java.util.Collection<? extends io.qt.qt3d.core.QNodeId> ids);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qaspectengine.html#processFrame">Qt3DCore::QAspectEngine::<wbr>processFrame()</a></code></p>
     */
    @QtUninvokable
    public final void processFrame(){
        processFrame_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void processFrame_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qaspectengine.html#registerAspect">Qt3DCore::QAspectEngine::<wbr>registerAspect(Qt3DCore::QAbstractAspect*)</a></code></p>
     */
    @QtUninvokable
    public final void registerAspect(io.qt.qt3d.core.@Nullable QAbstractAspect aspect){
        registerAspect_native_Qt3DCore_QAbstractAspect_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(aspect));
    }
    
    @QtUninvokable
    private native void registerAspect_native_Qt3DCore_QAbstractAspect_ptr(long __this__nativeId, long aspect);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qaspectengine.html#registerAspect-1">Qt3DCore::QAspectEngine::<wbr>registerAspect(QString)</a></code></p>
     */
    @QtUninvokable
    public final void registerAspect(java.lang.@NonNull String name){
        registerAspect_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void registerAspect_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qaspectengine.html#rootEntity">Qt3DCore::QAspectEngine::<wbr>rootEntity()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QEntity rootEntity(){
        return rootEntity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QEntity rootEntity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>Qt3DCore::QAspectEngine::<wbr>runMode()const</code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.core.QAspectEngine.@NonNull RunMode runMode(){
        return io.qt.qt3d.core.QAspectEngine.RunMode.resolve(runMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int runMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qaspectengine.html#setRootEntity">Qt3DCore::QAspectEngine::<wbr>setRootEntity(Qt3DCore::QEntityPtr)</a></code></p>
     */
    @QtUninvokable
    public final void setRootEntity(io.qt.qt3d.core.@Nullable QEntity root){
        setRootEntity_native_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), root);
    }
    
    @QtUninvokable
    private native void setRootEntity_native_QSharedPointer(long __this__nativeId, io.qt.qt3d.core.QEntity root);
    
    /**
     * <p>See <code>Qt3DCore::QAspectEngine::<wbr>setRunMode(Qt3DCore::QAspectEngine::RunMode)</code></p>
     */
    @QtUninvokable
    public final void setRunMode(io.qt.qt3d.core.QAspectEngine.@NonNull RunMode mode){
        setRunMode_native_Qt3DCore_QAspectEngine_RunMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @QtUninvokable
    private native void setRunMode_native_Qt3DCore_QAspectEngine_RunMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qaspectengine.html#unregisterAspect">Qt3DCore::QAspectEngine::<wbr>unregisterAspect(Qt3DCore::QAbstractAspect*)</a></code></p>
     */
    @QtUninvokable
    public final void unregisterAspect(io.qt.qt3d.core.@Nullable QAbstractAspect aspect){
        unregisterAspect_native_Qt3DCore_QAbstractAspect_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(aspect));
    }
    
    @QtUninvokable
    private native void unregisterAspect_native_Qt3DCore_QAbstractAspect_ptr(long __this__nativeId, long aspect);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dcore-qaspectengine.html#unregisterAspect-1">Qt3DCore::QAspectEngine::<wbr>unregisterAspect(QString)</a></code></p>
     */
    @QtUninvokable
    public final void unregisterAspect(java.lang.@NonNull String name){
        unregisterAspect_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void unregisterAspect_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAspectEngine(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QAspectEngine(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAspectEngine instance, QDeclarativeConstructor constructor);
    
}
