package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Uniquely identifies a QNode</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3dcore-qnodeid.html">Qt3DCore::QNodeId</a></p>
 */
public class QNodeId extends QtObject
    implements java.lang.Comparable<io.qt.qt3d.core.QNodeId>,
            java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    public QNodeId(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QNodeId instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qnodeid.html#id">Qt3DCore::QNodeId::id()const</a></p>
     */
    @QtUninvokable
    public final long id(){
        return id_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long id_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qnodeid.html#isNull">Qt3DCore::QNodeId::isNull()const</a></p>
     */
    @QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qnodeid.html#operator-lt">Qt3DCore::QNodeId::operator&lt;(Qt3DCore::QNodeId)const</a></p>
     */
    @QtUninvokable
    private final boolean operator_less(io.qt.qt3d.core.@NonNull QNodeId other){
        return operator_less_native_Qt3DCore_QNodeId_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean operator_less_native_Qt3DCore_QNodeId_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qnodeid.html#operator-eq-eq">Qt3DCore::QNodeId::operator==(Qt3DCore::QNodeId)const</a></p>
     */
    @QtUninvokable
    private final boolean operator_equal(io.qt.qt3d.core.@NonNull QNodeId other){
        return operator_equal_native_Qt3DCore_QNodeId_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_Qt3DCore_QNodeId_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qnodeid.html#createId">Qt3DCore::QNodeId::createId()</a></p>
     */
    public native static io.qt.qt3d.core.@NonNull QNodeId createId();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QNodeId(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.qt3d.core.QNodeId) {
            return operator_equal((io.qt.qt3d.core.QNodeId) other);
        }

        return false;
    }

    @QtUninvokable
    public int compareTo(io.qt.qt3d.core.QNodeId other) {
        if (equals(other)) return 0;
        else if (operator_less(other)) return -1;
        else return 1;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QNodeId clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QNodeId clone_native(long __this_nativeId);
}
