package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Can be used to override the bounding volume of an entity</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3dcore-qboundingvolume.html">Qt3DCore::QBoundingVolume</a></p>
 */
public class QBoundingVolume extends io.qt.qt3d.core.QComponent
{
    @QtPropertyMember(enabled=false)
    private Object __rcView = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QBoundingVolume.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qboundingvolume.html#implicitMaxPoint-prop">Qt3DCore::QBoundingVolume::implicitMaxPointChanged(QVector3D)</a></p>
     */
    @QtPropertyNotify(name="implicitMaxPoint")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> implicitMaxPointChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qboundingvolume.html#implicitMinPoint-prop">Qt3DCore::QBoundingVolume::implicitMinPointChanged(QVector3D)</a></p>
     */
    @QtPropertyNotify(name="implicitMinPoint")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> implicitMinPointChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qboundingvolume.html#implicitPointsValid-prop">Qt3DCore::QBoundingVolume::implicitPointsValidChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="implicitPointsValid")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> implicitPointsValidChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qboundingvolume.html#maxPoint-prop">Qt3DCore::QBoundingVolume::maxPointChanged(QVector3D)</a></p>
     */
    @QtPropertyNotify(name="maxPoint")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> maxPointChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qboundingvolume.html#minPoint-prop">Qt3DCore::QBoundingVolume::minPointChanged(QVector3D)</a></p>
     */
    @QtPropertyNotify(name="minPoint")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> minPointChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qboundingvolume.html#view-prop">Qt3DCore::QBoundingVolume::viewChanged(Qt3DCore::QGeometryView*)</a></p>
     */
    @QtPropertyNotify(name="view")
    public final @NonNull Signal1<io.qt.qt3d.core.@Nullable QGeometryView> viewChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QBoundingVolume(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QBoundingVolume() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qboundingvolume.html#QBoundingVolume">Qt3DCore::QBoundingVolume::QBoundingVolume(Qt3DCore::QNode*)</a></p>
     */
    public QBoundingVolume(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QBoundingVolume instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #areImplicitPointsValid()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getImplicitPointsValid() {
        return areImplicitPointsValid();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qboundingvolume.html#implicitPointsValid-prop">Qt3DCore::QBoundingVolume::areImplicitPointsValid()const</a></p>
     */
    @QtPropertyReader(name="implicitPointsValid")
    @QtUninvokable
    public final boolean areImplicitPointsValid(){
        return areImplicitPointsValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean areImplicitPointsValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #implicitMaxPoint()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getImplicitMaxPoint() {
        return implicitMaxPoint();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qboundingvolume.html#implicitMaxPoint-prop">Qt3DCore::QBoundingVolume::implicitMaxPoint()const</a></p>
     */
    @QtPropertyReader(name="implicitMaxPoint")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D implicitMaxPoint(){
        return implicitMaxPoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D implicitMaxPoint_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #implicitMinPoint()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getImplicitMinPoint() {
        return implicitMinPoint();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qboundingvolume.html#implicitMinPoint-prop">Qt3DCore::QBoundingVolume::implicitMinPoint()const</a></p>
     */
    @QtPropertyReader(name="implicitMinPoint")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D implicitMinPoint(){
        return implicitMinPoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D implicitMinPoint_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxPoint()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getMaxPoint() {
        return maxPoint();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qboundingvolume.html#maxPoint-prop">Qt3DCore::QBoundingVolume::maxPoint()const</a></p>
     */
    @QtPropertyReader(name="maxPoint")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D maxPoint(){
        return maxPoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D maxPoint_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #minPoint()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getMinPoint() {
        return minPoint();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qboundingvolume.html#minPoint-prop">Qt3DCore::QBoundingVolume::minPoint()const</a></p>
     */
    @QtPropertyReader(name="minPoint")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D minPoint(){
        return minPoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D minPoint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qboundingvolume.html#maxPoint-prop">Qt3DCore::QBoundingVolume::setMaxPoint(QVector3D)</a></p>
     */
    @QtPropertyWriter(name="maxPoint")
    public final void setMaxPoint(io.qt.gui.@NonNull QVector3D maxPoint){
        setMaxPoint_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(maxPoint));
    }
    
    private native void setMaxPoint_native_cref_QVector3D(long __this__nativeId, long maxPoint);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qboundingvolume.html#minPoint-prop">Qt3DCore::QBoundingVolume::setMinPoint(QVector3D)</a></p>
     */
    @QtPropertyWriter(name="minPoint")
    public final void setMinPoint(io.qt.gui.@NonNull QVector3D minPoint){
        setMinPoint_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(minPoint));
    }
    
    private native void setMinPoint_native_cref_QVector3D(long __this__nativeId, long minPoint);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qboundingvolume.html#view-prop">Qt3DCore::QBoundingVolume::setView(Qt3DCore::QGeometryView*)</a></p>
     */
    @QtPropertyWriter(name="view")
    public final void setView(io.qt.qt3d.core.@Nullable QGeometryView view){
        setView_native_Qt3DCore_QGeometryView_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(view));
        __rcView = view;
    }
    
    private native void setView_native_Qt3DCore_QGeometryView_ptr(long __this__nativeId, long view);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qboundingvolume.html#updateImplicitBounds">Qt3DCore::QBoundingVolume::updateImplicitBounds()</a></p>
     */
    public final boolean updateImplicitBounds(){
        return updateImplicitBounds_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native boolean updateImplicitBounds_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #view()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QGeometryView getView() {
        return view();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qboundingvolume.html#view-prop">Qt3DCore::QBoundingVolume::view()const</a></p>
     */
    @QtPropertyReader(name="view")
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QGeometryView view(){
        return view_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QGeometryView view_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QBoundingVolume(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QBoundingVolume(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QBoundingVolume instance, QDeclarativeConstructor constructor);
    
}
