package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Defines an attribute and how data should be read from a QBuffer</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html">Qt3DCore::QAttribute</a></p>
 */
public class QAttribute extends io.qt.qt3d.core.QNode
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAttribute.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#AttributeType-enum">Qt3DCore::QAttribute::AttributeType</a></p>
     */
    public enum AttributeType implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#AttributeType-enum">Qt3DCore::QAttribute::VertexAttribute</a></p>
         */
        VertexAttribute(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#AttributeType-enum">Qt3DCore::QAttribute::IndexAttribute</a></p>
         */
        IndexAttribute(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#AttributeType-enum">Qt3DCore::QAttribute::DrawIndirectAttribute</a></p>
         */
        DrawIndirectAttribute(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private AttributeType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull AttributeType resolve(int value) {
            switch (value) {
            case 0: return VertexAttribute;
            case 1: return IndexAttribute;
            case 2: return DrawIndirectAttribute;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#VertexBaseType-enum">Qt3DCore::QAttribute::VertexBaseType</a></p>
     */
    public enum VertexBaseType implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#VertexBaseType-enum">Qt3DCore::QAttribute::Byte</a></p>
         */
        Byte(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#VertexBaseType-enum">Qt3DCore::QAttribute::UnsignedByte</a></p>
         */
        UnsignedByte(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#VertexBaseType-enum">Qt3DCore::QAttribute::Short</a></p>
         */
        Short(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#VertexBaseType-enum">Qt3DCore::QAttribute::UnsignedShort</a></p>
         */
        UnsignedShort(3),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#VertexBaseType-enum">Qt3DCore::QAttribute::Int</a></p>
         */
        Int(4),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#VertexBaseType-enum">Qt3DCore::QAttribute::UnsignedInt</a></p>
         */
        UnsignedInt(5),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#VertexBaseType-enum">Qt3DCore::QAttribute::HalfFloat</a></p>
         */
        HalfFloat(6),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#VertexBaseType-enum">Qt3DCore::QAttribute::Float</a></p>
         */
        Float(7),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#VertexBaseType-enum">Qt3DCore::QAttribute::Double</a></p>
         */
        Double(8);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private VertexBaseType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull VertexBaseType resolve(int value) {
            switch (value) {
            case 0: return Byte;
            case 1: return UnsignedByte;
            case 2: return Short;
            case 3: return UnsignedShort;
            case 4: return Int;
            case 5: return UnsignedInt;
            case 6: return HalfFloat;
            case 7: return Float;
            case 8: return Double;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#attributeType-prop">Qt3DCore::QAttribute::attributeTypeChanged(Qt3DCore::QAttribute::AttributeType)</a></p>
     */
    @QtPropertyNotify(name="attributeType")
    public final @NonNull Signal1<io.qt.qt3d.core.QAttribute.@NonNull AttributeType> attributeTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#buffer-prop">Qt3DCore::QAttribute::bufferChanged(QBuffer*)</a></p>
     */
    @QtPropertyNotify(name="buffer")
    public final @NonNull Signal1<io.qt.qt3d.core.@Nullable QBuffer> bufferChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#byteOffset-prop">Qt3DCore::QAttribute::byteOffsetChanged(uint)</a></p>
     */
    @QtPropertyNotify(name="byteOffset")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> byteOffsetChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#byteStride-prop">Qt3DCore::QAttribute::byteStrideChanged(uint)</a></p>
     */
    @QtPropertyNotify(name="byteStride")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> byteStrideChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#count-prop">Qt3DCore::QAttribute::countChanged(uint)</a></p>
     */
    @QtPropertyNotify(name="count")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> countChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#dataSizeChanged">Qt3DCore::QAttribute::dataSizeChanged(uint)</a></p>
     */
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> dataSizeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#dataTypeChanged">Qt3DCore::QAttribute::dataTypeChanged(Qt3DCore::QAttribute::VertexBaseType)</a></p>
     */
    public final @NonNull Signal1<io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType> dataTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#divisor-prop">Qt3DCore::QAttribute::divisorChanged(uint)</a></p>
     */
    @QtPropertyNotify(name="divisor")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> divisorChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#name-prop">Qt3DCore::QAttribute::nameChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="name")
    public final @NonNull Signal1<java.lang.@NonNull String> nameChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#vertexBaseType-prop">Qt3DCore::QAttribute::vertexBaseTypeChanged(Qt3DCore::QAttribute::VertexBaseType)</a></p>
     */
    @QtPropertyNotify(name="vertexBaseType")
    public final @NonNull Signal1<io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType> vertexBaseTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#vertexSize-prop">Qt3DCore::QAttribute::vertexSizeChanged(uint)</a></p>
     */
    @QtPropertyNotify(name="vertexSize")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> vertexSizeChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QAttribute(io.qt.qt3d.core.QBuffer, io.qt.qt3d.core.QAttribute.VertexBaseType, int, int, int, int, io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAttribute(io.qt.qt3d.core.@Nullable QBuffer buf, io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType vertexBaseType, int vertexSize, int count, int offset, int stride) {
        this(buf, vertexBaseType, vertexSize, count, offset, stride, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAttribute(io.qt.qt3d.core.QBuffer, io.qt.qt3d.core.QAttribute.VertexBaseType, int, int, int, int, io.qt.qt3d.core.QNode)}</p>
     * <p>with: </p><ul>
     * <li><code>stride = 0</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QAttribute(io.qt.qt3d.core.@Nullable QBuffer buf, io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType vertexBaseType, int vertexSize, int count, int offset) {
        this(buf, vertexBaseType, vertexSize, count, offset, (int)0, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAttribute(io.qt.qt3d.core.QBuffer, io.qt.qt3d.core.QAttribute.VertexBaseType, int, int, int, int, io.qt.qt3d.core.QNode)}</p>
     * <p>with: </p><ul>
     * <li><code>offset = 0</code></li>
     * <li><code>stride = 0</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QAttribute(io.qt.qt3d.core.@Nullable QBuffer buf, io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType vertexBaseType, int vertexSize, int count) {
        this(buf, vertexBaseType, vertexSize, count, (int)0, (int)0, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#QAttribute-1">Qt3DCore::QAttribute::QAttribute(QBuffer*,Qt3DCore::QAttribute::VertexBaseType,uint,uint,uint,uint,Qt3DCore::QNode*)</a></p>
     */
    public QAttribute(io.qt.qt3d.core.@Nullable QBuffer buf, io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType vertexBaseType, int vertexSize, int count, int offset, int stride, io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, buf, vertexBaseType, vertexSize, count, offset, stride, parent);
    }
    
    private native static void initialize_native(QAttribute instance, io.qt.qt3d.core.QBuffer buf, io.qt.qt3d.core.QAttribute.VertexBaseType vertexBaseType, int vertexSize, int count, int offset, int stride, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Overloaded constructor for {@link #QAttribute(io.qt.qt3d.core.QBuffer, java.lang.String, io.qt.qt3d.core.QAttribute.VertexBaseType, int, int, int, int, io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAttribute(io.qt.qt3d.core.@Nullable QBuffer buf, java.lang.@NonNull String name, io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType vertexBaseType, int vertexSize, int count, int offset, int stride) {
        this(buf, name, vertexBaseType, vertexSize, count, offset, stride, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAttribute(io.qt.qt3d.core.QBuffer, java.lang.String, io.qt.qt3d.core.QAttribute.VertexBaseType, int, int, int, int, io.qt.qt3d.core.QNode)}</p>
     * <p>with: </p><ul>
     * <li><code>stride = 0</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QAttribute(io.qt.qt3d.core.@Nullable QBuffer buf, java.lang.@NonNull String name, io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType vertexBaseType, int vertexSize, int count, int offset) {
        this(buf, name, vertexBaseType, vertexSize, count, offset, (int)0, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAttribute(io.qt.qt3d.core.QBuffer, java.lang.String, io.qt.qt3d.core.QAttribute.VertexBaseType, int, int, int, int, io.qt.qt3d.core.QNode)}</p>
     * <p>with: </p><ul>
     * <li><code>offset = 0</code></li>
     * <li><code>stride = 0</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QAttribute(io.qt.qt3d.core.@Nullable QBuffer buf, java.lang.@NonNull String name, io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType vertexBaseType, int vertexSize, int count) {
        this(buf, name, vertexBaseType, vertexSize, count, (int)0, (int)0, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#QAttribute-2">Qt3DCore::QAttribute::QAttribute(QBuffer*,QString,Qt3DCore::QAttribute::VertexBaseType,uint,uint,uint,uint,Qt3DCore::QNode*)</a></p>
     */
    public QAttribute(io.qt.qt3d.core.@Nullable QBuffer buf, java.lang.@NonNull String name, io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType vertexBaseType, int vertexSize, int count, int offset, int stride, io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, buf, name, vertexBaseType, vertexSize, count, offset, stride, parent);
    }
    
    private native static void initialize_native(QAttribute instance, io.qt.qt3d.core.QBuffer buf, java.lang.String name, io.qt.qt3d.core.QAttribute.VertexBaseType vertexBaseType, int vertexSize, int count, int offset, int stride, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Overloaded constructor for {@link #QAttribute(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAttribute() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#QAttribute">Qt3DCore::QAttribute::QAttribute(Qt3DCore::QNode*)</a></p>
     */
    public QAttribute(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAttribute instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #attributeType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.core.QAttribute.@NonNull AttributeType getAttributeType() {
        return attributeType();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#attributeType-prop">Qt3DCore::QAttribute::attributeType()const</a></p>
     */
    @QtPropertyReader(name="attributeType")
    @QtUninvokable
    public final io.qt.qt3d.core.QAttribute.@NonNull AttributeType attributeType(){
        return io.qt.qt3d.core.QAttribute.AttributeType.resolve(attributeType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int attributeType_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #buffer()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QBuffer getBuffer() {
        return buffer();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#buffer-prop">Qt3DCore::QAttribute::buffer()const</a></p>
     */
    @QtPropertyReader(name="buffer")
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QBuffer buffer(){
        return buffer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QBuffer buffer_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #byteOffset()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getByteOffset() {
        return byteOffset();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#byteOffset-prop">Qt3DCore::QAttribute::byteOffset()const</a></p>
     */
    @QtPropertyReader(name="byteOffset")
    @QtUninvokable
    public final int byteOffset(){
        return byteOffset_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int byteOffset_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #byteStride()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getByteStride() {
        return byteStride();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#byteStride-prop">Qt3DCore::QAttribute::byteStride()const</a></p>
     */
    @QtPropertyReader(name="byteStride")
    @QtUninvokable
    public final int byteStride(){
        return byteStride_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int byteStride_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #count()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getCount() {
        return count();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#count-prop">Qt3DCore::QAttribute::count()const</a></p>
     */
    @QtPropertyReader(name="count")
    @QtUninvokable
    public final int count(){
        return count_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int count_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #divisor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getDivisor() {
        return divisor();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#divisor-prop">Qt3DCore::QAttribute::divisor()const</a></p>
     */
    @QtPropertyReader(name="divisor")
    @QtUninvokable
    public final int divisor(){
        return divisor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int divisor_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #name()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getName() {
        return name();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#name-prop">Qt3DCore::QAttribute::name()const</a></p>
     */
    @QtPropertyReader(name="name")
    @QtUninvokable
    public final java.lang.@NonNull String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#attributeType-prop">Qt3DCore::QAttribute::setAttributeType(Qt3DCore::QAttribute::AttributeType)</a></p>
     */
    @QtPropertyWriter(name="attributeType")
    public final void setAttributeType(io.qt.qt3d.core.QAttribute.@NonNull AttributeType attributeType){
        setAttributeType_native_Qt3DCore_QAttribute_AttributeType(QtJambi_LibraryUtilities.internal.nativeId(this), attributeType.value());
    }
    
    private native void setAttributeType_native_Qt3DCore_QAttribute_AttributeType(long __this__nativeId, int attributeType);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#buffer-prop">Qt3DCore::QAttribute::setBuffer(QBuffer*)</a></p>
     */
    @QtPropertyWriter(name="buffer")
    public final void setBuffer(io.qt.qt3d.core.@Nullable QBuffer buffer){
        setBuffer_native_Qt3DCore_QBuffer_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(buffer));
    }
    
    private native void setBuffer_native_Qt3DCore_QBuffer_ptr(long __this__nativeId, long buffer);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#byteOffset-prop">Qt3DCore::QAttribute::setByteOffset(uint)</a></p>
     */
    @QtPropertyWriter(name="byteOffset")
    public final void setByteOffset(int byteOffset){
        setByteOffset_native_uint(QtJambi_LibraryUtilities.internal.nativeId(this), byteOffset);
    }
    
    private native void setByteOffset_native_uint(long __this__nativeId, int byteOffset);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#byteStride-prop">Qt3DCore::QAttribute::setByteStride(uint)</a></p>
     */
    @QtPropertyWriter(name="byteStride")
    public final void setByteStride(int byteStride){
        setByteStride_native_uint(QtJambi_LibraryUtilities.internal.nativeId(this), byteStride);
    }
    
    private native void setByteStride_native_uint(long __this__nativeId, int byteStride);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#count-prop">Qt3DCore::QAttribute::setCount(uint)</a></p>
     */
    @QtPropertyWriter(name="count")
    public final void setCount(int count){
        setCount_native_uint(QtJambi_LibraryUtilities.internal.nativeId(this), count);
    }
    
    private native void setCount_native_uint(long __this__nativeId, int count);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#divisor-prop">Qt3DCore::QAttribute::setDivisor(uint)</a></p>
     */
    @QtPropertyWriter(name="divisor")
    public final void setDivisor(int divisor){
        setDivisor_native_uint(QtJambi_LibraryUtilities.internal.nativeId(this), divisor);
    }
    
    private native void setDivisor_native_uint(long __this__nativeId, int divisor);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#name-prop">Qt3DCore::QAttribute::setName(QString)</a></p>
     */
    @QtPropertyWriter(name="name")
    public final void setName(java.lang.@NonNull String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#vertexBaseType-prop">Qt3DCore::QAttribute::setVertexBaseType(Qt3DCore::QAttribute::VertexBaseType)</a></p>
     */
    @QtPropertyWriter(name="vertexBaseType")
    public final void setVertexBaseType(io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType type){
        setVertexBaseType_native_Qt3DCore_QAttribute_VertexBaseType(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    private native void setVertexBaseType_native_Qt3DCore_QAttribute_VertexBaseType(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#vertexSize-prop">Qt3DCore::QAttribute::setVertexSize(uint)</a></p>
     */
    @QtPropertyWriter(name="vertexSize")
    public final void setVertexSize(int size){
        setVertexSize_native_uint(QtJambi_LibraryUtilities.internal.nativeId(this), size);
    }
    
    private native void setVertexSize_native_uint(long __this__nativeId, int size);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #vertexBaseType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType getVertexBaseType() {
        return vertexBaseType();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#vertexBaseType-prop">Qt3DCore::QAttribute::vertexBaseType()const</a></p>
     */
    @QtPropertyReader(name="vertexBaseType")
    @QtUninvokable
    public final io.qt.qt3d.core.QAttribute.@NonNull VertexBaseType vertexBaseType(){
        return io.qt.qt3d.core.QAttribute.VertexBaseType.resolve(vertexBaseType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int vertexBaseType_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #vertexSize()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getVertexSize() {
        return vertexSize();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#vertexSize-prop">Qt3DCore::QAttribute::vertexSize()const</a></p>
     */
    @QtPropertyReader(name="vertexSize")
    @QtUninvokable
    public final int vertexSize(){
        return vertexSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int vertexSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #defaultColorAttributeName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static java.lang.@NonNull String getDefaultColorAttributeName() {
        return defaultColorAttributeName();
    }
    
    /**
     * <p>QAttribute::defaultColorAttributeName Returns the name of the default color attribute</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultColorAttributeName">Qt3DCore::QAttribute::defaultColorAttributeName()</a></p>
     */
    @QtPropertyReader(name="defaultColorAttributeName")
    @QtPropertyConstant
    public native static java.lang.@NonNull String defaultColorAttributeName();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #defaultJointIndicesAttributeName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static java.lang.@NonNull String getDefaultJointIndicesAttributeName() {
        return defaultJointIndicesAttributeName();
    }
    
    /**
     * <p>QAttribute::defaultJointIndicesAttributeName Returns the name of the default joint indices attribute</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultJointIndicesAttributeName">Qt3DCore::QAttribute::defaultJointIndicesAttributeName()</a></p>
     */
    @QtPropertyReader(name="defaultJointIndicesAttributeName")
    @QtPropertyConstant
    public native static java.lang.@NonNull String defaultJointIndicesAttributeName();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #defaultJointWeightsAttributeName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static java.lang.@NonNull String getDefaultJointWeightsAttributeName() {
        return defaultJointWeightsAttributeName();
    }
    
    /**
     * <p>QAttribute::defaultJointIndicesAttributeName Returns the name of the default joint weights attribute</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultJointWeightsAttributeName">Qt3DCore::QAttribute::defaultJointWeightsAttributeName()</a></p>
     */
    @QtPropertyReader(name="defaultJointWeightsAttributeName")
    @QtPropertyConstant
    public native static java.lang.@NonNull String defaultJointWeightsAttributeName();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #defaultNormalAttributeName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static java.lang.@NonNull String getDefaultNormalAttributeName() {
        return defaultNormalAttributeName();
    }
    
    /**
     * <p>QAttribute::defaultNormalAttributeName Returns the name of the default normal attribute</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultNormalAttributeName">Qt3DCore::QAttribute::defaultNormalAttributeName()</a></p>
     */
    @QtPropertyReader(name="defaultNormalAttributeName")
    @QtPropertyConstant
    public native static java.lang.@NonNull String defaultNormalAttributeName();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #defaultPositionAttributeName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static java.lang.@NonNull String getDefaultPositionAttributeName() {
        return defaultPositionAttributeName();
    }
    
    /**
     * <p>QAttribute::defaultPositionAttributeName Returns the name of the default position attribute</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultPositionAttributeName">Qt3DCore::QAttribute::defaultPositionAttributeName()</a></p>
     */
    @QtPropertyReader(name="defaultPositionAttributeName")
    @QtPropertyConstant
    public native static java.lang.@NonNull String defaultPositionAttributeName();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #defaultTangentAttributeName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static java.lang.@NonNull String getDefaultTangentAttributeName() {
        return defaultTangentAttributeName();
    }
    
    /**
     * <p>QAttribute::defaultTangentAttributeName Returns the name of the default tangent attribute</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultTangentAttributeName">Qt3DCore::QAttribute::defaultTangentAttributeName()</a></p>
     */
    @QtPropertyReader(name="defaultTangentAttributeName")
    @QtPropertyConstant
    public native static java.lang.@NonNull String defaultTangentAttributeName();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #defaultTextureCoordinate1AttributeName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static java.lang.@NonNull String getDefaultTextureCoordinate1AttributeName() {
        return defaultTextureCoordinate1AttributeName();
    }
    
    /**
     * <p>QAttribute::defaultTextureCoordinate1AttributeName Returns the name of the default attribute for the second layer of texture coordinates</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultTextureCoordinate1AttributeName">Qt3DCore::QAttribute::defaultTextureCoordinate1AttributeName()</a></p>
     */
    @QtPropertyReader(name="defaultTextureCoordinate1AttributeName")
    @QtPropertyConstant
    public native static java.lang.@NonNull String defaultTextureCoordinate1AttributeName();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #defaultTextureCoordinate2AttributeName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static java.lang.@NonNull String getDefaultTextureCoordinate2AttributeName() {
        return defaultTextureCoordinate2AttributeName();
    }
    
    /**
     * <p>QAttribute::defaultTextureCoordinate2AttributeName Returns the name of the default attribute for the third layer of texture coordinates</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultTextureCoordinate2AttributeName">Qt3DCore::QAttribute::defaultTextureCoordinate2AttributeName()</a></p>
     */
    @QtPropertyReader(name="defaultTextureCoordinate2AttributeName")
    @QtPropertyConstant
    public native static java.lang.@NonNull String defaultTextureCoordinate2AttributeName();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #defaultTextureCoordinateAttributeName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static java.lang.@NonNull String getDefaultTextureCoordinateAttributeName() {
        return defaultTextureCoordinateAttributeName();
    }
    
    /**
     * <p>QAttribute::defaultTextureCoordinateAttributeName Returns the name of the default texture coordinate attribute</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultTextureCoordinateAttributeName">Qt3DCore::QAttribute::defaultTextureCoordinateAttributeName()</a></p>
     */
    @QtPropertyReader(name="defaultTextureCoordinateAttributeName")
    @QtPropertyConstant
    public native static java.lang.@NonNull String defaultTextureCoordinateAttributeName();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAttribute(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QAttribute(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAttribute instance, QDeclarativeConstructor constructor);
    
}
