package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>The base class for aspects that provide a vertical slice of behavior</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3dcore-qabstractaspect.html">Qt3DCore::QAbstractAspect</a></p>
 */
public class QAbstractAspect extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractAspect.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractAspect(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAbstractAspect() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qabstractaspect.html#QAbstractAspect">Qt3DCore::QAbstractAspect::QAbstractAspect(QObject*)</a></p>
     */
    public QAbstractAspect(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAbstractAspect instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qabstractaspect.html#registerBackendType-1">Qt3DCore::QAbstractAspect::registerBackendType(QMetaObject,Qt3DCore::QBackendNodeMapperPtr)</a></p>
     */
    @QtUninvokable
    protected final void registerBackendType(io.qt.core.@StrictNonNull QMetaObject obj, io.qt.qt3d.core.@Nullable QBackendNodeMapper functor){
        java.util.Objects.requireNonNull(obj, "Argument 'obj': null not expected.");
        registerBackendType_native_cref_QMetaObject_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), obj, functor);
    }
    
    @QtUninvokable
    private native void registerBackendType_native_cref_QMetaObject_cref_QSharedPointer(long __this__nativeId, io.qt.core.QMetaObject obj, io.qt.qt3d.core.QBackendNodeMapper functor);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qabstractaspect.html#rootEntityId">Qt3DCore::QAbstractAspect::rootEntityId()const</a></p>
     */
    @QtUninvokable
    protected final io.qt.qt3d.core.@NonNull QNodeId rootEntityId(){
        return rootEntityId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QNodeId rootEntityId_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final void scheduleSingleShotJob(io.qt.qt3d.core.@Nullable QAspectJob job){
        scheduleSingleShotJob_native_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), job);
    }
    
    @QtUninvokable
    private native void scheduleSingleShotJob_native_cref_QSharedPointer(long __this__nativeId, io.qt.qt3d.core.QAspectJob job);
    
    @QtUninvokable
    protected final void unregisterBackendType(io.qt.core.@StrictNonNull QMetaObject arg__1){
        java.util.Objects.requireNonNull(arg__1, "Argument 'arg__1': null not expected.");
        unregisterBackendType_native_cref_QMetaObject(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void unregisterBackendType_native_cref_QMetaObject(long __this__nativeId, io.qt.core.QMetaObject arg__1);
    
    @QtUninvokable
    public java.util.@NonNull List<java.lang.@NonNull String> dependencies(){
        return dependencies_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.util.List<java.lang.String> dependencies_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAbstractAspect(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QAbstractAspect(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAbstractAspect instance, QDeclarativeConstructor constructor);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qabstractaspect.html#registerBackendType">Qt3DCore::QAbstractAspect::registerBackendType(Qt3DCore::QBackendNodeMapperPtr)</a></p>
     */
    @QtUninvokable
    protected final void registerBackendType(@StrictNonNull Class<? extends io.qt.core.QObject> type, io.qt.qt3d.core.@Nullable QBackendNodeMapper functor)    {
        registerBackendType(io.qt.core.QMetaObject.forType(type), functor);
    }
    
    @QtUninvokable
    protected final void unregisterBackendType(Class<? extends io.qt.core.QObject> type)    {
        unregisterBackendType(io.qt.core.QMetaObject.forType(type));
    }
}
