package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Contains classes that are the foundation for Qt 3D simulation framework, as well as classes that provide the ability to render using the Qt 3D framework</p>
 * <p>Java wrapper for Qt's namespace <a href="https://doc.qt.io/qt/qt3dcore.html">Qt3DCore</a></p>
 */
public final class Qt3DCore
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private Qt3DCore() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace Qt3DCore."); }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qnode.html#qIdForNode">Qt3DCore::qIdForNode(Qt3DCore::QNode*)</a></p>
     */
    public static io.qt.qt3d.core.@NonNull QNodeId qIdForNode(io.qt.qt3d.core.@Nullable QNode node){
        return qIdForNode_native_Qt3DCore_QNode_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(node));
    }
    
    private native static io.qt.qt3d.core.QNodeId qIdForNode_native_Qt3DCore_QNode_ptr(long node);
    
}
