package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Creates and maps backend nodes to their respective frontend nodes</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3dcore-qbackendnodemapper.html">Qt3DCore::QBackendNodeMapper</a></p>
 */
public abstract class QBackendNodeMapper extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @NativeAccess
    private static final class ConcreteWrapper extends QBackendNodeMapper {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        public io.qt.qt3d.core.@Nullable QBackendNode create(io.qt.qt3d.core.@NonNull QNodeId id){
            return create_native_Qt3DCore_QNodeId_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(id));
        }
        @QtUninvokable
        private native io.qt.qt3d.core.QBackendNode create_native_Qt3DCore_QNodeId_constfct(long __this__nativeId, long id);
        
        
        @Override
        @QtUninvokable
        public void destroy(io.qt.qt3d.core.@NonNull QNodeId id){
            destroy_native_Qt3DCore_QNodeId_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(id));
        }
        @QtUninvokable
        private native void destroy_native_Qt3DCore_QNodeId_constfct(long __this__nativeId, long id);
        
        
        @Override
        @QtUninvokable
        public io.qt.qt3d.core.@Nullable QBackendNode get(io.qt.qt3d.core.@NonNull QNodeId id){
            return get_native_Qt3DCore_QNodeId_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(id));
        }
        @QtUninvokable
        private native io.qt.qt3d.core.QBackendNode get_native_Qt3DCore_QNodeId_constfct(long __this__nativeId, long id);
        
    }
    
    
    public QBackendNodeMapper(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QBackendNodeMapper instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qbackendnodemapper.html#create">Qt3DCore::QBackendNodeMapper::create(Qt3DCore::QNodeId)const</a></p>
     */
    @QtUninvokable
    public abstract io.qt.qt3d.core.@Nullable QBackendNode create(io.qt.qt3d.core.@NonNull QNodeId id);
    
    @QtUninvokable
    private native io.qt.qt3d.core.QBackendNode create_native_Qt3DCore_QNodeId_constfct(long __this__nativeId, long id);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qbackendnodemapper.html#destroy">Qt3DCore::QBackendNodeMapper::destroy(Qt3DCore::QNodeId)const</a></p>
     */
    @QtUninvokable
    public abstract void destroy(io.qt.qt3d.core.@NonNull QNodeId id);
    
    @QtUninvokable
    private native void destroy_native_Qt3DCore_QNodeId_constfct(long __this__nativeId, long id);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qbackendnodemapper.html#get">Qt3DCore::QBackendNodeMapper::get(Qt3DCore::QNodeId)const</a></p>
     */
    @QtUninvokable
    public abstract io.qt.qt3d.core.@Nullable QBackendNode get(io.qt.qt3d.core.@NonNull QNodeId id);
    
    @QtUninvokable
    private native io.qt.qt3d.core.QBackendNode get_native_Qt3DCore_QNodeId_constfct(long __this__nativeId, long id);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QBackendNodeMapper(QPrivateConstructor p) { super(p); } 
    
}
