package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Base class for jobs executed in an aspect</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3dcore-qaspectjob.html">Qt3DCore::QAspectJob</a></p>
 */
public abstract class QAspectJob extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @NativeAccess
    private static final class ConcreteWrapper extends QAspectJob {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        public void run(){
            run_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native void run_native(long __this__nativeId);
        
    }
    
    
    public QAspectJob(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QAspectJob instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qaspectjob.html#addDependency">Qt3DCore::QAspectJob::addDependency(QWeakPointer&lt;Qt3DCore::QAspectJob&gt;)</a></p>
     */
    @QtUninvokable
    public final void addDependency(io.qt.qt3d.core.@Nullable QAspectJob dependency){
        addDependency_native_QWeakPointer(QtJambi_LibraryUtilities.internal.nativeId(this), dependency);
    }
    
    @QtUninvokable
    private native void addDependency_native_QWeakPointer(long __this__nativeId, io.qt.qt3d.core.QAspectJob dependency);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qaspectjob.html#dependencies">Qt3DCore::QAspectJob::dependencies()const</a></p>
     */
    @QtUninvokable
    public final java.util.@NonNull List<io.qt.qt3d.core.@Nullable QAspectJob> dependencies(){
        return dependencies_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.util.List<io.qt.qt3d.core.QAspectJob> dependencies_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qaspectjob.html#removeDependency">Qt3DCore::QAspectJob::removeDependency(QWeakPointer&lt;Qt3DCore::QAspectJob&gt;)</a></p>
     */
    @QtUninvokable
    public final void removeDependency(io.qt.qt3d.core.@Nullable QAspectJob dependency){
        removeDependency_native_QWeakPointer(QtJambi_LibraryUtilities.internal.nativeId(this), dependency);
    }
    
    @QtUninvokable
    private native void removeDependency_native_QWeakPointer(long __this__nativeId, io.qt.qt3d.core.QAspectJob dependency);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qaspectjob.html#isRequired">Qt3DCore::QAspectJob::isRequired()</a></p>
     */
    @QtUninvokable
    public boolean isRequired(){
        return isRequired_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isRequired_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qaspectjob.html#postFrame">Qt3DCore::QAspectJob::postFrame(Qt3DCore::QAspectEngine*)</a></p>
     */
    @QtUninvokable
    public void postFrame(io.qt.qt3d.core.@Nullable QAspectEngine aspectEngine){
        postFrame_native_Qt3DCore_QAspectEngine_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(aspectEngine));
    }
    
    @QtUninvokable
    private native void postFrame_native_Qt3DCore_QAspectEngine_ptr(long __this__nativeId, long aspectEngine);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qaspectjob.html#run">Qt3DCore::QAspectJob::run()</a></p>
     */
    @QtUninvokable
    public abstract void run();
    
    @QtUninvokable
    private native void run_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAspectJob(QPrivateConstructor p) { super(p); } 
    
}
