package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Used to calculate skinning transform matrices and set them on shaders</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3dcore-qarmature.html">Qt3DCore::QArmature</a></p>
 */
public class QArmature extends io.qt.qt3d.core.QComponent
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QArmature.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qarmature.html#skeleton-prop">Qt3DCore::QArmature::skeletonChanged(Qt3DCore::QAbstractSkeleton*)</a></p>
     */
    @QtPropertyNotify(name="skeleton")
    public final @NonNull Signal1<io.qt.qt3d.core.@Nullable QAbstractSkeleton> skeletonChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QArmature() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qarmature.html#QArmature">Qt3DCore::QArmature::QArmature(Qt3DCore::QNode*)</a></p>
     */
    public QArmature(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QArmature instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qarmature.html#skeleton-prop">Qt3DCore::QArmature::setSkeleton(Qt3DCore::QAbstractSkeleton*)</a></p>
     */
    @QtPropertyWriter(name="skeleton")
    public final void setSkeleton(io.qt.qt3d.core.@Nullable QAbstractSkeleton skeleton){
        setSkeleton_native_Qt3DCore_QAbstractSkeleton_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(skeleton));
    }
    
    private native void setSkeleton_native_Qt3DCore_QAbstractSkeleton_ptr(long __this__nativeId, long skeleton);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #skeleton()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QAbstractSkeleton getSkeleton() {
        return skeleton();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qarmature.html#skeleton-prop">Qt3DCore::QArmature::skeleton()const</a></p>
     */
    @QtPropertyReader(name="skeleton")
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QAbstractSkeleton skeleton(){
        return skeleton_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QAbstractSkeleton skeleton_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QArmature(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QArmature(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QArmature instance, QDeclarativeConstructor constructor);
    
}
