package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Abstract base class for all functors</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3dcore-qabstractfunctor.html">Qt3DCore::QAbstractFunctor</a></p>
 */
public interface QAbstractFunctor extends QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.qt3d.core.QAbstractFunctor}</p>
     */
    public static abstract class Impl extends QtObject
        implements io.qt.qt3d.core.QAbstractFunctor
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @NativeAccess
        private static final class ConcreteWrapper extends QAbstractFunctor.Impl {
            
            @NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        }
        
        
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QAbstractFunctor instance);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
}
