package io.qt.qt3d.core;


/**
 * <p>Used to transforms parts of skinned meshes</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html">Qt3DCore::QJoint</a></p>
 */
public class QJoint extends io.qt.qt3d.core.QNode
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QJoint.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#inverseBindMatrix-prop">Qt3DCore::QJoint::inverseBindMatrixChanged(QMatrix4x4)</a></p>
     */
    @io.qt.QtPropertyNotify(name="inverseBindMatrix")
    public final Signal1<io.qt.gui.QMatrix4x4> inverseBindMatrixChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#name-prop">Qt3DCore::QJoint::nameChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="name")
    public final Signal1<java.lang.String> nameChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotation-prop">Qt3DCore::QJoint::rotationChanged(QQuaternion)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rotation")
    public final Signal1<io.qt.gui.QQuaternion> rotationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotationX-prop">Qt3DCore::QJoint::rotationXChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rotationX")
    public final Signal1<@io.qt.QtPrimitiveType Float> rotationXChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotationY-prop">Qt3DCore::QJoint::rotationYChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rotationY")
    public final Signal1<@io.qt.QtPrimitiveType Float> rotationYChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotationZ-prop">Qt3DCore::QJoint::rotationZChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rotationZ")
    public final Signal1<@io.qt.QtPrimitiveType Float> rotationZChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#scale-prop">Qt3DCore::QJoint::scaleChanged(QVector3D)</a></p>
     */
    @io.qt.QtPropertyNotify(name="scale")
    public final Signal1<io.qt.gui.QVector3D> scaleChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#translation-prop">Qt3DCore::QJoint::translationChanged(QVector3D)</a></p>
     */
    @io.qt.QtPropertyNotify(name="translation")
    public final Signal1<io.qt.gui.QVector3D> translationChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QJoint(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QJoint() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#QJoint">Qt3DCore::QJoint::QJoint(Qt3DCore::QNode*)</a></p>
     */
    public QJoint(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QJoint instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#addChildJoint">Qt3DCore::QJoint::addChildJoint(Qt3DCore::QJoint*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addChildJoint(io.qt.qt3d.core.QJoint joint){
        addChildJoint_native_Qt3DCore_QJoint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(joint));
    }
    
    @io.qt.QtUninvokable
    private native void addChildJoint_native_Qt3DCore_QJoint_ptr(long __this__nativeId, long joint);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#childJoints">Qt3DCore::QJoint::childJoints()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.qt3d.core.QJoint> childJoints(){
        return childJoints_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.core.QJoint> childJoints_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#inverseBindMatrix-prop">Qt3DCore::QJoint::inverseBindMatrix()const</a></p>
     */
    @io.qt.QtPropertyReader(name="inverseBindMatrix")
    @io.qt.QtUninvokable
    public final io.qt.gui.QMatrix4x4 inverseBindMatrix(){
        return inverseBindMatrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QMatrix4x4 inverseBindMatrix_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#name">Qt3DCore::QJoint::name()const</a></p>
     */
    @io.qt.QtPropertyReader(name="name")
    @io.qt.QtUninvokable
    public final java.lang.String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#removeChildJoint">Qt3DCore::QJoint::removeChildJoint(Qt3DCore::QJoint*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeChildJoint(io.qt.qt3d.core.QJoint joint){
        removeChildJoint_native_Qt3DCore_QJoint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(joint));
    }
    
    @io.qt.QtUninvokable
    private native void removeChildJoint_native_Qt3DCore_QJoint_ptr(long __this__nativeId, long joint);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotation-prop">Qt3DCore::QJoint::rotation()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rotation")
    @io.qt.QtUninvokable
    public final io.qt.gui.QQuaternion rotation(){
        return rotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QQuaternion rotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotationX-prop">Qt3DCore::QJoint::rotationX()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rotationX")
    @io.qt.QtUninvokable
    public final float rotationX(){
        return rotationX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float rotationX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotationY-prop">Qt3DCore::QJoint::rotationY()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rotationY")
    @io.qt.QtUninvokable
    public final float rotationY(){
        return rotationY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float rotationY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotationZ-prop">Qt3DCore::QJoint::rotationZ()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rotationZ")
    @io.qt.QtUninvokable
    public final float rotationZ(){
        return rotationZ_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float rotationZ_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#scale-prop">Qt3DCore::QJoint::scale()const</a></p>
     */
    @io.qt.QtPropertyReader(name="scale")
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector3D scale(){
        return scale_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector3D scale_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#inverseBindMatrix-prop">Qt3DCore::QJoint::setInverseBindMatrix(QMatrix4x4)</a></p>
     */
    @io.qt.QtPropertyWriter(name="inverseBindMatrix")
    public final void setInverseBindMatrix(io.qt.gui.QMatrix4x4 inverseBindMatrix){
        setInverseBindMatrix_native_cref_QMatrix4x4(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(inverseBindMatrix));
    }
    
    private native void setInverseBindMatrix_native_cref_QMatrix4x4(long __this__nativeId, long inverseBindMatrix);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#name-prop">Qt3DCore::QJoint::setName(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="name")
    public final void setName(java.lang.String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotation-prop">Qt3DCore::QJoint::setRotation(QQuaternion)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rotation")
    public final void setRotation(io.qt.gui.QQuaternion rotation){
        setRotation_native_cref_QQuaternion(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rotation));
    }
    
    private native void setRotation_native_cref_QQuaternion(long __this__nativeId, long rotation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotationX-prop">Qt3DCore::QJoint::setRotationX(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rotationX")
    public final void setRotationX(float rotationX){
        setRotationX_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), rotationX);
    }
    
    private native void setRotationX_native_float(long __this__nativeId, float rotationX);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotationY-prop">Qt3DCore::QJoint::setRotationY(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rotationY")
    public final void setRotationY(float rotationY){
        setRotationY_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), rotationY);
    }
    
    private native void setRotationY_native_float(long __this__nativeId, float rotationY);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#rotationZ-prop">Qt3DCore::QJoint::setRotationZ(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rotationZ")
    public final void setRotationZ(float rotationZ){
        setRotationZ_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), rotationZ);
    }
    
    private native void setRotationZ_native_float(long __this__nativeId, float rotationZ);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#scale-prop">Qt3DCore::QJoint::setScale(QVector3D)</a></p>
     */
    @io.qt.QtPropertyWriter(name="scale")
    public final void setScale(io.qt.gui.QVector3D scale){
        setScale_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scale));
    }
    
    private native void setScale_native_cref_QVector3D(long __this__nativeId, long scale);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#setToIdentity">Qt3DCore::QJoint::setToIdentity()</a></p>
     */
    public final void setToIdentity(){
        setToIdentity_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void setToIdentity_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#translation-prop">Qt3DCore::QJoint::setTranslation(QVector3D)</a></p>
     */
    @io.qt.QtPropertyWriter(name="translation")
    public final void setTranslation(io.qt.gui.QVector3D translation){
        setTranslation_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(translation));
    }
    
    private native void setTranslation_native_cref_QVector3D(long __this__nativeId, long translation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qjoint.html#translation-prop">Qt3DCore::QJoint::translation()const</a></p>
     */
    @io.qt.QtPropertyReader(name="translation")
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector3D translation(){
        return translation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector3D translation_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QJoint(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QJoint(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QJoint instance, QDeclarativeConstructor constructor);
    
}
