package io.qt.qt3d.core;


/**
 * <p>Base class of scene nodes that can be aggregated by Qt3DCore::QEntity instances as a component</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3dcore-qcomponent.html">Qt3DCore::QComponent</a></p>
 */
public class QComponent extends io.qt.qt3d.core.QNode
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QComponent.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qcomponent.html#addedToEntity">Qt3DCore::QComponent::addedToEntity(Qt3DCore::QEntity*)</a></p>
     */
    public final Signal1<io.qt.qt3d.core.QEntity> addedToEntity = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qcomponent.html#removedFromEntity">Qt3DCore::QComponent::removedFromEntity(Qt3DCore::QEntity*)</a></p>
     */
    public final Signal1<io.qt.qt3d.core.QEntity> removedFromEntity = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qcomponent.html#isShareable-prop">Qt3DCore::QComponent::shareableChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="isShareable")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> shareableChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QComponent(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QComponent() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qcomponent.html#QComponent">Qt3DCore::QComponent::QComponent(Qt3DCore::QNode*)</a></p>
     */
    public QComponent(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QComponent instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qcomponent.html#entities">Qt3DCore::QComponent::entities()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.qt3d.core.QEntity> entities(){
        return entities_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.core.QEntity> entities_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qcomponent.html#isShareable-prop">Qt3DCore::QComponent::isShareable()const</a></p>
     */
    @io.qt.QtPropertyReader(name="isShareable")
    @io.qt.QtUninvokable
    public final boolean isShareable(){
        return isShareable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isShareable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qcomponent.html#isShareable-prop">Qt3DCore::QComponent::setShareable(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="isShareable")
    public final void setShareable(boolean isShareable){
        setShareable_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), isShareable);
    }
    
    private native void setShareable_native_bool(long __this__nativeId, boolean isShareable);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QComponent(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QComponent(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QComponent instance, QDeclarativeConstructor constructor);
    
}
