package io.qt.qt3d.core;


/**
 * <p>The base class of all Qt3D node classes used to build a Qt3D scene</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3dcore-qnode.html">Qt3DCore::QNode</a></p>
 */
public class QNode extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QNode.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qnode.html#enabled-prop">Qt3DCore::QNode::enabledChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="enabled")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> enabledChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qnode.html#nodeDestroyed">Qt3DCore::QNode::nodeDestroyed()</a></p>
     */
    public final Signal0 nodeDestroyed = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qnode.html#parent-prop">Qt3DCore::QNode::parentChanged(QObject*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="parent")
    public final Signal1<io.qt.core.QObject> parentChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QNode(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QNode() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qnode.html#QNode">Qt3DCore::QNode::QNode(Qt3DCore::QNode*)</a></p>
     */
    public QNode(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QNode instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qnode.html#blockNotifications">Qt3DCore::QNode::blockNotifications(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean blockNotifications(boolean block){
        return blockNotifications_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), block);
    }
    
    @io.qt.QtUninvokable
    private native boolean blockNotifications_native_bool(long __this__nativeId, boolean block);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qnode.html#childNodes">Qt3DCore::QNode::childNodes()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.qt3d.core.QNode> childNodes(){
        return childNodes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.core.QNode> childNodes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qnode.html#id">Qt3DCore::QNode::id()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QNodeId id(){
        return id_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.core.QNodeId id_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qnode.html#enabled-prop">Qt3DCore::QNode::isEnabled()const</a></p>
     */
    @io.qt.QtPropertyReader(name="enabled")
    @io.qt.QtUninvokable
    public final boolean isEnabled(){
        return isEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qnode.html#notificationsBlocked">Qt3DCore::QNode::notificationsBlocked()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean notificationsBlocked(){
        return notificationsBlocked_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean notificationsBlocked_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qnode.html#parent-prop">Qt3DCore::QNode::parentNode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="parent")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QNode parentNode(){
        return parentNode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.core.QNode parentNode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qnode.html#enabled-prop">Qt3DCore::QNode::setEnabled(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="enabled")
    public final void setEnabled(boolean isEnabled){
        setEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), isEnabled);
    }
    
    private native void setEnabled_native_bool(long __this__nativeId, boolean isEnabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qnode.html#parent-prop">Qt3DCore::QNode::setParent(Qt3DCore::QNode*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="parent")
    public final void setParent(io.qt.qt3d.core.QNode parent){
        setParent_native_Qt3DCore_QNode_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    private native void setParent_native_Qt3DCore_QNode_ptr(long __this__nativeId, long parent);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QNode(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QNode(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QNode instance, QDeclarativeConstructor constructor);
    
}
