package io.qt.qt3d.core;


/**
 * <p>Encapsulates geometry details</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html">Qt3DCore::QGeometryView</a></p>
 */
public class QGeometryView extends io.qt.qt3d.core.QNode
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QGeometryView.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#PrimitiveType-enum">Qt3DCore::QGeometryView::PrimitiveType</a></p>
     */
    public enum PrimitiveType implements io.qt.QtEnumerator {
        Points(0),
        Lines(1),
        LineLoop(2),
        LineStrip(3),
        Triangles(4),
        TriangleStrip(5),
        TriangleFan(6),
        LinesAdjacency(10),
        TrianglesAdjacency(12),
        LineStripAdjacency(11),
        TriangleStripAdjacency(13),
        Patches(14);

        private PrimitiveType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static PrimitiveType resolve(int value) {
            switch (value) {
            case 0: return Points;
            case 1: return Lines;
            case 2: return LineLoop;
            case 3: return LineStrip;
            case 4: return Triangles;
            case 5: return TriangleStrip;
            case 6: return TriangleFan;
            case 10: return LinesAdjacency;
            case 12: return TrianglesAdjacency;
            case 11: return LineStripAdjacency;
            case 13: return TriangleStripAdjacency;
            case 14: return Patches;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#firstInstance-prop">Qt3DCore::QGeometryView::firstInstanceChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="firstInstance")
    public final Signal1<@io.qt.QtPrimitiveType Integer> firstInstanceChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#firstVertex-prop">Qt3DCore::QGeometryView::firstVertexChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="firstVertex")
    public final Signal1<@io.qt.QtPrimitiveType Integer> firstVertexChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#geometry-prop">Qt3DCore::QGeometryView::geometryChanged(Qt3DCore::QGeometry*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="geometry")
    public final Signal1<io.qt.qt3d.core.QGeometry> geometryChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#indexBufferByteOffset-prop">Qt3DCore::QGeometryView::indexBufferByteOffsetChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="indexBufferByteOffset")
    public final Signal1<@io.qt.QtPrimitiveType Integer> indexBufferByteOffsetChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#indexOffset-prop">Qt3DCore::QGeometryView::indexOffsetChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="indexOffset")
    public final Signal1<@io.qt.QtPrimitiveType Integer> indexOffsetChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#instanceCount-prop">Qt3DCore::QGeometryView::instanceCountChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="instanceCount")
    public final Signal1<@io.qt.QtPrimitiveType Integer> instanceCountChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#primitiveRestartEnabled-prop">Qt3DCore::QGeometryView::primitiveRestartEnabledChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="primitiveRestartEnabled")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> primitiveRestartEnabledChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#primitiveType-prop">Qt3DCore::QGeometryView::primitiveTypeChanged(Qt3DCore::QGeometryView::PrimitiveType)</a></p>
     */
    @io.qt.QtPropertyNotify(name="primitiveType")
    public final Signal1<io.qt.qt3d.core.QGeometryView.PrimitiveType> primitiveTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#restartIndexValue-prop">Qt3DCore::QGeometryView::restartIndexValueChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="restartIndexValue")
    public final Signal1<@io.qt.QtPrimitiveType Integer> restartIndexValueChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#vertexCount-prop">Qt3DCore::QGeometryView::vertexCountChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="vertexCount")
    public final Signal1<@io.qt.QtPrimitiveType Integer> vertexCountChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#verticesPerPatch-prop">Qt3DCore::QGeometryView::verticesPerPatchChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="verticesPerPatch")
    public final Signal1<@io.qt.QtPrimitiveType Integer> verticesPerPatchChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QGeometryView(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QGeometryView() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#QGeometryView">Qt3DCore::QGeometryView::QGeometryView(Qt3DCore::QNode*)</a></p>
     */
    public QGeometryView(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QGeometryView instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#firstInstance-prop">Qt3DCore::QGeometryView::firstInstance()const</a></p>
     */
    @io.qt.QtPropertyReader(name="firstInstance")
    @io.qt.QtUninvokable
    public final int firstInstance(){
        return firstInstance_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int firstInstance_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#firstVertex-prop">Qt3DCore::QGeometryView::firstVertex()const</a></p>
     */
    @io.qt.QtPropertyReader(name="firstVertex")
    @io.qt.QtUninvokable
    public final int firstVertex(){
        return firstVertex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int firstVertex_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#geometry-prop">Qt3DCore::QGeometryView::geometry()const</a></p>
     */
    @io.qt.QtPropertyReader(name="geometry")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QGeometry geometry(){
        return geometry_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.core.QGeometry geometry_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#indexBufferByteOffset-prop">Qt3DCore::QGeometryView::indexBufferByteOffset()const</a></p>
     */
    @io.qt.QtPropertyReader(name="indexBufferByteOffset")
    @io.qt.QtUninvokable
    public final int indexBufferByteOffset(){
        return indexBufferByteOffset_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int indexBufferByteOffset_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#indexOffset-prop">Qt3DCore::QGeometryView::indexOffset()const</a></p>
     */
    @io.qt.QtPropertyReader(name="indexOffset")
    @io.qt.QtUninvokable
    public final int indexOffset(){
        return indexOffset_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int indexOffset_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#instanceCount-prop">Qt3DCore::QGeometryView::instanceCount()const</a></p>
     */
    @io.qt.QtPropertyReader(name="instanceCount")
    @io.qt.QtUninvokable
    public final int instanceCount(){
        return instanceCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int instanceCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#primitiveRestartEnabled-prop">Qt3DCore::QGeometryView::primitiveRestartEnabled()const</a></p>
     */
    @io.qt.QtPropertyReader(name="primitiveRestartEnabled")
    @io.qt.QtUninvokable
    public final boolean primitiveRestartEnabled(){
        return primitiveRestartEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean primitiveRestartEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#primitiveType-prop">Qt3DCore::QGeometryView::primitiveType()const</a></p>
     */
    @io.qt.QtPropertyReader(name="primitiveType")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QGeometryView.PrimitiveType primitiveType(){
        return io.qt.qt3d.core.QGeometryView.PrimitiveType.resolve(primitiveType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int primitiveType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#restartIndexValue-prop">Qt3DCore::QGeometryView::restartIndexValue()const</a></p>
     */
    @io.qt.QtPropertyReader(name="restartIndexValue")
    @io.qt.QtUninvokable
    public final int restartIndexValue(){
        return restartIndexValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int restartIndexValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#firstInstance-prop">Qt3DCore::QGeometryView::setFirstInstance(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="firstInstance")
    public final void setFirstInstance(int firstInstance){
        setFirstInstance_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), firstInstance);
    }
    
    private native void setFirstInstance_native_int(long __this__nativeId, int firstInstance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#firstVertex-prop">Qt3DCore::QGeometryView::setFirstVertex(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="firstVertex")
    public final void setFirstVertex(int firstVertex){
        setFirstVertex_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), firstVertex);
    }
    
    private native void setFirstVertex_native_int(long __this__nativeId, int firstVertex);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#geometry-prop">Qt3DCore::QGeometryView::setGeometry(Qt3DCore::QGeometry*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="geometry")
    public final void setGeometry(io.qt.qt3d.core.QGeometry geometry){
        setGeometry_native_Qt3DCore_QGeometry_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(geometry));
    }
    
    private native void setGeometry_native_Qt3DCore_QGeometry_ptr(long __this__nativeId, long geometry);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#indexBufferByteOffset-prop">Qt3DCore::QGeometryView::setIndexBufferByteOffset(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="indexBufferByteOffset")
    public final void setIndexBufferByteOffset(int offset){
        setIndexBufferByteOffset_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), offset);
    }
    
    private native void setIndexBufferByteOffset_native_int(long __this__nativeId, int offset);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#indexOffset-prop">Qt3DCore::QGeometryView::setIndexOffset(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="indexOffset")
    public final void setIndexOffset(int indexOffset){
        setIndexOffset_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), indexOffset);
    }
    
    private native void setIndexOffset_native_int(long __this__nativeId, int indexOffset);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#instanceCount-prop">Qt3DCore::QGeometryView::setInstanceCount(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="instanceCount")
    public final void setInstanceCount(int instanceCount){
        setInstanceCount_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), instanceCount);
    }
    
    private native void setInstanceCount_native_int(long __this__nativeId, int instanceCount);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#primitiveRestartEnabled-prop">Qt3DCore::QGeometryView::setPrimitiveRestartEnabled(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="primitiveRestartEnabled")
    public final void setPrimitiveRestartEnabled(boolean enabled){
        setPrimitiveRestartEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    private native void setPrimitiveRestartEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#primitiveType-prop">Qt3DCore::QGeometryView::setPrimitiveType(Qt3DCore::QGeometryView::PrimitiveType)</a></p>
     */
    @io.qt.QtPropertyWriter(name="primitiveType")
    public final void setPrimitiveType(io.qt.qt3d.core.QGeometryView.PrimitiveType primitiveType){
        setPrimitiveType_native_Qt3DCore_QGeometryView_PrimitiveType(QtJambi_LibraryUtilities.internal.nativeId(this), primitiveType.value());
    }
    
    private native void setPrimitiveType_native_Qt3DCore_QGeometryView_PrimitiveType(long __this__nativeId, int primitiveType);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#restartIndexValue-prop">Qt3DCore::QGeometryView::setRestartIndexValue(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="restartIndexValue")
    public final void setRestartIndexValue(int index){
        setRestartIndexValue_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    private native void setRestartIndexValue_native_int(long __this__nativeId, int index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#vertexCount-prop">Qt3DCore::QGeometryView::setVertexCount(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="vertexCount")
    public final void setVertexCount(int vertexCount){
        setVertexCount_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), vertexCount);
    }
    
    private native void setVertexCount_native_int(long __this__nativeId, int vertexCount);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#verticesPerPatch-prop">Qt3DCore::QGeometryView::setVerticesPerPatch(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="verticesPerPatch")
    public final void setVerticesPerPatch(int verticesPerPatch){
        setVerticesPerPatch_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), verticesPerPatch);
    }
    
    private native void setVerticesPerPatch_native_int(long __this__nativeId, int verticesPerPatch);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#vertexCount-prop">Qt3DCore::QGeometryView::vertexCount()const</a></p>
     */
    @io.qt.QtPropertyReader(name="vertexCount")
    @io.qt.QtUninvokable
    public final int vertexCount(){
        return vertexCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int vertexCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qgeometryview.html#verticesPerPatch-prop">Qt3DCore::QGeometryView::verticesPerPatch()const</a></p>
     */
    @io.qt.QtPropertyReader(name="verticesPerPatch")
    @io.qt.QtUninvokable
    public final int verticesPerPatch(){
        return verticesPerPatch_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int verticesPerPatch_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QGeometryView(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QGeometryView(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QGeometryView instance, QDeclarativeConstructor constructor);
    
}
