package io.qt.qt3d.core;


/**
 * <p>Defines an attribute and how data should be read from a QBuffer</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html">Qt3DCore::QAttribute</a></p>
 */
public class QAttribute extends io.qt.qt3d.core.QNode
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAttribute.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#AttributeType-enum">Qt3DCore::QAttribute::AttributeType</a></p>
     */
    public enum AttributeType implements io.qt.QtEnumerator {
        VertexAttribute(0),
        IndexAttribute(1),
        DrawIndirectAttribute(2);

        private AttributeType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static AttributeType resolve(int value) {
            switch (value) {
            case 0: return VertexAttribute;
            case 1: return IndexAttribute;
            case 2: return DrawIndirectAttribute;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#VertexBaseType-enum">Qt3DCore::QAttribute::VertexBaseType</a></p>
     */
    public enum VertexBaseType implements io.qt.QtEnumerator {
        Byte(0),
        UnsignedByte(1),
        Short(2),
        UnsignedShort(3),
        Int(4),
        UnsignedInt(5),
        HalfFloat(6),
        Float(7),
        Double(8);

        private VertexBaseType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static VertexBaseType resolve(int value) {
            switch (value) {
            case 0: return Byte;
            case 1: return UnsignedByte;
            case 2: return Short;
            case 3: return UnsignedShort;
            case 4: return Int;
            case 5: return UnsignedInt;
            case 6: return HalfFloat;
            case 7: return Float;
            case 8: return Double;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#attributeType-prop">Qt3DCore::QAttribute::attributeTypeChanged(Qt3DCore::QAttribute::AttributeType)</a></p>
     */
    @io.qt.QtPropertyNotify(name="attributeType")
    public final Signal1<io.qt.qt3d.core.QAttribute.AttributeType> attributeTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#buffer-prop">Qt3DCore::QAttribute::bufferChanged(QBuffer*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="buffer")
    public final Signal1<io.qt.qt3d.core.QBuffer> bufferChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#byteOffset-prop">Qt3DCore::QAttribute::byteOffsetChanged(uint)</a></p>
     */
    @io.qt.QtPropertyNotify(name="byteOffset")
    public final Signal1<@io.qt.QtPrimitiveType Integer> byteOffsetChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#byteStride-prop">Qt3DCore::QAttribute::byteStrideChanged(uint)</a></p>
     */
    @io.qt.QtPropertyNotify(name="byteStride")
    public final Signal1<@io.qt.QtPrimitiveType Integer> byteStrideChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#count-prop">Qt3DCore::QAttribute::countChanged(uint)</a></p>
     */
    @io.qt.QtPropertyNotify(name="count")
    public final Signal1<@io.qt.QtPrimitiveType Integer> countChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#dataSizeChanged">Qt3DCore::QAttribute::dataSizeChanged(uint)</a></p>
     */
    public final Signal1<@io.qt.QtPrimitiveType Integer> dataSizeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#dataTypeChanged">Qt3DCore::QAttribute::dataTypeChanged(Qt3DCore::QAttribute::VertexBaseType)</a></p>
     */
    public final Signal1<io.qt.qt3d.core.QAttribute.VertexBaseType> dataTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#divisor-prop">Qt3DCore::QAttribute::divisorChanged(uint)</a></p>
     */
    @io.qt.QtPropertyNotify(name="divisor")
    public final Signal1<@io.qt.QtPrimitiveType Integer> divisorChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#name-prop">Qt3DCore::QAttribute::nameChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="name")
    public final Signal1<java.lang.String> nameChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#vertexBaseType-prop">Qt3DCore::QAttribute::vertexBaseTypeChanged(Qt3DCore::QAttribute::VertexBaseType)</a></p>
     */
    @io.qt.QtPropertyNotify(name="vertexBaseType")
    public final Signal1<io.qt.qt3d.core.QAttribute.VertexBaseType> vertexBaseTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#vertexSize-prop">Qt3DCore::QAttribute::vertexSizeChanged(uint)</a></p>
     */
    @io.qt.QtPropertyNotify(name="vertexSize")
    public final Signal1<@io.qt.QtPrimitiveType Integer> vertexSizeChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QAttribute(io.qt.qt3d.core.QBuffer, io.qt.qt3d.core.QAttribute.VertexBaseType, int, int, int, int, io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAttribute(io.qt.qt3d.core.QBuffer buf, io.qt.qt3d.core.QAttribute.VertexBaseType vertexBaseType, int vertexSize, int count, int offset, int stride) {
        this(buf, vertexBaseType, vertexSize, count, offset, stride, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAttribute(io.qt.qt3d.core.QBuffer, io.qt.qt3d.core.QAttribute.VertexBaseType, int, int, int, int, io.qt.qt3d.core.QNode)}</p>
     * <p>with: </p><ul>
     * <li><code>stride = 0</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QAttribute(io.qt.qt3d.core.QBuffer buf, io.qt.qt3d.core.QAttribute.VertexBaseType vertexBaseType, int vertexSize, int count, int offset) {
        this(buf, vertexBaseType, vertexSize, count, offset, (int)0, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAttribute(io.qt.qt3d.core.QBuffer, io.qt.qt3d.core.QAttribute.VertexBaseType, int, int, int, int, io.qt.qt3d.core.QNode)}</p>
     * <p>with: </p><ul>
     * <li><code>offset = 0</code></li>
     * <li><code>stride = 0</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QAttribute(io.qt.qt3d.core.QBuffer buf, io.qt.qt3d.core.QAttribute.VertexBaseType vertexBaseType, int vertexSize, int count) {
        this(buf, vertexBaseType, vertexSize, count, (int)0, (int)0, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#QAttribute-1">Qt3DCore::QAttribute::QAttribute(QBuffer*,Qt3DCore::QAttribute::VertexBaseType,uint,uint,uint,uint,Qt3DCore::QNode*)</a></p>
     */
    public QAttribute(io.qt.qt3d.core.QBuffer buf, io.qt.qt3d.core.QAttribute.VertexBaseType vertexBaseType, int vertexSize, int count, int offset, int stride, io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, buf, vertexBaseType, vertexSize, count, offset, stride, parent);
    }
    
    private native static void initialize_native(QAttribute instance, io.qt.qt3d.core.QBuffer buf, io.qt.qt3d.core.QAttribute.VertexBaseType vertexBaseType, int vertexSize, int count, int offset, int stride, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Overloaded constructor for {@link #QAttribute(io.qt.qt3d.core.QBuffer, java.lang.String, io.qt.qt3d.core.QAttribute.VertexBaseType, int, int, int, int, io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAttribute(io.qt.qt3d.core.QBuffer buf, java.lang.String name, io.qt.qt3d.core.QAttribute.VertexBaseType vertexBaseType, int vertexSize, int count, int offset, int stride) {
        this(buf, name, vertexBaseType, vertexSize, count, offset, stride, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAttribute(io.qt.qt3d.core.QBuffer, java.lang.String, io.qt.qt3d.core.QAttribute.VertexBaseType, int, int, int, int, io.qt.qt3d.core.QNode)}</p>
     * <p>with: </p><ul>
     * <li><code>stride = 0</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QAttribute(io.qt.qt3d.core.QBuffer buf, java.lang.String name, io.qt.qt3d.core.QAttribute.VertexBaseType vertexBaseType, int vertexSize, int count, int offset) {
        this(buf, name, vertexBaseType, vertexSize, count, offset, (int)0, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAttribute(io.qt.qt3d.core.QBuffer, java.lang.String, io.qt.qt3d.core.QAttribute.VertexBaseType, int, int, int, int, io.qt.qt3d.core.QNode)}</p>
     * <p>with: </p><ul>
     * <li><code>offset = 0</code></li>
     * <li><code>stride = 0</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QAttribute(io.qt.qt3d.core.QBuffer buf, java.lang.String name, io.qt.qt3d.core.QAttribute.VertexBaseType vertexBaseType, int vertexSize, int count) {
        this(buf, name, vertexBaseType, vertexSize, count, (int)0, (int)0, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#QAttribute-2">Qt3DCore::QAttribute::QAttribute(QBuffer*,QString,Qt3DCore::QAttribute::VertexBaseType,uint,uint,uint,uint,Qt3DCore::QNode*)</a></p>
     */
    public QAttribute(io.qt.qt3d.core.QBuffer buf, java.lang.String name, io.qt.qt3d.core.QAttribute.VertexBaseType vertexBaseType, int vertexSize, int count, int offset, int stride, io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, buf, name, vertexBaseType, vertexSize, count, offset, stride, parent);
    }
    
    private native static void initialize_native(QAttribute instance, io.qt.qt3d.core.QBuffer buf, java.lang.String name, io.qt.qt3d.core.QAttribute.VertexBaseType vertexBaseType, int vertexSize, int count, int offset, int stride, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Overloaded constructor for {@link #QAttribute(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAttribute() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#QAttribute">Qt3DCore::QAttribute::QAttribute(Qt3DCore::QNode*)</a></p>
     */
    public QAttribute(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAttribute instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#attributeType-prop">Qt3DCore::QAttribute::attributeType()const</a></p>
     */
    @io.qt.QtPropertyReader(name="attributeType")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QAttribute.AttributeType attributeType(){
        return io.qt.qt3d.core.QAttribute.AttributeType.resolve(attributeType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int attributeType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#buffer-prop">Qt3DCore::QAttribute::buffer()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buffer")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QBuffer buffer(){
        return buffer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.core.QBuffer buffer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#byteOffset-prop">Qt3DCore::QAttribute::byteOffset()const</a></p>
     */
    @io.qt.QtPropertyReader(name="byteOffset")
    @io.qt.QtUninvokable
    public final int byteOffset(){
        return byteOffset_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int byteOffset_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#byteStride-prop">Qt3DCore::QAttribute::byteStride()const</a></p>
     */
    @io.qt.QtPropertyReader(name="byteStride")
    @io.qt.QtUninvokable
    public final int byteStride(){
        return byteStride_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int byteStride_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#count-prop">Qt3DCore::QAttribute::count()const</a></p>
     */
    @io.qt.QtPropertyReader(name="count")
    @io.qt.QtUninvokable
    public final int count(){
        return count_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int count_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#divisor-prop">Qt3DCore::QAttribute::divisor()const</a></p>
     */
    @io.qt.QtPropertyReader(name="divisor")
    @io.qt.QtUninvokable
    public final int divisor(){
        return divisor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int divisor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#name-prop">Qt3DCore::QAttribute::name()const</a></p>
     */
    @io.qt.QtPropertyReader(name="name")
    @io.qt.QtUninvokable
    public final java.lang.String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#attributeType-prop">Qt3DCore::QAttribute::setAttributeType(Qt3DCore::QAttribute::AttributeType)</a></p>
     */
    @io.qt.QtPropertyWriter(name="attributeType")
    public final void setAttributeType(io.qt.qt3d.core.QAttribute.AttributeType attributeType){
        setAttributeType_native_Qt3DCore_QAttribute_AttributeType(QtJambi_LibraryUtilities.internal.nativeId(this), attributeType.value());
    }
    
    private native void setAttributeType_native_Qt3DCore_QAttribute_AttributeType(long __this__nativeId, int attributeType);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#buffer-prop">Qt3DCore::QAttribute::setBuffer(QBuffer*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="buffer")
    public final void setBuffer(io.qt.qt3d.core.QBuffer buffer){
        setBuffer_native_Qt3DCore_QBuffer_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(buffer));
    }
    
    private native void setBuffer_native_Qt3DCore_QBuffer_ptr(long __this__nativeId, long buffer);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#byteOffset-prop">Qt3DCore::QAttribute::setByteOffset(uint)</a></p>
     */
    @io.qt.QtPropertyWriter(name="byteOffset")
    public final void setByteOffset(int byteOffset){
        setByteOffset_native_uint(QtJambi_LibraryUtilities.internal.nativeId(this), byteOffset);
    }
    
    private native void setByteOffset_native_uint(long __this__nativeId, int byteOffset);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#byteStride-prop">Qt3DCore::QAttribute::setByteStride(uint)</a></p>
     */
    @io.qt.QtPropertyWriter(name="byteStride")
    public final void setByteStride(int byteStride){
        setByteStride_native_uint(QtJambi_LibraryUtilities.internal.nativeId(this), byteStride);
    }
    
    private native void setByteStride_native_uint(long __this__nativeId, int byteStride);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#count-prop">Qt3DCore::QAttribute::setCount(uint)</a></p>
     */
    @io.qt.QtPropertyWriter(name="count")
    public final void setCount(int count){
        setCount_native_uint(QtJambi_LibraryUtilities.internal.nativeId(this), count);
    }
    
    private native void setCount_native_uint(long __this__nativeId, int count);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#divisor-prop">Qt3DCore::QAttribute::setDivisor(uint)</a></p>
     */
    @io.qt.QtPropertyWriter(name="divisor")
    public final void setDivisor(int divisor){
        setDivisor_native_uint(QtJambi_LibraryUtilities.internal.nativeId(this), divisor);
    }
    
    private native void setDivisor_native_uint(long __this__nativeId, int divisor);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#name-prop">Qt3DCore::QAttribute::setName(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="name")
    public final void setName(java.lang.String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#vertexBaseType-prop">Qt3DCore::QAttribute::setVertexBaseType(Qt3DCore::QAttribute::VertexBaseType)</a></p>
     */
    @io.qt.QtPropertyWriter(name="vertexBaseType")
    public final void setVertexBaseType(io.qt.qt3d.core.QAttribute.VertexBaseType type){
        setVertexBaseType_native_Qt3DCore_QAttribute_VertexBaseType(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    private native void setVertexBaseType_native_Qt3DCore_QAttribute_VertexBaseType(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#vertexSize-prop">Qt3DCore::QAttribute::setVertexSize(uint)</a></p>
     */
    @io.qt.QtPropertyWriter(name="vertexSize")
    public final void setVertexSize(int size){
        setVertexSize_native_uint(QtJambi_LibraryUtilities.internal.nativeId(this), size);
    }
    
    private native void setVertexSize_native_uint(long __this__nativeId, int size);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#vertexBaseType-prop">Qt3DCore::QAttribute::vertexBaseType()const</a></p>
     */
    @io.qt.QtPropertyReader(name="vertexBaseType")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QAttribute.VertexBaseType vertexBaseType(){
        return io.qt.qt3d.core.QAttribute.VertexBaseType.resolve(vertexBaseType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int vertexBaseType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#vertexSize-prop">Qt3DCore::QAttribute::vertexSize()const</a></p>
     */
    @io.qt.QtPropertyReader(name="vertexSize")
    @io.qt.QtUninvokable
    public final int vertexSize(){
        return vertexSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int vertexSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>QAttribute::defaultColorAttributeName Returns the name of the default color attribute</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultColorAttributeName">Qt3DCore::QAttribute::defaultColorAttributeName()</a></p>
     */
    @io.qt.QtPropertyReader(name="defaultColorAttributeName")
    @io.qt.QtPropertyConstant
    public native static java.lang.String defaultColorAttributeName();
    
    /**
     * <p>QAttribute::defaultJointIndicesAttributeName Returns the name of the default joint indices attribute</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultJointIndicesAttributeName">Qt3DCore::QAttribute::defaultJointIndicesAttributeName()</a></p>
     */
    @io.qt.QtPropertyReader(name="defaultJointIndicesAttributeName")
    @io.qt.QtPropertyConstant
    public native static java.lang.String defaultJointIndicesAttributeName();
    
    /**
     * <p>QAttribute::defaultJointIndicesAttributeName Returns the name of the default joint weights attribute</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultJointWeightsAttributeName">Qt3DCore::QAttribute::defaultJointWeightsAttributeName()</a></p>
     */
    @io.qt.QtPropertyReader(name="defaultJointWeightsAttributeName")
    @io.qt.QtPropertyConstant
    public native static java.lang.String defaultJointWeightsAttributeName();
    
    /**
     * <p>QAttribute::defaultNormalAttributeName Returns the name of the default normal attribute</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultNormalAttributeName">Qt3DCore::QAttribute::defaultNormalAttributeName()</a></p>
     */
    @io.qt.QtPropertyReader(name="defaultNormalAttributeName")
    @io.qt.QtPropertyConstant
    public native static java.lang.String defaultNormalAttributeName();
    
    /**
     * <p>QAttribute::defaultPositionAttributeName Returns the name of the default position attribute</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultPositionAttributeName">Qt3DCore::QAttribute::defaultPositionAttributeName()</a></p>
     */
    @io.qt.QtPropertyReader(name="defaultPositionAttributeName")
    @io.qt.QtPropertyConstant
    public native static java.lang.String defaultPositionAttributeName();
    
    /**
     * <p>QAttribute::defaultTangentAttributeName Returns the name of the default tangent attribute</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultTangentAttributeName">Qt3DCore::QAttribute::defaultTangentAttributeName()</a></p>
     */
    @io.qt.QtPropertyReader(name="defaultTangentAttributeName")
    @io.qt.QtPropertyConstant
    public native static java.lang.String defaultTangentAttributeName();
    
    /**
     * <p>QAttribute::defaultTextureCoordinate1AttributeName Returns the name of the default attribute for the second layer of texture coordinates</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultTextureCoordinate1AttributeName">Qt3DCore::QAttribute::defaultTextureCoordinate1AttributeName()</a></p>
     */
    @io.qt.QtPropertyReader(name="defaultTextureCoordinate1AttributeName")
    @io.qt.QtPropertyConstant
    public native static java.lang.String defaultTextureCoordinate1AttributeName();
    
    /**
     * <p>QAttribute::defaultTextureCoordinate2AttributeName Returns the name of the default attribute for the third layer of texture coordinates</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultTextureCoordinate2AttributeName">Qt3DCore::QAttribute::defaultTextureCoordinate2AttributeName()</a></p>
     */
    @io.qt.QtPropertyReader(name="defaultTextureCoordinate2AttributeName")
    @io.qt.QtPropertyConstant
    public native static java.lang.String defaultTextureCoordinate2AttributeName();
    
    /**
     * <p>QAttribute::defaultTextureCoordinateAttributeName Returns the name of the default texture coordinate attribute</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qattribute.html#defaultTextureCoordinateAttributeName">Qt3DCore::QAttribute::defaultTextureCoordinateAttributeName()</a></p>
     */
    @io.qt.QtPropertyReader(name="defaultTextureCoordinateAttributeName")
    @io.qt.QtPropertyConstant
    public native static java.lang.String defaultTextureCoordinateAttributeName();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAttribute(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QAttribute(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QAttribute instance, QDeclarativeConstructor constructor);
    
}
