package io.qt.qt3d.core;


/**
 * <p>Used to calculate skinning transform matrices and set them on shaders</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3dcore-qarmature.html">Qt3DCore::QArmature</a></p>
 */
public class QArmature extends io.qt.qt3d.core.QComponent
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QArmature.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qarmature.html#skeleton-prop">Qt3DCore::QArmature::skeletonChanged(Qt3DCore::QAbstractSkeleton*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="skeleton")
    public final Signal1<io.qt.qt3d.core.QAbstractSkeleton> skeletonChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QArmature(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QArmature() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qarmature.html#QArmature">Qt3DCore::QArmature::QArmature(Qt3DCore::QNode*)</a></p>
     */
    public QArmature(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QArmature instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qarmature.html#skeleton-prop">Qt3DCore::QArmature::setSkeleton(Qt3DCore::QAbstractSkeleton*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="skeleton")
    public final void setSkeleton(io.qt.qt3d.core.QAbstractSkeleton skeleton){
        setSkeleton_native_Qt3DCore_QAbstractSkeleton_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(skeleton));
    }
    
    private native void setSkeleton_native_Qt3DCore_QAbstractSkeleton_ptr(long __this__nativeId, long skeleton);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qarmature.html#skeleton-prop">Qt3DCore::QArmature::skeleton()const</a></p>
     */
    @io.qt.QtPropertyReader(name="skeleton")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QAbstractSkeleton skeleton(){
        return skeleton_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.core.QAbstractSkeleton skeleton_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QArmature(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QArmature(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QArmature instance, QDeclarativeConstructor constructor);
    
}
