package io.qt.qt3d.core;


/**
 * <p>Provides a data store for raw data to later be used as vertices or uniforms</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html">Qt3DCore::QBuffer</a></p>
 */
public class QBuffer extends io.qt.qt3d.core.QNode
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QBuffer.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#AccessType-enum">Qt3DCore::QBuffer::AccessType</a></p>
     */
    public enum AccessType implements io.qt.QtEnumerator {
        Write(1),
        Read(2),
        ReadWrite(3);

        private AccessType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static AccessType resolve(int value) {
            switch (value) {
            case 1: return Write;
            case 2: return Read;
            case 3: return ReadWrite;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#UsageType-enum">Qt3DCore::QBuffer::UsageType</a></p>
     */
    public enum UsageType implements io.qt.QtEnumerator {
        StreamDraw(35040),
        StreamRead(35041),
        StreamCopy(35042),
        StaticDraw(35044),
        StaticRead(35045),
        StaticCopy(35046),
        DynamicDraw(35048),
        DynamicRead(35049),
        DynamicCopy(35050);

        private UsageType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static UsageType resolve(int value) {
            switch (value) {
            case 35040: return StreamDraw;
            case 35041: return StreamRead;
            case 35042: return StreamCopy;
            case 35044: return StaticDraw;
            case 35045: return StaticRead;
            case 35046: return StaticCopy;
            case 35048: return DynamicDraw;
            case 35049: return DynamicRead;
            case 35050: return DynamicCopy;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#accessType-prop">Qt3DCore::QBuffer::accessTypeChanged(Qt3DCore::QBuffer::AccessType)</a></p>
     */
    @io.qt.QtPropertyNotify(name="accessType")
    public final Signal1<io.qt.qt3d.core.QBuffer.AccessType> accessTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#dataAvailable">Qt3DCore::QBuffer::dataAvailable()</a></p>
     */
    public final Signal0 dataAvailable = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#dataChanged">Qt3DCore::QBuffer::dataChanged(QByteArray)</a></p>
     */
    public final Signal1<io.qt.core.QByteArray> dataChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#usage-prop">Qt3DCore::QBuffer::usageChanged(Qt3DCore::QBuffer::UsageType)</a></p>
     */
    @io.qt.QtPropertyNotify(name="usage")
    public final Signal1<io.qt.qt3d.core.QBuffer.UsageType> usageChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QBuffer(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QBuffer() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#QBuffer">Qt3DCore::QBuffer::QBuffer(Qt3DCore::QNode*)</a></p>
     */
    public QBuffer(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QBuffer instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#accessType-prop">Qt3DCore::QBuffer::accessType()const</a></p>
     */
    @io.qt.QtPropertyReader(name="accessType")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QBuffer.AccessType accessType(){
        return io.qt.qt3d.core.QBuffer.AccessType.resolve(accessType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int accessType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#data">Qt3DCore::QBuffer::data()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray data(){
        return data_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray data_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#accessType-prop">Qt3DCore::QBuffer::setAccessType(Qt3DCore::QBuffer::AccessType)</a></p>
     */
    @io.qt.QtPropertyWriter(name="accessType")
    public final void setAccessType(io.qt.qt3d.core.QBuffer.AccessType access){
        setAccessType_native_Qt3DCore_QBuffer_AccessType(QtJambi_LibraryUtilities.internal.nativeId(this), access.value());
    }
    
    private native void setAccessType_native_Qt3DCore_QBuffer_AccessType(long __this__nativeId, int access);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#setData">Qt3DCore::QBuffer::setData(QByteArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setData(io.qt.core.QByteArray bytes){
        setData_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(bytes));
    }
    
    @io.qt.QtUninvokable
    private native void setData_native_cref_QByteArray(long __this__nativeId, long bytes);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#usage-prop">Qt3DCore::QBuffer::setUsage(Qt3DCore::QBuffer::UsageType)</a></p>
     */
    @io.qt.QtPropertyWriter(name="usage")
    public final void setUsage(io.qt.qt3d.core.QBuffer.UsageType usage){
        setUsage_native_Qt3DCore_QBuffer_UsageType(QtJambi_LibraryUtilities.internal.nativeId(this), usage.value());
    }
    
    private native void setUsage_native_Qt3DCore_QBuffer_UsageType(long __this__nativeId, int usage);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#updateData">Qt3DCore::QBuffer::updateData(int,QByteArray)</a></p>
     */
    public final void updateData(int offset, io.qt.core.QByteArray bytes){
        updateData_native_int_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), offset, QtJambi_LibraryUtilities.internal.checkedNativeId(bytes));
    }
    
    private native void updateData_native_int_cref_QByteArray(long __this__nativeId, int offset, long bytes);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qbuffer.html#usage-prop">Qt3DCore::QBuffer::usage()const</a></p>
     */
    @io.qt.QtPropertyReader(name="usage")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QBuffer.UsageType usage(){
        return io.qt.qt3d.core.QBuffer.UsageType.resolve(usage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int usage_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QBuffer(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QBuffer(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QBuffer instance, QDeclarativeConstructor constructor);
    
}
