package io.qt.qt3d.core;


/**
 * <p>Contains classes that are the foundation for Qt 3D simulation framework, as well as classes that provide the ability to render using the Qt 3D framework</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3dcore.html">Qt3DCore</a></p>
 */
public final class Qt3DCore
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private Qt3DCore() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace Qt3DCore."); }
    
    
    /**
     * <p>Overloaded function for {@link #qHash(io.qt.qt3d.core.QNodeId, long)}
     *  with <code>seed = 0</code>.</p>
     */
    public static long qHash(io.qt.qt3d.core.QNodeId id) {
        return qHash(id, (long)0);
    }
    
    public static long qHash(io.qt.qt3d.core.QNodeId id, long seed){
        return qHash_native_Qt3DCore_QNodeId_size_t(QtJambi_LibraryUtilities.internal.checkedNativeId(id), seed);
    }
    
    private native static long qHash_native_Qt3DCore_QNodeId_size_t(long id, long seed);
    
    public static io.qt.qt3d.core.QNodeId qIdForNode(io.qt.qt3d.core.QNode node){
        return qIdForNode_native_Qt3DCore_QNode_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(node));
    }
    
    private native static io.qt.qt3d.core.QNodeId qIdForNode_native_Qt3DCore_QNode_ptr(long node);
    
}
