package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Used to load a skeleton of joints from file</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3dcore-qskeletonloader.html">Qt3DCore::QSkeletonLoader</a></p>
 */
public class QSkeletonLoader extends io.qt.qt3d.core.QAbstractSkeleton
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSkeletonLoader.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3dcore-qskeletonloader.html#Status-enum">Qt3DCore::QSkeletonLoader::Status</a></p>
     */
    public enum Status implements QtEnumerator {
        NotReady(0),
        Ready(1),
        Error(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Status(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Status resolve(int value) {
            switch (value) {
            case 0: return NotReady;
            case 1: return Ready;
            case 2: return Error;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qskeletonloader.html#createJointsEnabled-prop">Qt3DCore::QSkeletonLoader::createJointsEnabledChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="createJointsEnabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> createJointsEnabledChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qskeletonloader.html#rootJoint-prop">Qt3DCore::QSkeletonLoader::rootJointChanged(Qt3DCore::QJoint*)</a></p>
     */
    @QtPropertyNotify(name="rootJoint")
    public final @NonNull Signal1<io.qt.qt3d.core.@Nullable QJoint> rootJointChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qskeletonloader.html#source-prop">Qt3DCore::QSkeletonLoader::sourceChanged(QUrl)</a></p>
     */
    @QtPropertyNotify(name="source")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> sourceChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qskeletonloader.html#status-prop">Qt3DCore::QSkeletonLoader::statusChanged(Qt3DCore::QSkeletonLoader::Status)</a></p>
     */
    @QtPropertyNotify(name="status")
    public final @NonNull Signal1<io.qt.qt3d.core.QSkeletonLoader.@NonNull Status> statusChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QSkeletonLoader() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qskeletonloader.html#QSkeletonLoader">Qt3DCore::QSkeletonLoader::QSkeletonLoader(Qt3DCore::QNode*)</a></p>
     */
    public QSkeletonLoader(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSkeletonLoader instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QUrl, io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QSkeletonLoader(io.qt.core.@NonNull QUrl source) {
        this(source, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qskeletonloader.html#QSkeletonLoader-1">Qt3DCore::QSkeletonLoader::QSkeletonLoader(QUrl,Qt3DCore::QNode*)</a></p>
     */
    public QSkeletonLoader(io.qt.core.@NonNull QUrl source, io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, source, parent);
    }
    
    private native static void initialize_native(QSkeletonLoader instance, io.qt.core.QUrl source, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isCreateJointsEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getCreateJointsEnabled() {
        return isCreateJointsEnabled();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qskeletonloader.html#isCreateJointsEnabled">Qt3DCore::QSkeletonLoader::isCreateJointsEnabled()const</a></p>
     */
    @QtPropertyReader(name="createJointsEnabled")
    @QtUninvokable
    public final boolean isCreateJointsEnabled(){
        return isCreateJointsEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isCreateJointsEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rootJoint()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QJoint getRootJoint() {
        return rootJoint();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qskeletonloader.html#rootJoint">Qt3DCore::QSkeletonLoader::rootJoint()const</a></p>
     */
    @QtPropertyReader(name="rootJoint")
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QJoint rootJoint(){
        return rootJoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QJoint rootJoint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qskeletonloader.html#createJointsEnabled-prop">Qt3DCore::QSkeletonLoader::setCreateJointsEnabled(bool)</a></p>
     */
    @QtPropertyWriter(name="createJointsEnabled")
    public final void setCreateJointsEnabled(boolean enabled){
        setCreateJointsEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    private native void setCreateJointsEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qskeletonloader.html#source-prop">Qt3DCore::QSkeletonLoader::setSource(QUrl)</a></p>
     */
    @QtPropertyWriter(name="source")
    public final void setSource(io.qt.core.@NonNull QUrl source){
        setSource_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    private native void setSource_native_cref_QUrl(long __this__nativeId, long source);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #source()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getSource() {
        return source();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qskeletonloader.html#source-prop">Qt3DCore::QSkeletonLoader::source()const</a></p>
     */
    @QtPropertyReader(name="source")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl source(){
        return source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl source_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #status()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.core.QSkeletonLoader.@NonNull Status getStatus() {
        return status();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qskeletonloader.html#status-prop">Qt3DCore::QSkeletonLoader::status()const</a></p>
     */
    @QtPropertyReader(name="status")
    @QtUninvokable
    public final io.qt.qt3d.core.QSkeletonLoader.@NonNull Status status(){
        return io.qt.qt3d.core.QSkeletonLoader.Status.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QSkeletonLoader(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QSkeletonLoader(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QSkeletonLoader instance, QDeclarativeConstructor constructor);
    
}
