package io.qt.qt3d.core;


/**
 * <p>Base class for all Qt3D backend nodes</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3dcore-qbackendnode.html">Qt3DCore::QBackendNode</a></p>
 */
public class QBackendNode extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3dcore-qbackendnode.html#Mode-enum">Qt3DCore::QBackendNode::Mode</a></p>
     */
    public enum Mode implements io.qt.QtEnumerator {
        ReadOnly(0),
        ReadWrite(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Mode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Mode resolve(int value) {
            switch (value) {
            case 0: return ReadOnly;
            case 1: return ReadWrite;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #QBackendNode(io.qt.qt3d.core.QBackendNode.Mode)}
     *  with <code>mode = io.qt.qt3d.core.QBackendNode.Mode.ReadOnly</code>.</p>
     */
    public QBackendNode() {
        this(io.qt.qt3d.core.QBackendNode.Mode.ReadOnly);
    }
    
    public QBackendNode(io.qt.qt3d.core.QBackendNode.Mode mode){
        super((QPrivateConstructor)null);
        initialize_native(this, mode);
    }
    
    private native static void initialize_native(QBackendNode instance, io.qt.qt3d.core.QBackendNode.Mode mode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qbackendnode.html#isEnabled">Qt3DCore::QBackendNode::isEnabled()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isEnabled(){
        return isEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qbackendnode.html#mode">Qt3DCore::QBackendNode::mode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QBackendNode.Mode mode(){
        return io.qt.qt3d.core.QBackendNode.Mode.resolve(mode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int mode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qbackendnode.html#peerId">Qt3DCore::QBackendNode::peerId()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QNodeId peerId(){
        return peerId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.core.QNodeId peerId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qbackendnode.html#setEnabled">Qt3DCore::QBackendNode::setEnabled(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setEnabled(boolean enabled){
        setEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @io.qt.QtUninvokable
    private native void setEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>QBackendNode::syncFromFrontEnd frontEnd firstTime</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qbackendnode.html#syncFromFrontEnd">Qt3DCore::QBackendNode::syncFromFrontEnd(const Qt3DCore::QNode*,bool)</a></p>
     */
    @io.qt.QtUninvokable
    public void syncFromFrontEnd(io.qt.qt3d.core.QNode frontEnd, boolean firstTime){
        syncFromFrontEnd_native_const_Qt3DCore_QNode_ptr_bool(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(frontEnd), firstTime);
    }
    
    @io.qt.QtUninvokable
    private native void syncFromFrontEnd_native_const_Qt3DCore_QNode_ptr_bool(long __this__nativeId, long frontEnd, boolean firstTime);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QBackendNode(QPrivateConstructor p) { super(p); } 
    
}
