package io.qt.qt3d.core;


/**
 * <p>Used to perform transforms on meshes</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html">Qt3DCore::QTransform</a></p>
 */
public class QTransform extends io.qt.qt3d.core.QComponent
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QTransform.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#matrix-prop">Qt3DCore::QTransform::matrixChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="matrix")
    public final Signal0 matrixChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#rotation-prop">Qt3DCore::QTransform::rotationChanged(QQuaternion)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rotation")
    public final Signal1<io.qt.gui.QQuaternion> rotationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#rotationX-prop">Qt3DCore::QTransform::rotationXChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rotationX")
    public final Signal1<@io.qt.QtPrimitiveType Float> rotationXChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#rotationY-prop">Qt3DCore::QTransform::rotationYChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rotationY")
    public final Signal1<@io.qt.QtPrimitiveType Float> rotationYChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#rotationZ-prop">Qt3DCore::QTransform::rotationZChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rotationZ")
    public final Signal1<@io.qt.QtPrimitiveType Float> rotationZChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#scale3D-prop">Qt3DCore::QTransform::scale3DChanged(QVector3D)</a></p>
     */
    @io.qt.QtPropertyNotify(name="scale3D")
    public final Signal1<io.qt.gui.QVector3D> scale3DChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#scale-prop">Qt3DCore::QTransform::scaleChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="scale")
    public final Signal1<@io.qt.QtPrimitiveType Float> scaleChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#translation-prop">Qt3DCore::QTransform::translationChanged(QVector3D)</a></p>
     */
    @io.qt.QtPropertyNotify(name="translation")
    public final Signal1<io.qt.gui.QVector3D> translationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#worldMatrix-prop">Qt3DCore::QTransform::worldMatrixChanged(QMatrix4x4)</a></p>
     */
    @io.qt.QtPropertyNotify(name="worldMatrix")
    public final Signal1<io.qt.gui.QMatrix4x4> worldMatrixChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QTransform(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QTransform() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#QTransform">Qt3DCore::QTransform::QTransform(Qt3DCore::QNode*)</a></p>
     */
    public QTransform(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QTransform instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#matrix-prop">Qt3DCore::QTransform::matrix()const</a></p>
     */
    @io.qt.QtPropertyReader(name="matrix")
    @io.qt.QtUninvokable
    public final io.qt.gui.QMatrix4x4 matrix(){
        return matrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QMatrix4x4 matrix_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#rotation-prop">Qt3DCore::QTransform::rotation()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rotation")
    @io.qt.QtUninvokable
    public final io.qt.gui.QQuaternion rotation(){
        return rotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QQuaternion rotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#rotationX-prop">Qt3DCore::QTransform::rotationX()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rotationX")
    @io.qt.QtUninvokable
    public final float rotationX(){
        return rotationX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float rotationX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#rotationY-prop">Qt3DCore::QTransform::rotationY()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rotationY")
    @io.qt.QtUninvokable
    public final float rotationY(){
        return rotationY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float rotationY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#rotationZ-prop">Qt3DCore::QTransform::rotationZ()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rotationZ")
    @io.qt.QtUninvokable
    public final float rotationZ(){
        return rotationZ_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float rotationZ_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#scale-prop">Qt3DCore::QTransform::scale()const</a></p>
     */
    @io.qt.QtPropertyReader(name="scale")
    @io.qt.QtUninvokable
    public final float scale(){
        return scale_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float scale_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#scale3D-prop">Qt3DCore::QTransform::scale3D()const</a></p>
     */
    @io.qt.QtPropertyReader(name="scale3D")
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector3D scale3D(){
        return scale3D_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector3D scale3D_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#matrix-prop">Qt3DCore::QTransform::setMatrix(QMatrix4x4)</a></p>
     */
    @io.qt.QtPropertyWriter(name="matrix")
    public final void setMatrix(io.qt.gui.QMatrix4x4 matrix){
        setMatrix_native_cref_QMatrix4x4(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(matrix));
    }
    
    private native void setMatrix_native_cref_QMatrix4x4(long __this__nativeId, long matrix);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#rotation-prop">Qt3DCore::QTransform::setRotation(QQuaternion)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rotation")
    public final void setRotation(io.qt.gui.QQuaternion rotation){
        setRotation_native_cref_QQuaternion(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rotation));
    }
    
    private native void setRotation_native_cref_QQuaternion(long __this__nativeId, long rotation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#rotationX-prop">Qt3DCore::QTransform::setRotationX(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rotationX")
    public final void setRotationX(float rotationX){
        setRotationX_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), rotationX);
    }
    
    private native void setRotationX_native_float(long __this__nativeId, float rotationX);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#rotationY-prop">Qt3DCore::QTransform::setRotationY(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rotationY")
    public final void setRotationY(float rotationY){
        setRotationY_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), rotationY);
    }
    
    private native void setRotationY_native_float(long __this__nativeId, float rotationY);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#rotationZ-prop">Qt3DCore::QTransform::setRotationZ(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rotationZ")
    public final void setRotationZ(float rotationZ){
        setRotationZ_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), rotationZ);
    }
    
    private native void setRotationZ_native_float(long __this__nativeId, float rotationZ);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#scale-prop">Qt3DCore::QTransform::setScale(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="scale")
    public final void setScale(float scale){
        setScale_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), scale);
    }
    
    private native void setScale_native_float(long __this__nativeId, float scale);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#scale3D-prop">Qt3DCore::QTransform::setScale3D(QVector3D)</a></p>
     */
    @io.qt.QtPropertyWriter(name="scale3D")
    public final void setScale3D(io.qt.gui.QVector3D scale){
        setScale3D_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scale));
    }
    
    private native void setScale3D_native_cref_QVector3D(long __this__nativeId, long scale);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#translation-prop">Qt3DCore::QTransform::setTranslation(QVector3D)</a></p>
     */
    @io.qt.QtPropertyWriter(name="translation")
    public final void setTranslation(io.qt.gui.QVector3D translation){
        setTranslation_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(translation));
    }
    
    private native void setTranslation_native_cref_QVector3D(long __this__nativeId, long translation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#translation-prop">Qt3DCore::QTransform::translation()const</a></p>
     */
    @io.qt.QtPropertyReader(name="translation")
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector3D translation(){
        return translation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector3D translation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#worldMatrix">Qt3DCore::QTransform::worldMatrix()const</a></p>
     */
    @io.qt.QtPropertyReader(name="worldMatrix")
    @io.qt.QtUninvokable
    public final io.qt.gui.QMatrix4x4 worldMatrix(){
        return worldMatrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QMatrix4x4 worldMatrix_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#fromAxes">Qt3DCore::QTransform::fromAxes(QVector3D,QVector3D,QVector3D)</a></p>
     */
    public static io.qt.gui.QQuaternion fromAxes(io.qt.gui.QVector3D xAxis, io.qt.gui.QVector3D yAxis, io.qt.gui.QVector3D zAxis){
        return fromAxes_native_cref_QVector3D_cref_QVector3D_cref_QVector3D(QtJambi_LibraryUtilities.internal.checkedNativeId(xAxis), QtJambi_LibraryUtilities.internal.checkedNativeId(yAxis), QtJambi_LibraryUtilities.internal.checkedNativeId(zAxis));
    }
    
    private native static io.qt.gui.QQuaternion fromAxes_native_cref_QVector3D_cref_QVector3D_cref_QVector3D(long xAxis, long yAxis, long zAxis);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#fromAxesAndAngles">Qt3DCore::QTransform::fromAxesAndAngles(QVector3D,float,QVector3D,float)</a></p>
     */
    public static io.qt.gui.QQuaternion fromAxesAndAngles(io.qt.gui.QVector3D axis1, float angle1, io.qt.gui.QVector3D axis2, float angle2){
        return fromAxesAndAngles_native_cref_QVector3D_float_cref_QVector3D_float(QtJambi_LibraryUtilities.internal.checkedNativeId(axis1), angle1, QtJambi_LibraryUtilities.internal.checkedNativeId(axis2), angle2);
    }
    
    private native static io.qt.gui.QQuaternion fromAxesAndAngles_native_cref_QVector3D_float_cref_QVector3D_float(long axis1, float angle1, long axis2, float angle2);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#fromAxesAndAngles-1">Qt3DCore::QTransform::fromAxesAndAngles(QVector3D,float,QVector3D,float,QVector3D,float)</a></p>
     */
    public static io.qt.gui.QQuaternion fromAxesAndAngles(io.qt.gui.QVector3D axis1, float angle1, io.qt.gui.QVector3D axis2, float angle2, io.qt.gui.QVector3D axis3, float angle3){
        return fromAxesAndAngles_native_cref_QVector3D_float_cref_QVector3D_float_cref_QVector3D_float(QtJambi_LibraryUtilities.internal.checkedNativeId(axis1), angle1, QtJambi_LibraryUtilities.internal.checkedNativeId(axis2), angle2, QtJambi_LibraryUtilities.internal.checkedNativeId(axis3), angle3);
    }
    
    private native static io.qt.gui.QQuaternion fromAxesAndAngles_native_cref_QVector3D_float_cref_QVector3D_float_cref_QVector3D_float(long axis1, float angle1, long axis2, float angle2, long axis3, float angle3);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#fromAxisAndAngle">Qt3DCore::QTransform::fromAxisAndAngle(QVector3D,float)</a></p>
     */
    public static io.qt.gui.QQuaternion fromAxisAndAngle(io.qt.gui.QVector3D axis, float angle){
        return fromAxisAndAngle_native_cref_QVector3D_float(QtJambi_LibraryUtilities.internal.checkedNativeId(axis), angle);
    }
    
    private native static io.qt.gui.QQuaternion fromAxisAndAngle_native_cref_QVector3D_float(long axis, float angle);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#fromAxisAndAngle-1">Qt3DCore::QTransform::fromAxisAndAngle(float,float,float,float)</a></p>
     */
    public native static io.qt.gui.QQuaternion fromAxisAndAngle(float x, float y, float z, float angle);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#fromEulerAngles">Qt3DCore::QTransform::fromEulerAngles(QVector3D)</a></p>
     */
    public static io.qt.gui.QQuaternion fromEulerAngles(io.qt.gui.QVector3D eulerAngles){
        return fromEulerAngles_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.checkedNativeId(eulerAngles));
    }
    
    private native static io.qt.gui.QQuaternion fromEulerAngles_native_cref_QVector3D(long eulerAngles);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#fromEulerAngles-1">Qt3DCore::QTransform::fromEulerAngles(float,float,float)</a></p>
     */
    public native static io.qt.gui.QQuaternion fromEulerAngles(float pitch, float yaw, float roll);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#rotateAround">Qt3DCore::QTransform::rotateAround(QVector3D,float,QVector3D)</a></p>
     */
    public static io.qt.gui.QMatrix4x4 rotateAround(io.qt.gui.QVector3D point, float angle, io.qt.gui.QVector3D axis){
        return rotateAround_native_cref_QVector3D_float_cref_QVector3D(QtJambi_LibraryUtilities.internal.checkedNativeId(point), angle, QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    private native static io.qt.gui.QMatrix4x4 rotateAround_native_cref_QVector3D_float_cref_QVector3D(long point, float angle, long axis);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3dcore-qtransform.html#rotateFromAxes">Qt3DCore::QTransform::rotateFromAxes(QVector3D,QVector3D,QVector3D)</a></p>
     */
    public static io.qt.gui.QMatrix4x4 rotateFromAxes(io.qt.gui.QVector3D xAxis, io.qt.gui.QVector3D yAxis, io.qt.gui.QVector3D zAxis){
        return rotateFromAxes_native_cref_QVector3D_cref_QVector3D_cref_QVector3D(QtJambi_LibraryUtilities.internal.checkedNativeId(xAxis), QtJambi_LibraryUtilities.internal.checkedNativeId(yAxis), QtJambi_LibraryUtilities.internal.checkedNativeId(zAxis));
    }
    
    private native static io.qt.gui.QMatrix4x4 rotateFromAxes_native_cref_QVector3D_cref_QVector3D_cref_QVector3D(long xAxis, long yAxis, long zAxis);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QTransform(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QTransform(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QTransform instance, QDeclarativeConstructor constructor);
    
}
