package io.qt.qt3d.core;


/**
 * <p>Used to load a skeleton of joints from file</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qt3dcore-qskeletonloader.html">Qt3DCore::QSkeletonLoader</a></p>
 */
public class QSkeletonLoader extends io.qt.qt3d.core.QAbstractSkeleton
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSkeletonLoader.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3dcore-qskeletonloader.html#Status-enum">Qt3DCore::QSkeletonLoader::Status</a></p>
     */
    public enum Status implements io.qt.QtEnumerator {
        NotReady(0),
        Ready(1),
        Error(2);

        private Status(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Status resolve(int value) {
            switch (value) {
            case 0: return NotReady;
            case 1: return Ready;
            case 2: return Error;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qskeletonloader.html#createJointsEnabled-prop">Qt3DCore::QSkeletonLoader::createJointsEnabledChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="createJointsEnabled")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> createJointsEnabledChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qskeletonloader.html#rootJoint-prop">Qt3DCore::QSkeletonLoader::rootJointChanged(Qt3DCore::QJoint*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rootJoint")
    public final Signal1<io.qt.qt3d.core.QJoint> rootJointChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qskeletonloader.html#source-prop">Qt3DCore::QSkeletonLoader::sourceChanged(QUrl)</a></p>
     */
    @io.qt.QtPropertyNotify(name="source")
    public final Signal1<io.qt.core.QUrl> sourceChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qskeletonloader.html#status-prop">Qt3DCore::QSkeletonLoader::statusChanged(Qt3DCore::QSkeletonLoader::Status)</a></p>
     */
    @io.qt.QtPropertyNotify(name="status")
    public final Signal1<io.qt.qt3d.core.QSkeletonLoader.Status> statusChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QSkeletonLoader(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QSkeletonLoader() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qskeletonloader.html#QSkeletonLoader">Qt3DCore::QSkeletonLoader::QSkeletonLoader(Qt3DCore::QNode*)</a></p>
     */
    public QSkeletonLoader(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSkeletonLoader instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Overloaded constructor for {@link #QSkeletonLoader(io.qt.core.QUrl, io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QSkeletonLoader(io.qt.core.QUrl source) {
        this(source, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qskeletonloader.html#QSkeletonLoader-1">Qt3DCore::QSkeletonLoader::QSkeletonLoader(QUrl,Qt3DCore::QNode*)</a></p>
     */
    public QSkeletonLoader(io.qt.core.QUrl source, io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, source, parent);
    }
    
    private native static void initialize_native(QSkeletonLoader instance, io.qt.core.QUrl source, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qskeletonloader.html#isCreateJointsEnabled">Qt3DCore::QSkeletonLoader::isCreateJointsEnabled()const</a></p>
     */
    @io.qt.QtPropertyReader(name="createJointsEnabled")
    @io.qt.QtUninvokable
    public final boolean isCreateJointsEnabled(){
        return isCreateJointsEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isCreateJointsEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qskeletonloader.html#rootJoint">Qt3DCore::QSkeletonLoader::rootJoint()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rootJoint")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QJoint rootJoint(){
        return rootJoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.core.QJoint rootJoint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qskeletonloader.html#createJointsEnabled-prop">Qt3DCore::QSkeletonLoader::setCreateJointsEnabled(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="createJointsEnabled")
    public final void setCreateJointsEnabled(boolean enabled){
        setCreateJointsEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    private native void setCreateJointsEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qskeletonloader.html#source-prop">Qt3DCore::QSkeletonLoader::setSource(QUrl)</a></p>
     */
    @io.qt.QtPropertyWriter(name="source")
    public final void setSource(io.qt.core.QUrl source){
        setSource_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    private native void setSource_native_cref_QUrl(long __this__nativeId, long source);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qskeletonloader.html#source-prop">Qt3DCore::QSkeletonLoader::source()const</a></p>
     */
    @io.qt.QtPropertyReader(name="source")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl source(){
        return source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl source_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qskeletonloader.html#status-prop">Qt3DCore::QSkeletonLoader::status()const</a></p>
     */
    @io.qt.QtPropertyReader(name="status")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QSkeletonLoader.Status status(){
        return io.qt.qt3d.core.QSkeletonLoader.Status.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qnode-obsolete.html#sceneChangeEvent">Qt3DCore::QNode::sceneChangeEvent(Qt3DCore::QSceneChangePtr)</a></p>
     */
    @io.qt.QtUninvokable
    protected void sceneChangeEvent(io.qt.qt3d.core.QSceneChange change){
        sceneChangeEvent_native_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), change);
    }
    
    @io.qt.QtUninvokable
    private native void sceneChangeEvent_native_cref_QSharedPointer(long __this__nativeId, io.qt.qt3d.core.QSceneChange change);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSkeletonLoader(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QSkeletonLoader(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QSkeletonLoader instance, QDeclarativeConstructor constructor);
    
}
