package io.qt.qt3d.core;


/**
 * <p>Qt3DCore::QEntity is a Qt3DCore::QNode subclass that can aggregate several Qt3DCore::QComponent instances that will specify its behavior</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qt3dcore-qentity.html">Qt3DCore::QEntity</a></p>
 */
public class QEntity extends io.qt.qt3d.core.QNode
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QEntity.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QEntity(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QEntity() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qentity.html#QEntity">Qt3DCore::QEntity::QEntity(Qt3DCore::QNode*)</a></p>
     */
    public QEntity(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QEntity instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qentity.html#addComponent">Qt3DCore::QEntity::addComponent(Qt3DCore::QComponent*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addComponent(io.qt.qt3d.core.QComponent comp){
        addComponent_native_Qt3DCore_QComponent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(comp));
    }
    
    @io.qt.QtUninvokable
    private native void addComponent_native_Qt3DCore_QComponent_ptr(long __this__nativeId, long comp);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qentity.html#components">Qt3DCore::QEntity::components()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QVector<io.qt.qt3d.core.QComponent> components(){
        return components_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QVector<io.qt.qt3d.core.QComponent> components_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qentity.html#parentEntity">Qt3DCore::QEntity::parentEntity()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QEntity parentEntity(){
        return parentEntity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.core.QEntity parentEntity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qentity.html#removeComponent">Qt3DCore::QEntity::removeComponent(Qt3DCore::QComponent*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeComponent(io.qt.qt3d.core.QComponent comp){
        removeComponent_native_Qt3DCore_QComponent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(comp));
    }
    
    @io.qt.QtUninvokable
    private native void removeComponent_native_Qt3DCore_QComponent_ptr(long __this__nativeId, long comp);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QEntity(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QEntity(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QEntity instance, QDeclarativeConstructor constructor);
    
}
