package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Contains classes that are the foundation for Qt 3D simulation framework, as well as classes that provide the ability to render using the Qt 3D framework</p>
 * <p>Java wrapper for Qt header file <code><a href="http://doc.qt.io/qt-5/qt3dcore.html">Qt3DCore</a></code></p>
 */
public final class Qt3DCore
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private Qt3DCore() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace Qt3DCore."); }
    
    /**
     * <p>Java wrapper for Qt enum <code>Qt3DCore::ChangeFlag</code></p>
     * 
     * @see ChangeFlags
     */
    @Deprecated
    public enum ChangeFlag implements QtFlagEnumerator {
        /**
         * <p>Representing <code>Qt3DCore::<wbr/>NodeCreated</code></p>
         */
        NodeCreated(1),
        /**
         * <p>Representing <code>Qt3DCore::<wbr/>NodeDeleted</code></p>
         */
        NodeDeleted(2),
        /**
         * <p>Representing <code>Qt3DCore::<wbr/>PropertyUpdated</code></p>
         */
        PropertyUpdated(4),
        /**
         * <p>Representing <code>Qt3DCore::<wbr/>PropertyValueAdded</code></p>
         */
        PropertyValueAdded(8),
        /**
         * <p>Representing <code>Qt3DCore::<wbr/>PropertyValueRemoved</code></p>
         */
        PropertyValueRemoved(16),
        /**
         * <p>Representing <code>Qt3DCore::<wbr/>ComponentAdded</code></p>
         */
        ComponentAdded(32),
        /**
         * <p>Representing <code>Qt3DCore::<wbr/>ComponentRemoved</code></p>
         */
        ComponentRemoved(64),
        /**
         * <p>Representing <code>Qt3DCore::<wbr/>CommandRequested</code></p>
         */
        CommandRequested(128),
        /**
         * <p>Representing <code>Qt3DCore::<wbr/>CallbackTriggered</code></p>
         */
        CallbackTriggered(256),
        /**
         * <p>Representing <code>Qt3DCore::<wbr/>AllChanges</code></p>
         */
        AllChanges(-1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ChangeFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull ChangeFlags asFlags() {
            return new ChangeFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull ChangeFlags combined(@NonNull ChangeFlag e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull ChangeFlags cleared(@NonNull ChangeFlag e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link ChangeFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull ChangeFlags flags(@Nullable ChangeFlag @NonNull... values) {
            return new ChangeFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ChangeFlag resolve(int value) {
            switch (value) {
            case 1: return NodeCreated;
            case 2: return NodeDeleted;
            case 4: return PropertyUpdated;
            case 8: return PropertyValueAdded;
            case 16: return PropertyValueRemoved;
            case 32: return ComponentAdded;
            case 64: return ComponentRemoved;
            case 128: return CommandRequested;
            case 256: return CallbackTriggered;
            case -1: return AllChanges;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link ChangeFlag}
     */
    public static final class ChangeFlags extends QFlags<ChangeFlag> implements Comparable<ChangeFlags> {
        private static final long serialVersionUID = 0x9169d12f86dc2faaL;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new ChangeFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public ChangeFlags(@Nullable ChangeFlag @NonNull... args){
            super(args);
        }

        /**
         * Creates a new ChangeFlags with given <code>value</code>.
         * @param value
         */
        public ChangeFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new ChangeFlags
         */
        @Override
        public final @NonNull ChangeFlags combined(@StrictNonNull ChangeFlag e){
            return new ChangeFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull ChangeFlags setFlag(@Nullable ChangeFlag e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull ChangeFlags setFlag(@Nullable ChangeFlag e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this ChangeFlags.
         * @return array of enum entries
         */
        @Override
        public final @NonNull ChangeFlag @NonNull[] flags(){
            return super.flags(ChangeFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull ChangeFlags clone(){
            return new ChangeFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull ChangeFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#qIdForNode">Qt3DCore::<wbr/>qIdForNode(Qt3DCore::QNode*)</a></code></p>
     */
    public static io.qt.qt3d.core.@NonNull QNodeId qIdForNode(io.qt.qt3d.core.@Nullable QNode node){
        return qIdForNode_native_Qt3DCore_QNode_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(node));
    }
    
    private native static io.qt.qt3d.core.QNodeId qIdForNode_native_Qt3DCore_QNode_ptr(long node);
    
}
