package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Used to perform transforms on meshes</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html">Qt3DCore::QTransform</a></code></p>
 */
public class QTransform extends io.qt.qt3d.core.QComponent
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QTransform.class);
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#matrix-prop">Qt3DCore::QTransform::<wbr/>matrixChanged()</a></code></p>
     */
    @QtPropertyNotify(name="matrix")
    public final @NonNull Signal0 matrixChanged = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#rotation-prop">Qt3DCore::QTransform::<wbr/>rotationChanged(QQuaternion)</a></code></p>
     */
    @QtPropertyNotify(name="rotation")
    public final @NonNull Signal1<io.qt.gui.@NonNull QQuaternion> rotationChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#rotationX-prop">Qt3DCore::QTransform::<wbr/>rotationXChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="rotationX")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> rotationXChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#rotationY-prop">Qt3DCore::QTransform::<wbr/>rotationYChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="rotationY")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> rotationYChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#rotationZ-prop">Qt3DCore::QTransform::<wbr/>rotationZChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="rotationZ")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> rotationZChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#scale3D-prop">Qt3DCore::QTransform::<wbr/>scale3DChanged(QVector3D)</a></code></p>
     */
    @QtPropertyNotify(name="scale3D")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> scale3DChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#scale-prop">Qt3DCore::QTransform::<wbr/>scaleChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="scale")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> scaleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#translation-prop">Qt3DCore::QTransform::<wbr/>translationChanged(QVector3D)</a></code></p>
     */
    @QtPropertyNotify(name="translation")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> translationChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#worldMatrix-prop">Qt3DCore::QTransform::<wbr/>worldMatrixChanged(QMatrix4x4)</a></code></p>
     */
    @QtPropertyNotify(name="worldMatrix")
    public final @NonNull Signal1<io.qt.gui.@NonNull QMatrix4x4> worldMatrixChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#QTransform">Qt3DCore::QTransform::<wbr/>QTransform(Qt3DCore::QNode*)</a></code></p>
     */
    public QTransform(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QTransform instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#matrix-prop">Qt3DCore::QTransform::<wbr/>matrix()const</a></code></p>
     */
    @QtPropertyReader(name="matrix")
    @QtUninvokable
    public final io.qt.gui.@NonNull QMatrix4x4 matrix(){
        return matrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QMatrix4x4 matrix_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#rotation-prop">Qt3DCore::QTransform::<wbr/>rotation()const</a></code></p>
     */
    @QtPropertyReader(name="rotation")
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion rotation(){
        return rotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QQuaternion rotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#rotationX-prop">Qt3DCore::QTransform::<wbr/>rotationX()const</a></code></p>
     */
    @QtPropertyReader(name="rotationX")
    @QtUninvokable
    public final float rotationX(){
        return rotationX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float rotationX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#rotationY-prop">Qt3DCore::QTransform::<wbr/>rotationY()const</a></code></p>
     */
    @QtPropertyReader(name="rotationY")
    @QtUninvokable
    public final float rotationY(){
        return rotationY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float rotationY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#rotationZ-prop">Qt3DCore::QTransform::<wbr/>rotationZ()const</a></code></p>
     */
    @QtPropertyReader(name="rotationZ")
    @QtUninvokable
    public final float rotationZ(){
        return rotationZ_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float rotationZ_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#scale-prop">Qt3DCore::QTransform::<wbr/>scale()const</a></code></p>
     */
    @QtPropertyReader(name="scale")
    @QtUninvokable
    public final float scale(){
        return scale_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float scale_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#scale3D-prop">Qt3DCore::QTransform::<wbr/>scale3D()const</a></code></p>
     */
    @QtPropertyReader(name="scale3D")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D scale3D(){
        return scale3D_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D scale3D_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#matrix-prop">Qt3DCore::QTransform::<wbr/>setMatrix(QMatrix4x4)</a></code></p>
     */
    @QtPropertyWriter(name="matrix")
    public final void setMatrix(io.qt.gui.@NonNull QMatrix4x4 matrix){
        setMatrix_native_cref_QMatrix4x4(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(matrix));
    }
    
    private native void setMatrix_native_cref_QMatrix4x4(long __this__nativeId, long matrix);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#rotation-prop">Qt3DCore::QTransform::<wbr/>setRotation(QQuaternion)</a></code></p>
     */
    @QtPropertyWriter(name="rotation")
    public final void setRotation(io.qt.gui.@NonNull QQuaternion rotation){
        setRotation_native_cref_QQuaternion(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rotation));
    }
    
    private native void setRotation_native_cref_QQuaternion(long __this__nativeId, long rotation);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#rotationX-prop">Qt3DCore::QTransform::<wbr/>setRotationX(float)</a></code></p>
     */
    @QtPropertyWriter(name="rotationX")
    public final void setRotationX(float rotationX){
        setRotationX_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), rotationX);
    }
    
    private native void setRotationX_native_float(long __this__nativeId, float rotationX);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#rotationY-prop">Qt3DCore::QTransform::<wbr/>setRotationY(float)</a></code></p>
     */
    @QtPropertyWriter(name="rotationY")
    public final void setRotationY(float rotationY){
        setRotationY_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), rotationY);
    }
    
    private native void setRotationY_native_float(long __this__nativeId, float rotationY);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#rotationZ-prop">Qt3DCore::QTransform::<wbr/>setRotationZ(float)</a></code></p>
     */
    @QtPropertyWriter(name="rotationZ")
    public final void setRotationZ(float rotationZ){
        setRotationZ_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), rotationZ);
    }
    
    private native void setRotationZ_native_float(long __this__nativeId, float rotationZ);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#scale-prop">Qt3DCore::QTransform::<wbr/>setScale(float)</a></code></p>
     */
    @QtPropertyWriter(name="scale")
    public final void setScale(float scale){
        setScale_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), scale);
    }
    
    private native void setScale_native_float(long __this__nativeId, float scale);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#scale3D-prop">Qt3DCore::QTransform::<wbr/>setScale3D(QVector3D)</a></code></p>
     */
    @QtPropertyWriter(name="scale3D")
    public final void setScale3D(io.qt.gui.@NonNull QVector3D scale){
        setScale3D_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scale));
    }
    
    private native void setScale3D_native_cref_QVector3D(long __this__nativeId, long scale);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#translation-prop">Qt3DCore::QTransform::<wbr/>setTranslation(QVector3D)</a></code></p>
     */
    @QtPropertyWriter(name="translation")
    public final void setTranslation(io.qt.gui.@NonNull QVector3D translation){
        setTranslation_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(translation));
    }
    
    private native void setTranslation_native_cref_QVector3D(long __this__nativeId, long translation);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#translation-prop">Qt3DCore::QTransform::<wbr/>translation()const</a></code></p>
     */
    @QtPropertyReader(name="translation")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D translation(){
        return translation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D translation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#worldMatrix">Qt3DCore::QTransform::<wbr/>worldMatrix()const</a></code></p>
     */
    @QtPropertyReader(name="worldMatrix")
    @QtUninvokable
    public final io.qt.gui.@NonNull QMatrix4x4 worldMatrix(){
        return worldMatrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QMatrix4x4 worldMatrix_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode-obsolete.html#sceneChangeEvent">Qt3DCore::QNode::<wbr/>sceneChangeEvent(Qt3DCore::QSceneChangePtr)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void sceneChangeEvent(io.qt.qt3d.core.@Nullable QSceneChange change){
        sceneChangeEvent_native_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), change);
    }
    
    @QtUninvokable
    private native void sceneChangeEvent_native_cref_QSharedPointer(long __this__nativeId, io.qt.qt3d.core.QSceneChange change);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#fromAxes">Qt3DCore::QTransform::<wbr/>fromAxes(QVector3D,<wbr/>QVector3D,<wbr/>QVector3D)</a></code></p>
     */
    public static io.qt.gui.@NonNull QQuaternion fromAxes(io.qt.gui.@NonNull QVector3D xAxis, io.qt.gui.@NonNull QVector3D yAxis, io.qt.gui.@NonNull QVector3D zAxis){
        return fromAxes_native_cref_QVector3D_cref_QVector3D_cref_QVector3D(QtJambi_LibraryUtilities.internal.checkedNativeId(xAxis), QtJambi_LibraryUtilities.internal.checkedNativeId(yAxis), QtJambi_LibraryUtilities.internal.checkedNativeId(zAxis));
    }
    
    private native static io.qt.gui.QQuaternion fromAxes_native_cref_QVector3D_cref_QVector3D_cref_QVector3D(long xAxis, long yAxis, long zAxis);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#fromAxesAndAngles">Qt3DCore::QTransform::<wbr/>fromAxesAndAngles(QVector3D,<wbr/>float,<wbr/>QVector3D,<wbr/>float)</a></code></p>
     */
    public static io.qt.gui.@NonNull QQuaternion fromAxesAndAngles(io.qt.gui.@NonNull QVector3D axis1, float angle1, io.qt.gui.@NonNull QVector3D axis2, float angle2){
        return fromAxesAndAngles_native_cref_QVector3D_float_cref_QVector3D_float(QtJambi_LibraryUtilities.internal.checkedNativeId(axis1), angle1, QtJambi_LibraryUtilities.internal.checkedNativeId(axis2), angle2);
    }
    
    private native static io.qt.gui.QQuaternion fromAxesAndAngles_native_cref_QVector3D_float_cref_QVector3D_float(long axis1, float angle1, long axis2, float angle2);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#fromAxesAndAngles-1">Qt3DCore::QTransform::<wbr/>fromAxesAndAngles(QVector3D,<wbr/>float,<wbr/>QVector3D,<wbr/>float,<wbr/>QVector3D,<wbr/>float)</a></code></p>
     */
    public static io.qt.gui.@NonNull QQuaternion fromAxesAndAngles(io.qt.gui.@NonNull QVector3D axis1, float angle1, io.qt.gui.@NonNull QVector3D axis2, float angle2, io.qt.gui.@NonNull QVector3D axis3, float angle3){
        return fromAxesAndAngles_native_cref_QVector3D_float_cref_QVector3D_float_cref_QVector3D_float(QtJambi_LibraryUtilities.internal.checkedNativeId(axis1), angle1, QtJambi_LibraryUtilities.internal.checkedNativeId(axis2), angle2, QtJambi_LibraryUtilities.internal.checkedNativeId(axis3), angle3);
    }
    
    private native static io.qt.gui.QQuaternion fromAxesAndAngles_native_cref_QVector3D_float_cref_QVector3D_float_cref_QVector3D_float(long axis1, float angle1, long axis2, float angle2, long axis3, float angle3);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#fromAxisAndAngle">Qt3DCore::QTransform::<wbr/>fromAxisAndAngle(QVector3D,<wbr/>float)</a></code></p>
     */
    public static io.qt.gui.@NonNull QQuaternion fromAxisAndAngle(io.qt.gui.@NonNull QVector3D axis, float angle){
        return fromAxisAndAngle_native_cref_QVector3D_float(QtJambi_LibraryUtilities.internal.checkedNativeId(axis), angle);
    }
    
    private native static io.qt.gui.QQuaternion fromAxisAndAngle_native_cref_QVector3D_float(long axis, float angle);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#fromAxisAndAngle-1">Qt3DCore::QTransform::<wbr/>fromAxisAndAngle(float,<wbr/>float,<wbr/>float,<wbr/>float)</a></code></p>
     */
    public native static io.qt.gui.@NonNull QQuaternion fromAxisAndAngle(float x, float y, float z, float angle);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#fromEulerAngles">Qt3DCore::QTransform::<wbr/>fromEulerAngles(QVector3D)</a></code></p>
     */
    public static io.qt.gui.@NonNull QQuaternion fromEulerAngles(io.qt.gui.@NonNull QVector3D eulerAngles){
        return fromEulerAngles_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.checkedNativeId(eulerAngles));
    }
    
    private native static io.qt.gui.QQuaternion fromEulerAngles_native_cref_QVector3D(long eulerAngles);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#fromEulerAngles-1">Qt3DCore::QTransform::<wbr/>fromEulerAngles(float,<wbr/>float,<wbr/>float)</a></code></p>
     */
    public native static io.qt.gui.@NonNull QQuaternion fromEulerAngles(float pitch, float yaw, float roll);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#rotateAround">Qt3DCore::QTransform::<wbr/>rotateAround(QVector3D,<wbr/>float,<wbr/>QVector3D)</a></code></p>
     */
    public static io.qt.gui.@NonNull QMatrix4x4 rotateAround(io.qt.gui.@NonNull QVector3D point, float angle, io.qt.gui.@NonNull QVector3D axis){
        return rotateAround_native_cref_QVector3D_float_cref_QVector3D(QtJambi_LibraryUtilities.internal.checkedNativeId(point), angle, QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    private native static io.qt.gui.QMatrix4x4 rotateAround_native_cref_QVector3D_float_cref_QVector3D(long point, float angle, long axis);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qtransform.html#rotateFromAxes">Qt3DCore::QTransform::<wbr/>rotateFromAxes(QVector3D,<wbr/>QVector3D,<wbr/>QVector3D)</a></code></p>
     */
    public static io.qt.gui.@NonNull QMatrix4x4 rotateFromAxes(io.qt.gui.@NonNull QVector3D xAxis, io.qt.gui.@NonNull QVector3D yAxis, io.qt.gui.@NonNull QVector3D zAxis){
        return rotateFromAxes_native_cref_QVector3D_cref_QVector3D_cref_QVector3D(QtJambi_LibraryUtilities.internal.checkedNativeId(xAxis), QtJambi_LibraryUtilities.internal.checkedNativeId(yAxis), QtJambi_LibraryUtilities.internal.checkedNativeId(zAxis));
    }
    
    private native static io.qt.gui.QMatrix4x4 rotateFromAxes_native_cref_QVector3D_cref_QVector3D_cref_QVector3D(long xAxis, long yAxis, long zAxis);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QTransform(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QTransform(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QTransform instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QTransform(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QTransform() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #matrix()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QMatrix4x4 getMatrix() {
        return matrix();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #rotation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion getRotation() {
        return rotation();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #rotationX()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getRotationX() {
        return rotationX();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #rotationY()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getRotationY() {
        return rotationY();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #rotationZ()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getRotationZ() {
        return rotationZ();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #scale()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getScale() {
        return scale();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #scale3D()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getScale3D() {
        return scale3D();
    }
    
    /**
     * <p>Overloaded function for {@link #setMatrix(io.qt.gui.QMatrix4x4)}.</p>
     */
    public final void setMatrix(io.qt.gui.@NonNull QTransform matrix) {
        setMatrix(new io.qt.gui.QMatrix4x4(matrix));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #translation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getTranslation() {
        return translation();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #worldMatrix()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QMatrix4x4 getWorldMatrix() {
        return worldMatrix();
    }
}
