package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Base class for changes that can be sent and received by Qt3D's change notification system</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qt3dcore-qscenechange.html">Qt3DCore::QSceneChange</a></code></p>
 */
public class QSceneChange extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qt3dcore-qscenechange.html#DeliveryFlag-enum">Qt3DCore::QSceneChange::DeliveryFlag</a></code></p>
     * 
     * @see DeliveryFlags
     */
    public enum DeliveryFlag implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qt3dcore-qscenechange.html#DeliveryFlag-enum">Qt3DCore::<wbr/>QSceneChange::<wbr/>BackendNodes</a></code></p>
         */
        BackendNodes(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qt3dcore-qscenechange.html#DeliveryFlag-enum">Qt3DCore::<wbr/>QSceneChange::<wbr/>Nodes</a></code></p>
         */
        Nodes(16),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qt3dcore-qscenechange.html#DeliveryFlag-enum">Qt3DCore::<wbr/>QSceneChange::<wbr/>DeliverToAll</a></code></p>
         */
        DeliverToAll(17);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DeliveryFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull DeliveryFlags asFlags() {
            return new DeliveryFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull DeliveryFlags combined(@NonNull DeliveryFlag e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull DeliveryFlags cleared(@NonNull DeliveryFlag e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link DeliveryFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull DeliveryFlags flags(@Nullable DeliveryFlag @NonNull... values) {
            return new DeliveryFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DeliveryFlag resolve(int value) {
            switch (value) {
            case 1: return BackendNodes;
            case 16: return Nodes;
            case 17: return DeliverToAll;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link DeliveryFlag}
     */
    public static final class DeliveryFlags extends QFlags<DeliveryFlag> implements Comparable<DeliveryFlags> {
        private static final long serialVersionUID = 0xd215981eadbc8437L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new DeliveryFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public DeliveryFlags(@Nullable DeliveryFlag @NonNull... args){
            super(args);
        }

        /**
         * Creates a new DeliveryFlags with given <code>value</code>.
         * @param value
         */
        public DeliveryFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new DeliveryFlags
         */
        @Override
        public final @NonNull DeliveryFlags combined(@StrictNonNull DeliveryFlag e){
            return new DeliveryFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull DeliveryFlags setFlag(@Nullable DeliveryFlag e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull DeliveryFlags setFlag(@Nullable DeliveryFlag e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this DeliveryFlags.
         * @return array of enum entries
         */
        @Override
        public final @NonNull DeliveryFlag @NonNull[] flags(){
            return super.flags(DeliveryFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull DeliveryFlags clone(){
            return new DeliveryFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull DeliveryFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qscenechange.html#QSceneChange">Qt3DCore::QSceneChange::<wbr/>QSceneChange(Qt3DCore::ChangeFlag,<wbr/>Qt3DCore::QNodeId)</a></code></p>
     */
    protected QSceneChange(io.qt.qt3d.core.Qt3DCore.@NonNull ChangeFlag type, io.qt.qt3d.core.@NonNull QNodeId subjectId){
        super((QPrivateConstructor)null);
        initialize_native(this, type, subjectId);
    }
    
    private native static void initialize_native(QSceneChange instance, io.qt.qt3d.core.Qt3DCore.ChangeFlag type, io.qt.qt3d.core.QNodeId subjectId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qscenechange.html#deliveryFlags">Qt3DCore::QSceneChange::<wbr/>deliveryFlags()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.core.QSceneChange.@NonNull DeliveryFlags deliveryFlags(){
        return new io.qt.qt3d.core.QSceneChange.DeliveryFlags(deliveryFlags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int deliveryFlags_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qscenechange.html#setDeliveryFlags">Qt3DCore::QSceneChange::<wbr/>setDeliveryFlags(Qt3DCore::QSceneChange::DeliveryFlags)</a></code></p>
     */
    @QtUninvokable
    public final void setDeliveryFlags(io.qt.qt3d.core.QSceneChange.@NonNull DeliveryFlags flags){
        setDeliveryFlags_native_Qt3DCore_QSceneChange_DeliveryFlags(QtJambi_LibraryUtilities.internal.nativeId(this), flags.value());
    }
    
    @QtUninvokable
    private native void setDeliveryFlags_native_Qt3DCore_QSceneChange_DeliveryFlags(long __this__nativeId, int flags);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qscenechange.html#subjectId">Qt3DCore::QSceneChange::<wbr/>subjectId()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.core.@NonNull QNodeId subjectId(){
        return subjectId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QNodeId subjectId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qscenechange.html#type">Qt3DCore::QSceneChange::<wbr/>type()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.core.Qt3DCore.@NonNull ChangeFlag type(){
        return io.qt.qt3d.core.Qt3DCore.ChangeFlag.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSceneChange(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded function for {@link #setDeliveryFlags(io.qt.qt3d.core.QSceneChange.DeliveryFlags)}.</p>
     */
    @QtUninvokable
    public final void setDeliveryFlags(io.qt.qt3d.core.QSceneChange.@NonNull DeliveryFlag @NonNull... flags) {
        setDeliveryFlags(new io.qt.qt3d.core.QSceneChange.DeliveryFlags(flags));
    }
}
