package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>The base class of all Qt3D node classes used to build a Qt3D scene</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html">Qt3DCore::QNode</a></code></p>
 */
public class QNode extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QNode.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#PropertyTrackingMode-enum">Qt3DCore::QNode::PropertyTrackingMode</a></code></p>
     */
    public enum PropertyTrackingMode implements QtShortEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#PropertyTrackingMode-enum">Qt3DCore::<wbr/>QNode::<wbr/>TrackFinalValues</a></code></p>
         */
        TrackFinalValues((short)0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#PropertyTrackingMode-enum">Qt3DCore::<wbr/>QNode::<wbr/>DontTrackValues</a></code></p>
         */
        DontTrackValues((short)1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#PropertyTrackingMode-enum">Qt3DCore::<wbr/>QNode::<wbr/>TrackAllValues</a></code></p>
         */
        TrackAllValues((short)2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PropertyTrackingMode(short value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public short value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PropertyTrackingMode resolve(short value) {
            switch (value) {
            case 0: return TrackFinalValues;
            case 1: return DontTrackValues;
            case 2: return TrackAllValues;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final short value;
    }
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#defaultPropertyTrackingMode-prop">Qt3DCore::QNode::<wbr/>defaultPropertyTrackingModeChanged(Qt3DCore::QNode::PropertyTrackingMode)</a></code></p>
     */
    @QtPropertyNotify(name="defaultPropertyTrackingMode")
    public final @NonNull Signal1<io.qt.qt3d.core.QNode.@NonNull PropertyTrackingMode> defaultPropertyTrackingModeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#enabled-prop">Qt3DCore::QNode::<wbr/>enabledChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="enabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> enabledChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#nodeDestroyed">Qt3DCore::QNode::<wbr/>nodeDestroyed()</a></code></p>
     */
    public final @NonNull Signal0 nodeDestroyed = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#parent-prop">Qt3DCore::QNode::<wbr/>parentChanged(QObject*)</a></code></p>
     */
    @QtPropertyNotify(name="parent")
    public final @NonNull Signal1<io.qt.core.@Nullable QObject> parentChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#QNode">Qt3DCore::QNode::<wbr/>QNode(Qt3DCore::QNode*)</a></code></p>
     */
    public QNode(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QNode instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#blockNotifications">Qt3DCore::QNode::<wbr/>blockNotifications(bool)</a></code></p>
     */
    @QtUninvokable
    public final boolean blockNotifications(boolean block){
        return blockNotifications_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), block);
    }
    
    @QtUninvokable
    private native boolean blockNotifications_native_bool(long __this__nativeId, boolean block);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#childNodes">Qt3DCore::QNode::<wbr/>childNodes()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QVector<io.qt.qt3d.core.@Nullable QNode> childNodes(){
        return childNodes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QVector<io.qt.qt3d.core.QNode> childNodes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#clearPropertyTracking">Qt3DCore::QNode::<wbr/>clearPropertyTracking(QString)</a></code></p>
     */
    @QtUninvokable
    public final void clearPropertyTracking(java.lang.@NonNull String propertyName){
        clearPropertyTracking_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), propertyName);
    }
    
    @QtUninvokable
    private native void clearPropertyTracking_native_cref_QString(long __this__nativeId, java.lang.String propertyName);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#clearPropertyTrackings">Qt3DCore::QNode::<wbr/>clearPropertyTrackings()</a></code></p>
     */
    @QtUninvokable
    public final void clearPropertyTrackings(){
        clearPropertyTrackings_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clearPropertyTrackings_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#defaultPropertyTrackingMode">Qt3DCore::QNode::<wbr/>defaultPropertyTrackingMode()const</a></code></p>
     */
    @QtPropertyReader(name="defaultPropertyTrackingMode")
    @QtUninvokable
    public final io.qt.qt3d.core.QNode.@NonNull PropertyTrackingMode defaultPropertyTrackingMode(){
        return io.qt.qt3d.core.QNode.PropertyTrackingMode.resolve(defaultPropertyTrackingMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native short defaultPropertyTrackingMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#id">Qt3DCore::QNode::<wbr/>id()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.core.@NonNull QNodeId id(){
        return id_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QNodeId id_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#enabled-prop">Qt3DCore::QNode::<wbr/>isEnabled()const</a></code></p>
     */
    @QtPropertyReader(name="enabled")
    @QtUninvokable
    public final boolean isEnabled(){
        return isEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#notificationsBlocked">Qt3DCore::QNode::<wbr/>notificationsBlocked()const</a></code></p>
     */
    @QtUninvokable
    public final boolean notificationsBlocked(){
        return notificationsBlocked_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean notificationsBlocked_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#notifyObservers">Qt3DCore::QNode::<wbr/>notifyObservers(Qt3DCore::QSceneChangePtr)</a></code></p>
     */
    @QtUninvokable
    protected final void notifyObservers(io.qt.qt3d.core.@Nullable QSceneChange change){
        notifyObservers_native_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), change);
    }
    
    @QtUninvokable
    private native void notifyObservers_native_cref_QSharedPointer(long __this__nativeId, io.qt.qt3d.core.QSceneChange change);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#parent-prop">Qt3DCore::QNode::<wbr/>parentNode()const</a></code></p>
     */
    @QtPropertyReader(name="parent")
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QNode parentNode(){
        return parentNode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QNode parentNode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#propertyTracking">Qt3DCore::QNode::<wbr/>propertyTracking(QString)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.core.QNode.@NonNull PropertyTrackingMode propertyTracking(java.lang.@NonNull String propertyName){
        return io.qt.qt3d.core.QNode.PropertyTrackingMode.resolve(propertyTracking_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), propertyName));
    }
    
    @QtUninvokable
    private native short propertyTracking_native_cref_QString_constfct(long __this__nativeId, java.lang.String propertyName);
    
    /**
     * <p>Sends a command message to the backend node</p>
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode-obsolete.html#sendCommand">Qt3DCore::QNode::<wbr/>sendCommand(QString,<wbr/>QVariant,<wbr/>Qt3DCore::QNodeCommand::CommandId)</a></code></p>
     */
    @QtUninvokable
    public final long sendCommand(java.lang.@NonNull String name, java.lang.Object data, long replyTo){
        return sendCommand_native_cref_QString_cref_QVariant_Qt3DCore_QNodeCommand_CommandId(QtJambi_LibraryUtilities.internal.nativeId(this), name, data, replyTo);
    }
    
    @QtUninvokable
    private native long sendCommand_native_cref_QString_cref_QVariant_Qt3DCore_QNodeCommand_CommandId(long __this__nativeId, java.lang.String name, java.lang.Object data, long replyTo);
    
    /**
     * <p>Send a command back to the backend node</p>
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode-obsolete.html#sendReply">Qt3DCore::QNode::<wbr/>sendReply(Qt3DCore::QNodeCommandPtr)</a></code></p>
     */
    @QtUninvokable
    public final void sendReply(io.qt.qt3d.core.@Nullable QNodeCommand command){
        sendReply_native_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), command);
    }
    
    @QtUninvokable
    private native void sendReply_native_cref_QSharedPointer(long __this__nativeId, io.qt.qt3d.core.QNodeCommand command);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#defaultPropertyTrackingMode-prop">Qt3DCore::QNode::<wbr/>setDefaultPropertyTrackingMode(Qt3DCore::QNode::PropertyTrackingMode)</a></code></p>
     */
    @QtPropertyWriter(name="defaultPropertyTrackingMode")
    public final void setDefaultPropertyTrackingMode(io.qt.qt3d.core.QNode.@NonNull PropertyTrackingMode mode){
        setDefaultPropertyTrackingMode_native_Qt3DCore_QNode_PropertyTrackingMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    private native void setDefaultPropertyTrackingMode_native_Qt3DCore_QNode_PropertyTrackingMode(long __this__nativeId, short mode);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#enabled-prop">Qt3DCore::QNode::<wbr/>setEnabled(bool)</a></code></p>
     */
    @QtPropertyWriter(name="enabled")
    public final void setEnabled(boolean isEnabled){
        setEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), isEnabled);
    }
    
    private native void setEnabled_native_bool(long __this__nativeId, boolean isEnabled);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#parent-prop">Qt3DCore::QNode::<wbr/>setParent(Qt3DCore::QNode*)</a></code></p>
     */
    @QtPropertyWriter(name="parent")
    public final void setParent(io.qt.qt3d.core.@Nullable QNode parent){
        setParent_native_Qt3DCore_QNode_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    private native void setParent_native_Qt3DCore_QNode_ptr(long __this__nativeId, long parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#setPropertyTracking">Qt3DCore::QNode::<wbr/>setPropertyTracking(QString,<wbr/>Qt3DCore::QNode::PropertyTrackingMode)</a></code></p>
     */
    @QtUninvokable
    public final void setPropertyTracking(java.lang.@NonNull String propertyName, io.qt.qt3d.core.QNode.@NonNull PropertyTrackingMode trackMode){
        setPropertyTracking_native_cref_QString_Qt3DCore_QNode_PropertyTrackingMode(QtJambi_LibraryUtilities.internal.nativeId(this), propertyName, trackMode.value());
    }
    
    @QtUninvokable
    private native void setPropertyTracking_native_cref_QString_Qt3DCore_QNode_PropertyTrackingMode(long __this__nativeId, java.lang.String propertyName, short trackMode);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qnode-obsolete.html#sceneChangeEvent">Qt3DCore::QNode::<wbr/>sceneChangeEvent(Qt3DCore::QSceneChangePtr)</a></code></p>
     */
    @QtUninvokable
    protected void sceneChangeEvent(io.qt.qt3d.core.@Nullable QSceneChange change){
        sceneChangeEvent_native_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), change);
    }
    
    @QtUninvokable
    private native void sceneChangeEvent_native_cref_QSharedPointer(long __this__nativeId, io.qt.qt3d.core.QSceneChange change);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QNode(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QNode(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QNode instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QNode(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QNode() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #defaultPropertyTrackingMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.core.QNode.@NonNull PropertyTrackingMode getDefaultPropertyTrackingMode() {
        return defaultPropertyTrackingMode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getEnabled() {
        return isEnabled();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #parentNode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QNode getParent() {
        return parentNode();
    }
    
    /**
     * <p>Overloaded function for {@link #sendCommand(java.lang.String, java.lang.Object, long)}
     *  with <code>replyTo = 0</code>.</p>
     */
    @QtUninvokable
    public final long sendCommand(java.lang.@NonNull String name, java.lang.Object data) {
        return sendCommand(name, data, (long)0);
    }
    
    /**
     * <p>Overloaded function for {@link #sendCommand(java.lang.String, java.lang.Object, long)}</p>
     * <p>with: </p><ul>
     * <li><code>data = null</code></li>
     * <li><code>replyTo = 0</code></li>
     * </ul>
     */
    @QtUninvokable
    public final long sendCommand(java.lang.@NonNull String name) {
        return sendCommand(name, (java.lang.Object)null, (long)0);
    }
}
