package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Used to notify when a dynamic property value is updated</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qt3dcore-qdynamicpropertyupdatedchange.html">Qt3DCore::QDynamicPropertyUpdatedChange</a></code></p>
 */
public class QDynamicPropertyUpdatedChange extends io.qt.qt3d.core.QPropertyUpdatedChangeBase
{
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qdynamicpropertyupdatedchange.html#QDynamicPropertyUpdatedChange">Qt3DCore::QDynamicPropertyUpdatedChange::<wbr/>QDynamicPropertyUpdatedChange(Qt3DCore::QNodeId)</a></code></p>
     */
    public QDynamicPropertyUpdatedChange(io.qt.qt3d.core.@NonNull QNodeId subjectId){
        super((QPrivateConstructor)null);
        initialize_native(this, subjectId);
    }
    
    private native static void initialize_native(QDynamicPropertyUpdatedChange instance, io.qt.qt3d.core.QNodeId subjectId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qdynamicpropertyupdatedchange.html#propertyName">Qt3DCore::QDynamicPropertyUpdatedChange::<wbr/>propertyName()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray propertyName(){
        return propertyName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray propertyName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qdynamicpropertyupdatedchange.html#setPropertyName">Qt3DCore::QDynamicPropertyUpdatedChange::<wbr/>setPropertyName(QByteArray)</a></code></p>
     */
    @QtUninvokable
    public final void setPropertyName(io.qt.core.@NonNull QByteArray name){
        setPropertyName_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name));
    }
    
    @QtUninvokable
    private native void setPropertyName_native_cref_QByteArray(long __this__nativeId, long name);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qdynamicpropertyupdatedchange.html#setValue">Qt3DCore::QDynamicPropertyUpdatedChange::<wbr/>setValue(QVariant)</a></code></p>
     */
    @QtUninvokable
    public final void setValue(java.lang.Object value){
        setValue_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setValue_native_cref_QVariant(long __this__nativeId, java.lang.Object value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qdynamicpropertyupdatedchange.html#value">Qt3DCore::QDynamicPropertyUpdatedChange::<wbr/>value()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object value(){
        return value_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.Object value_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QDynamicPropertyUpdatedChange(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded function for {@link #setPropertyName(io.qt.core.QByteArray)}.</p>
     */
    @QtUninvokable
    public final void setPropertyName(byte @NonNull[] name) {
        setPropertyName(new io.qt.core.QByteArray(name));
    }
}
