package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Used to notify when a component is added to an entity</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qt3dcore-qcomponentaddedchange.html">Qt3DCore::QComponentAddedChange</a></code></p>
 */
public class QComponentAddedChange extends io.qt.qt3d.core.QSceneChange
{
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qcomponentaddedchange.html#QComponentAddedChange-1">Qt3DCore::QComponentAddedChange::<wbr/>QComponentAddedChange(const Qt3DCore::QComponent*,<wbr/>const Qt3DCore::QEntity*)</a></code></p>
     */
    public QComponentAddedChange(io.qt.qt3d.core.@Nullable QComponent component, io.qt.qt3d.core.@Nullable QEntity entity){
        super((QPrivateConstructor)null);
        initialize_native(this, component, entity);
    }
    
    private native static void initialize_native(QComponentAddedChange instance, io.qt.qt3d.core.QComponent component, io.qt.qt3d.core.QEntity entity);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qcomponentaddedchange.html#QComponentAddedChange">Qt3DCore::QComponentAddedChange::<wbr/>QComponentAddedChange(const Qt3DCore::QEntity*,<wbr/>const Qt3DCore::QComponent*)</a></code></p>
     */
    public QComponentAddedChange(io.qt.qt3d.core.@Nullable QEntity entity, io.qt.qt3d.core.@Nullable QComponent component){
        super((QPrivateConstructor)null);
        initialize_native(this, entity, component);
    }
    
    private native static void initialize_native(QComponentAddedChange instance, io.qt.qt3d.core.QEntity entity, io.qt.qt3d.core.QComponent component);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qcomponentaddedchange.html#componentId">Qt3DCore::QComponentAddedChange::<wbr/>componentId()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.core.@NonNull QNodeId componentId(){
        return componentId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QNodeId componentId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qcomponentaddedchange.html#componentMetaObject">Qt3DCore::QComponentAddedChange::<wbr/>componentMetaObject()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@Nullable QMetaObject componentMetaObject(){
        return componentMetaObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QMetaObject componentMetaObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qcomponentaddedchange.html#entityId">Qt3DCore::QComponentAddedChange::<wbr/>entityId()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.core.@NonNull QNodeId entityId(){
        return entityId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QNodeId entityId_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QComponentAddedChange(QPrivateConstructor p) { super(p); } 
    
}
