package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Base class for all Qt3D backend nodes</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode.html">Qt3DCore::QBackendNode</a></code></p>
 */
public class QBackendNode extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode.html#Mode-enum">Qt3DCore::QBackendNode::Mode</a></code></p>
     */
    public enum Mode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode.html#Mode-enum">Qt3DCore::<wbr/>QBackendNode::<wbr/>ReadOnly</a></code></p>
         */
        ReadOnly(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode.html#Mode-enum">Qt3DCore::<wbr/>QBackendNode::<wbr/>ReadWrite</a></code></p>
         */
        ReadWrite(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Mode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Mode resolve(int value) {
            switch (value) {
            case 0: return ReadOnly;
            case 1: return ReadWrite;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code>Qt3DCore::QBackendNode::<wbr/>QBackendNode(Qt3DCore::QBackendNode::Mode)</code></p>
     */
    public QBackendNode(io.qt.qt3d.core.QBackendNode.@NonNull Mode mode){
        super((QPrivateConstructor)null);
        initialize_native(this, mode);
    }
    
    private native static void initialize_native(QBackendNode instance, io.qt.qt3d.core.QBackendNode.Mode mode);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode.html#isEnabled">Qt3DCore::QBackendNode::<wbr/>isEnabled()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isEnabled(){
        return isEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode.html#mode">Qt3DCore::QBackendNode::<wbr/>mode()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.core.QBackendNode.@NonNull Mode mode(){
        return io.qt.qt3d.core.QBackendNode.Mode.resolve(mode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int mode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode-obsolete.html#notifyObservers">Qt3DCore::QBackendNode::<wbr/>notifyObservers(Qt3DCore::QSceneChangePtr)</a></code></p>
     */
    @QtUninvokable
    protected final void notifyObservers(io.qt.qt3d.core.@Nullable QSceneChange e){
        notifyObservers_native_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), e);
    }
    
    @QtUninvokable
    private native void notifyObservers_native_cref_QSharedPointer(long __this__nativeId, io.qt.qt3d.core.QSceneChange e);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode.html#peerId">Qt3DCore::QBackendNode::<wbr/>peerId()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.core.@NonNull QNodeId peerId(){
        return peerId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QNodeId peerId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode-obsolete.html#sendCommand">Qt3DCore::QBackendNode::<wbr/>sendCommand(QString,<wbr/>QVariant,<wbr/>Qt3DCore::QNodeCommand::CommandId)</a></code></p>
     */
    @QtUninvokable
    protected final long sendCommand(java.lang.@NonNull String name, java.lang.Object data, long replyTo){
        return sendCommand_native_cref_QString_cref_QVariant_Qt3DCore_QNodeCommand_CommandId(QtJambi_LibraryUtilities.internal.nativeId(this), name, data, replyTo);
    }
    
    @QtUninvokable
    private native long sendCommand_native_cref_QString_cref_QVariant_Qt3DCore_QNodeCommand_CommandId(long __this__nativeId, java.lang.String name, java.lang.Object data, long replyTo);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode-obsolete.html#sendReply">Qt3DCore::QBackendNode::<wbr/>sendReply(Qt3DCore::QNodeCommandPtr)</a></code></p>
     */
    @QtUninvokable
    protected final void sendReply(io.qt.qt3d.core.@Nullable QNodeCommand command){
        sendReply_native_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), command);
    }
    
    @QtUninvokable
    private native void sendReply_native_cref_QSharedPointer(long __this__nativeId, io.qt.qt3d.core.QNodeCommand command);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode.html#setEnabled">Qt3DCore::QBackendNode::<wbr/>setEnabled(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setEnabled(boolean enabled){
        setEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode-obsolete.html#sceneChangeEvent">Qt3DCore::QBackendNode::<wbr/>sceneChangeEvent(Qt3DCore::QSceneChangePtr)</a></code></p>
     */
    @QtUninvokable
    protected void sceneChangeEvent(io.qt.qt3d.core.@Nullable QSceneChange e){
        sceneChangeEvent_native_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), e);
    }
    
    @QtUninvokable
    private native void sceneChangeEvent_native_cref_QSharedPointer(long __this__nativeId, io.qt.qt3d.core.QSceneChange e);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QBackendNode(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded constructor for {@link #QBackendNode(io.qt.qt3d.core.QBackendNode.Mode)}
     *  with <code>mode = io.qt.qt3d.core.QBackendNode.Mode.ReadOnly</code>.</p>
     */
    public QBackendNode() {
        this(io.qt.qt3d.core.QBackendNode.Mode.ReadOnly);
    }
    
    /**
     * <p>Overloaded function for {@link #sendCommand(java.lang.String, java.lang.Object, long)}
     *  with <code>replyTo = 0</code>.</p>
     */
    @QtUninvokable
    protected final long sendCommand(java.lang.@NonNull String name, java.lang.Object data) {
        return sendCommand(name, data, (long)0);
    }
}
