package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Contains classes that are the foundation for Qt 3D simulation framework, as well as classes that provide the ability to render using the Qt 3D framework</p>
 * <p>Java wrapper for Qt's namespace <a href="http://doc.qt.io/qt-5/qt3dcore.html">Qt3DCore</a></p>
 */
public final class Qt3DCore
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private Qt3DCore() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace Qt3DCore."); }
    
    /**
     * <p>Java wrapper for Qt enum Qt3DCore::ChangeFlag</p>
     * 
     * @see ChangeFlags
     */
    @Deprecated
    public enum ChangeFlag implements QtFlagEnumerator {
        NodeCreated(1),
        NodeDeleted(2),
        PropertyUpdated(4),
        PropertyValueAdded(8),
        PropertyValueRemoved(16),
        ComponentAdded(32),
        ComponentRemoved(64),
        CommandRequested(128),
        CallbackTriggered(256),
        AllChanges(-1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ChangeFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public ChangeFlags asFlags() {
            return new ChangeFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public ChangeFlags combined(ChangeFlag e) {
            return new ChangeFlags(this, e);
        }

        /**
         * Creates a new {@link ChangeFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static ChangeFlags flags(ChangeFlag ... values) {
            return new ChangeFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ChangeFlag resolve(int value) {
            switch (value) {
            case 1: return NodeCreated;
            case 2: return NodeDeleted;
            case 4: return PropertyUpdated;
            case 8: return PropertyValueAdded;
            case 16: return PropertyValueRemoved;
            case 32: return ComponentAdded;
            case 64: return ComponentRemoved;
            case 128: return CommandRequested;
            case 256: return CallbackTriggered;
            case -1: return AllChanges;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link ChangeFlag}
     */
    public static final class ChangeFlags extends QFlags<ChangeFlag> implements Comparable<ChangeFlags> {
        private static final long serialVersionUID = 0x9169d12f86dc2faaL;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new ChangeFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public ChangeFlags(ChangeFlag ... args){
            super(args);
        }

        /**
         * Creates a new ChangeFlags with given <code>value</code>.
         * @param value
         */
        public ChangeFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new ChangeFlags
         */
        @Override
        public final ChangeFlags combined(ChangeFlag e){
            return new ChangeFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final ChangeFlags setFlag(ChangeFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final ChangeFlags setFlag(ChangeFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this ChangeFlags.
         * @return array of enum entries
         */
        @Override
        public final ChangeFlag[] flags(){
            return super.flags(ChangeFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final ChangeFlags clone(){
            return new ChangeFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(ChangeFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qnode.html#qIdForNode">Qt3DCore::qIdForNode(Qt3DCore::QNode*)</a></p>
     */
    public static io.qt.qt3d.core.@NonNull QNodeId qIdForNode(io.qt.qt3d.core.@Nullable QNode node){
        return qIdForNode_native_Qt3DCore_QNode_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(node));
    }
    
    private native static io.qt.qt3d.core.QNodeId qIdForNode_native_Qt3DCore_QNode_ptr(long node);
    
}
